/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.ext.HibernateExtension;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.views.AbstractReconcilingStrategy;
import org.hibernate.eclipse.hqleditor.HQLEditor;
import org.hibernate.eclipse.hqleditor.HQLEditorDocumentSetupParticipant;
import org.hibernate.eclipse.hqleditor.HQLSourceViewer;
import org.hibernate.eclipse.hqleditor.HQLSourceViewerConfiguration;
import org.hibernate.util.xpl.StringHelper;

public class DynamicSQLPreviewView
extends ViewPart {
    private IPartListener2 partListener = new IPartListener2(){

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == DynamicSQLPreviewView.this.currentEditor) {
                DynamicSQLPreviewView.this.setCurrentEditor(null);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
            DynamicSQLPreviewView.this.hookIntoEditor(partRef);
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            DynamicSQLPreviewView.this.hookIntoEditor(partRef);
        }
    };
    private SourceViewer textViewer;
    private HQLEditor currentEditor;
    private MonoReconciler reconciler;
    private HQLEditorDocumentSetupParticipant docSetupParticipant = new HQLEditorDocumentSetupParticipant();

    private void hookIntoEditor(IWorkbenchPartReference partRef) {
        if (partRef == null) {
            this.setCurrentEditor(null);
            return;
        }
        IWorkbenchPart part = partRef.getPart(false);
        if (part != null && part instanceof HQLEditor) {
            this.setCurrentEditor((HQLEditor)part);
        }
    }

    private void setCurrentEditor(HQLEditor editor) {
        if (editor == this.currentEditor) {
            this.updateText(this.currentEditor);
            return;
        }
        if (this.currentEditor != null) {
            this.reconciler.uninstall();
        }
        this.currentEditor = editor;
        if (this.currentEditor != null) {
            ITextViewer editorViewer = this.currentEditor.getTextViewer();
            this.reconciler.install(editorViewer);
        }
        this.updateText(this.currentEditor);
    }

    private void updateText(HQLEditor editor) {
        if (this.textViewer != null && this.textViewer.getDocument() != null) {
            if (editor != null) {
                ConsoleConfiguration consoleConfiguration = editor.getConsoleConfiguration();
                if (StringHelper.isEmpty((String)editor.getQueryString())) {
                    this.textViewer.getDocument().set(HibernateConsoleMessages.DynamicSQLPreviewView_empty_hql_query);
                } else if (consoleConfiguration != null) {
                    HibernateExtension hibernateExtension = consoleConfiguration.getHibernateExtension();
                    if (hibernateExtension.isSessionFactoryCreated()) {
                        String generateSQL = hibernateExtension.generateSQL(editor.getQueryString());
                        if (StringHelper.isEmpty((String)generateSQL)) {
                            this.textViewer.getDocument().set(HibernateConsoleMessages.DynamicSQLPreviewView_no_sql_generated);
                        } else {
                            this.textViewer.getDocument().set(generateSQL);
                        }
                    } else {
                        this.textViewer.getDocument().set(String.valueOf(HibernateConsoleMessages.DynamicSQLPreviewView_session_factory_not_created) + consoleConfiguration.getName());
                    }
                } else {
                    this.textViewer.getDocument().set(HibernateConsoleMessages.DynamicSQLPreviewView_no_console_conf_associated);
                }
            } else {
                this.textViewer.getDocument().set(HibernateConsoleMessages.DynamicSQLPreviewView_no_hql_query_editor);
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.textViewer = new HQLSourceViewer(parent, (IVerticalRuler)new VerticalRuler(1), null, false, 776);
        Document doc = new Document();
        this.textViewer.setDocument((IDocument)doc);
        this.docSetupParticipant.setup((IDocument)doc);
        this.textViewer.getDocument().set(HibernateConsoleMessages.DynamicSQLPreviewView_no_hql_query_editor_selected);
        this.textViewer.configure((SourceViewerConfiguration)new HQLSourceViewerConfiguration(null));
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPartService service = window.getPartService();
        this.hookIntoEditor(service.getActivePartReference());
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        AbstractReconcilingStrategy strategy = new AbstractReconcilingStrategy(){

            @Override
            protected void doReconcile(IDocument doc) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DynamicSQLPreviewView.this.updateText(DynamicSQLPreviewView.this.currentEditor);
                    }
                });
            }
        };
        this.reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        this.reconciler.setDelay(500);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPartService service = window.getPartService();
        service.addPartListener(this.partListener);
        this.hookIntoEditor(service.getActivePartReference());
    }

    public void dispose() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPartService service = window.getPartService();
        service.removePartListener(this.partListener);
        this.docSetupParticipant.unsetup();
        super.dispose();
    }

    public void setFocus() {
    }
}

