/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.jboss.tools.common.model.filesystems.impl.JarSystemImpl;
import org.jboss.tools.common.model.filesystems.impl.LFileObject;
import org.jboss.tools.common.model.filesystems.impl.LFileObjectJarImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.FileUtil;

public class JarAccess {
    private String location = null;
    private String templocation = null;
    private ZipFile jar = null;
    int jarLock = 0;
    private Map<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
    private Map<String, Long> fileEntries = new HashMap<String, Long>();
    private boolean loading = false;
    private boolean exists = false;
    private long timeStamp = -1L;
    private long size = -1L;
    List<String> errors = new ArrayList<String>();
    JarSystemImpl main = null;
    Set<JarSystemImpl> slaves = new HashSet<JarSystemImpl>();

    public List<String> getErrors() {
        return this.errors;
    }

    public void setLocation(String location) {
        this.location = location;
        this.validate();
    }

    public synchronized void lockJar() {
        ++this.jarLock;
    }

    public String getLocation() {
        return this.location;
    }

    public synchronized boolean isLoaded() {
        return this.exists || this.loading;
    }

    public synchronized void validate() {
        if (this.isLoaded()) {
            return;
        }
        this.loading = true;
        this.templocation = null;
        try {
            try {
                int ind = this.location.indexOf(":/");
                if (ind != 1 && ind != -1) {
                    int extI = this.location.lastIndexOf(46);
                    String ext = extI >= 0 ? this.location.substring(extI) : ".jar";
                    File f = File.createTempFile("efs_", ext);
                    f.deleteOnExit();
                    InputStream i = new URL(this.location).openConnection().getInputStream();
                    FileOutputStream o = new FileOutputStream(f);
                    FileUtil.copy((InputStream)i, (OutputStream)o);
                    this.timeStamp = -1L;
                    this.size = -1L;
                    this.templocation = f.getCanonicalPath();
                } else {
                    File nf = new File(this.location);
                    this.templocation = nf.getCanonicalPath();
                    this.timeStamp = nf.lastModified();
                    this.size = nf.length();
                }
                this.init();
                this.exists = true;
            }
            catch (IOException iOException) {
                this.timeStamp = -1L;
                this.size = -1L;
                this.exists = false;
                this.loading = false;
                return;
            }
        }
        finally {
            this.loading = false;
        }
    }

    private void init() throws IOException {
        ZipFile jar = this.getZipFile();
        this.map.clear();
        this.fileEntries.clear();
        this.map.put("", new HashSet());
        try {
            if (jar == null) {
                return;
            }
            Enumeration<? extends ZipEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                String name = entry.getName();
                if (name != null && name.endsWith(".class")) continue;
                if (name != null && !name.endsWith("/") && entry.getSize() > 0L) {
                    this.fileEntries.put(name, entry.getSize());
                }
                this.register(name);
            }
        }
        finally {
            this.unlockJar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipFile getZipFile() throws IOException {
        JarAccess jarAccess = this;
        synchronized (jarAccess) {
            block5: {
                this.lockJar();
                if (new File(this.templocation).isFile()) break block5;
                return null;
            }
            if (this.jar != null) {
                return this.jar;
            }
            this.jar = new ZipFile(this.templocation);
            return this.jar;
        }
    }

    public synchronized void unlockJar() {
        --this.jarLock;
        if (this.jarLock > 0 || this.jar == null) {
            return;
        }
        if (this.jar != null && this.jarLock == 0) {
            try {
                try {
                    this.jar.close();
                }
                catch (IOException iOException) {
                    this.jar = null;
                }
            }
            finally {
                this.jar = null;
            }
        }
    }

    private void register(String path) {
        String[] parsed = this.parse(path);
        this.check(parsed[0]);
        HashSet<String> set = this.map.get(parsed[0]);
        if (!"/".equals(parsed[1])) {
            set.add(parsed[1]);
        }
    }

    private String[] parse(String path) {
        int i;
        String q = path;
        if (path.endsWith("/")) {
            q = q.substring(0, path.length() - 1);
        }
        String root = (i = q.lastIndexOf(47)) < 0 ? "" : path.substring(0, i);
        String name = i < 0 ? path : path.substring(i + 1);
        return new String[]{root, name};
    }

    private void check(String path) {
        if (this.map.get(path) != null) {
            return;
        }
        this.map.put(path, new HashSet());
        String[] parsed = this.parse(path);
        this.check(parsed[0]);
        if ("".equals(parsed[1])) {
            return;
        }
        HashSet<String> set = this.map.get(parsed[0]);
        set.add(String.valueOf(parsed[1]) + "/");
    }

    public synchronized String[] getChildren(String path) {
        HashSet<String> set = this.map.get(path);
        return set == null ? new String[]{} : set.toArray(new String[0]);
    }

    public long getSize(String path) {
        Long s = this.fileEntries.get(path);
        return s == null ? 0L : s;
    }

    /*
     * Loose catch block
     */
    public String getContent(String path) {
        String string;
        BufferedInputStream bs;
        ZipFile jar;
        block24: {
            ZipEntry entry;
            boolean first;
            String encoding;
            int length;
            StringBuffer sb;
            byte[] b;
            int size;
            block22: {
                block23: {
                    size = 1024;
                    b = new byte[size];
                    sb = new StringBuffer();
                    jar = null;
                    try {
                        jar = this.getZipFile();
                    }
                    catch (IOException iOException) {
                        String error = "JarAccess: cannot load zip file for location " + this.templocation;
                        this.errors.add(error);
                        ModelPlugin.getDefault().logError(error);
                    }
                    if (jar == null) {
                        this.unlockJar();
                        return "";
                    }
                    length = 0;
                    bs = null;
                    encoding = null;
                    first = true;
                    entry = jar.getEntry(path);
                    if (entry == null && this.fileEntries.containsKey("/" + path)) {
                        entry = jar.getEntry("/" + path);
                    }
                    if (entry != null) break block22;
                    String error = "JarAccess: cannot obtain entry for path '" + path + "' from jar '" + this.location + "'.";
                    this.errors.add(error);
                    ModelPlugin.getDefault().logError(error);
                    this.unlockJar();
                    if (bs == null) break block23;
                    try {
                        bs.close();
                    }
                    catch (IOException iOException) {}
                }
                return "";
            }
            InputStream is = jar.getInputStream(entry);
            bs = new BufferedInputStream(is);
            while ((length = bs.available()) > 0) {
                if (length > size) {
                    length = size;
                }
                if ((length = bs.read(b, 0, length)) < 0) break;
                if (first) {
                    first = false;
                    encoding = FileUtil.getEncoding((byte[])b);
                }
                if (encoding != null) {
                    sb.append(new String(b, 0, length, encoding));
                    continue;
                }
                sb.append(new String(b, 0, length));
            }
            string = sb.toString();
            this.unlockJar();
            if (bs == null) break block24;
            try {
                bs.close();
            }
            catch (IOException iOException) {}
        }
        return string;
        catch (IOException e) {
            block25: {
                try {
                    this.errors.add(String.valueOf(e.getClass().getName()) + " occurs when reading " + jar.getName() + " : " + e.getMessage());
                    ModelPlugin.getPluginLog().logError("Exception occurs when reading " + jar.getName(), (Throwable)e);
                    this.unlockJar();
                    if (bs == null) break block25;
                }
                catch (Throwable throwable) {
                    this.unlockJar();
                    if (bs != null) {
                        try {
                            bs.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    bs.close();
                }
                catch (IOException iOException) {}
            }
            return "";
        }
    }

    public boolean isTextEntry(String path, int length) {
        String b = this.getContent(path);
        b = b == null || b.length() < length ? b : b.substring(length);
        return FileUtil.isText((String)b);
    }

    synchronized boolean hasFolder(String path) {
        return this.map.containsKey(path);
    }

    synchronized boolean hasFile(String path) {
        if (path == null) {
            return false;
        }
        int i = path.lastIndexOf(47);
        String p = i < 0 ? "" : path.substring(0, i);
        String n = path.substring(i + 1);
        Set set = this.map.get(p);
        return set != null && set.contains(n);
    }

    public LFileObject getFileObject(String alias, String relpath) {
        return new LFileObjectJarImpl(this, alias, relpath);
    }

    public boolean isModified() {
        if (this.timeStamp == -1L) {
            return true;
        }
        File f = new File(this.location);
        return this.timeStamp != f.lastModified() || this.size != f.length();
    }

    public synchronized void invalidate() {
        this.exists = false;
        this.map.clear();
        this.timeStamp = -1L;
        this.size = -1L;
    }

    public String getTempLocation() {
        return this.templocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarSystemImpl getMain() {
        IProject p = EclipseResourceUtil.getProject(this.main);
        if (p == null || !p.isAccessible() || !this.main.isActive()) {
            JarSystemImpl[] ss;
            this.main = null;
            Set<JarSystemImpl> set = this.slaves;
            synchronized (set) {
                Iterator<JarSystemImpl> it = this.slaves.iterator();
                while (it.hasNext()) {
                    JarSystemImpl s = it.next();
                    p = EclipseResourceUtil.getProject(s);
                    if (p == null || !p.isAccessible() || !s.isActive()) {
                        it.remove();
                        continue;
                    }
                    if (this.main != null) continue;
                    this.main = s;
                    it.remove();
                }
            }
            if (this.main != null) {
                this.main.jarUpdated();
            }
            JarSystemImpl[] jarSystemImplArray = ss = this.getSlaves();
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                JarSystemImpl s = jarSystemImplArray[n2];
                s.jarUpdated();
                ++n2;
            }
        }
        return this.main;
    }

    public void setMain(JarSystemImpl main) {
        this.main = main;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarSystemImpl[] getSlaves() {
        Set<JarSystemImpl> set = this.slaves;
        synchronized (set) {
            return this.slaves.toArray(new JarSystemImpl[this.slaves.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSlave(JarSystemImpl s) {
        if (this.main == null) {
            this.main = s;
        } else {
            Set<JarSystemImpl> set = this.slaves;
            synchronized (set) {
                this.slaves.add(s);
            }
        }
    }

    public boolean isSlave(JarSystemImpl s) {
        return this.slaves.contains(s);
    }
}

