/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.util.Properties;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.model.ui.attribute.editor.ComboBoxFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IMutableFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class MutableComboBoxFieldEditor
extends ComboBoxFieldEditor
implements IMutableFieldEditor {
    private Button changeButton;
    private String changeButtonText = "New...";
    private Composite composite;
    private SpecialWizard change;

    public MutableComboBoxFieldEditor() {
    }

    public MutableComboBoxFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    @Override
    public void setChange(SpecialWizard change) {
        this.change = change;
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.getComboField().getLayoutData();
        gd.horizontalSpan = numColumns - 2;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelComposite(parent);
        Composite control = this.getTextChangeControl(parent);
        control.setLayoutData((Object)new GridData(768));
    }

    protected Composite getTextChangeControl(Composite parent) {
        this.createTextChangeControl(parent);
        return this.composite;
    }

    protected Control createTextChangeControl(Composite parent) {
        if (this.composite == null) {
            this.composite = new Composite(parent, 0);
        }
        this.composite.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        Combo textControl = this.getComboControl(this.composite);
        GridData gd = new GridData(768);
        textControl.setLayoutData((Object)gd);
        Label control = new Label(this.composite, 0);
        control.setBackground(parent.getBackground());
        gd = new GridData();
        gd.widthHint = 5;
        control.setLayoutData((Object)gd);
        control = this.getChangeControl(this.composite);
        gd = new GridData();
        gd.widthHint = this.convertHorizontalDLUsToPixels((Control)control, 61);
        gd.heightHint = textControl.computeSize((int)-1, (int)-1).y;
        control.setLayoutData((Object)gd);
        return this.composite;
    }

    protected Button getChangeControl(Composite parent) {
        if (this.changeButton == null) {
            int style = this.getSettings().getStyle("Button.Style");
            if (style == -1) {
                style = 0;
            }
            if (style == 0) {
                style = 8;
            }
            Color bg = this.getSettings().getColor("Button.Background");
            Color fg = this.getSettings().getColor("Button.Foreground");
            Font font = this.getSettings().getFont("Button.Font");
            this.changeButton = new Button(parent, style);
            this.changeButton.setFont(font);
            this.changeButton.setBackground(bg);
            this.changeButton.setBackground(bg);
            this.changeButton.setForeground(fg);
            if (this.changeButtonText == null) {
                this.changeButtonText = JFaceResources.getString((String)"openChange");
            }
            this.changeButton.setText(this.changeButtonText);
            this.changeButton.setFont(parent.getFont());
            this.changeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String newValue = MutableComboBoxFieldEditor.this.changePressed();
                    MutableComboBoxFieldEditor.this.setNewValue(newValue);
                }
            });
            this.changeButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    MutableComboBoxFieldEditor.this.changeButton = null;
                }
            });
        } else {
            this.checkParent((Control)this.changeButton, parent);
        }
        return this.changeButton;
    }

    public void setNewValue(String newValue) {
        if (newValue != null) {
            this.getComboField().setItems(this.getTags());
            this.setStringValue(newValue);
        }
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    protected Shell getShell() {
        if (this.changeButton == null) {
            return null;
        }
        return this.changeButton.getShell();
    }

    public void setChangeButtonText(String text) {
        Assert.isNotNull((Object)text);
        this.changeButtonText = text;
        if (this.changeButton != null) {
            this.changeButton.setText(text);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getComboControl() != null) {
            this.getComboControl().setEnabled(enabled);
        }
        if (this.changeButton != null) {
            this.changeButton.setEnabled(enabled);
        }
    }

    protected Button getChangeControl() {
        return this.changeButton;
    }

    @Override
    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.getTextChangeControl(parent)};
    }

    protected String changePressed() {
        if (this.change == null) {
            return null;
        }
        Properties p = new Properties();
        p.put("shell", this.changeButton.getShell());
        this.change.setObject((Object)p);
        int i = this.change.execute();
        if (i != 0) {
            return null;
        }
        return p.getProperty("value");
    }
}

