/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd.composite;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jboss.tools.common.model.ui.editors.dnd.DropUtils;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.composite.TagAttributesTableViewer;
import org.jboss.tools.common.model.ui.objecteditor.ExtendedCellEditorProvider;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class TagAttributesComposite
extends Composite
implements PropertyChangeListener,
SelectionListener {
    private IDropWizardModel fWizardModel;
    private TableViewer tableViewer = null;
    private boolean fFiltered = false;
    private Properties context;

    public TagAttributesComposite(Composite parent, int style, IDropWizardModel wizardModel, Properties context) {
        this(parent, style, wizardModel, false, context);
    }

    public TagAttributesComposite(Composite parent, int style, IDropWizardModel wizardModel, boolean filtered, final Properties context) {
        super(parent, style);
        this.context = context;
        this.fFiltered = filtered;
        this.fWizardModel = wizardModel;
        this.fWizardModel.addPropertyChangeListener(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TagAttributesComposite.this.fWizardModel.removePropertyChangeListener(TagAttributesComposite.this);
                if (context != null) {
                    context.clear();
                }
                TagAttributesComposite.this.removeDisposeListener(this);
            }
        });
        DropUtils.AttributeDescriptorValueProvider valueProvider = this.fWizardModel.getDropData().getValueProvider();
        if (valueProvider != null) {
            valueProvider.initContext(context);
        }
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.setLayoutData(data);
        Table swtTable = new Table((Composite)this, 68356);
        data = new GridData(1808);
        TableLayout tableLayout = new TableLayout();
        this.tableViewer = new TagAttributesTableViewer(swtTable);
        swtTable.setLayout((Layout)tableLayout);
        swtTable.setLayoutData((Object)data);
        swtTable.setHeaderVisible(true);
        swtTable.setLinesVisible(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        TableColumn col = new TableColumn(swtTable, 0);
        col.setText("Attribute name");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(250));
        col = new TableColumn(swtTable, 0);
        col.setText("Value");
        this.tableViewer.setColumnProperties(new String[]{"Name", "Value"});
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setComparer(new IElementComparer(){

            public boolean equals(Object a, Object b) {
                return a == b;
            }

            public int hashCode(Object element) {
                return element == null ? 0 : element.hashCode();
            }
        });
        this.tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                AttributeDescriptorValue attrDescr = (AttributeDescriptorValue)element;
                context.setProperty("attributeName", attrDescr.getName());
                String tagName = TagAttributesComposite.this.fWizardModel.getTagProposal().getName();
                String prefix = TagAttributesComposite.this.fWizardModel.getTagProposal().getPrefix();
                if (prefix != null && prefix.length() > 0 && !tagName.startsWith(String.valueOf(prefix) + ":")) {
                    tagName = String.valueOf(prefix) + ":" + tagName;
                }
                context.setProperty("nodeName", tagName);
                ISelection s = TagAttributesComposite.this.fWizardModel.getDropData().getSelectionProvider().getSelection();
                if (s instanceof TextSelection) {
                    int offset = ((TextSelection)s).getOffset();
                    context.put("offset", new Integer(offset));
                }
                return attrDescr.getValue() == null ? "" : attrDescr.getValue();
            }

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                AttributeDescriptorValue attrDescr = (AttributeDescriptorValue)item.getData();
                TagAttributesComposite.this.fWizardModel.setAttributeValue(attrDescr, value);
                if (TagAttributesComposite.this.tableViewer != null) {
                    TagAttributesComposite.this.tableViewer.refresh();
                }
            }
        });
        ExtendedCellEditorProvider provider = this.createCellEditorProvider();
        if (provider != null) {
            CellEditor[] cellEditorArray = new CellEditor[2];
            cellEditorArray[1] = provider.createCellEditor((Composite)swtTable, context);
            this.tableViewer.setCellEditors(cellEditorArray);
        } else {
            CellEditor[] cellEditorArray = new CellEditor[2];
            cellEditorArray[1] = new TextCellEditor((Composite)swtTable);
            this.tableViewer.setCellEditors(cellEditorArray);
        }
        this.tableViewer.getCellEditors()[1].addListener(new ICellEditorListener(){

            public void applyEditorValue() {
            }

            public void cancelEditor() {
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                if (TagAttributesComposite.this.tableViewer.isCellEditorActive()) {
                    IStructuredSelection selection = (IStructuredSelection)TagAttributesComposite.this.tableViewer.getSelection();
                    AttributeDescriptorValue attrValue = (AttributeDescriptorValue)selection.getFirstElement();
                    TagAttributesComposite.this.fWizardModel.setAttributeValue(attrValue, TagAttributesComposite.this.tableViewer.getCellEditors()[1].getValue());
                }
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return this.filterElements();
            }

            private Object[] filterElements() {
                Object[] value = TagAttributesComposite.this.fWizardModel.getAttributeValueDescriptors();
                if (!TagAttributesComposite.this.isFiltered()) {
                    return value;
                }
                ArrayList<Object> filtered = new ArrayList<Object>();
                int i = 0;
                while (i < value.length) {
                    Object value2 = value[i];
                    if (((AttributeDescriptorValue)value2).isRequired() || ((AttributeDescriptorValue)value2).isPreferable()) {
                        filtered.add(value2);
                    }
                    ++i;
                }
                return filtered.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){
            public static final int ATTRIBUTE_NAME_INDEX = 0;
            public static final int ATTRIBUTE_VALUE_INDEX = 1;

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                AttributeDescriptorValue attrDescr = (AttributeDescriptorValue)element;
                switch (columnIndex) {
                    case 0: {
                        if (attrDescr.isRequired()) {
                            return attrDescr.getName();
                        }
                        if (attrDescr.isPreferable()) {
                            return attrDescr.getName();
                        }
                        return attrDescr.getName();
                    }
                    case 1: {
                        return attrDescr.getValue() == null ? "" : attrDescr.getValue().toString();
                    }
                }
                throw new IllegalArgumentException("Wrong column index for LabelProvider");
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.tableViewer.setInput(new Object());
    }

    private ExtendedCellEditorProvider createCellEditorProvider() {
        return (ExtendedCellEditorProvider)ModelFeatureFactory.getInstance().createFeatureInstance("org.jboss.tools.jst.jsp.outline.JSPCellEditorProviderImpl");
    }

    protected boolean isFiltered() {
        return this.fFiltered;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.tableViewer.isCellEditorActive()) {
            return;
        }
        if ("tagProposal".equals(evt.getPropertyName())) {
            this.tableViewer.setInput(new Object());
            DropUtils.AttributeDescriptorValueProvider valueProvider = this.fWizardModel.getDropData().getValueProvider();
            if (valueProvider != null) {
                valueProvider.initContext(this.context);
            }
        } else {
            this.tableViewer.refresh();
        }
    }

    public static final boolean areThereAttributesForCommonTab(AttributeDescriptorValue[] attributes) {
        int i = 0;
        while (i < attributes.length) {
            AttributeDescriptorValue value = attributes[i];
            if (value.isPreferable() || value.isRequired()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setWizardModel(IDropWizardModel model) {
        this.fWizardModel = model;
        this.tableViewer.setInput(new Object());
        this.tableViewer.refresh();
    }

    public void widgetSelected(SelectionEvent e) {
        this.tableViewer.refresh();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public static class AttributeDescriptorValue {
        String name;
        boolean isRequired;
        boolean isPreferable;
        private Object fValue;

        public AttributeDescriptorValue(String name, boolean isRequired, boolean isPreferable) {
            this.name = name;
            this.isPreferable = isPreferable;
            this.isRequired = isRequired;
        }

        public Object getValue() {
            return this.fValue;
        }

        public void setValue(Object value) {
            this.fValue = value;
        }

        public String getName() {
            return this.name;
        }

        public boolean isPreferable() {
            return this.isPreferable;
        }

        public void setPreferable(boolean b) {
            this.isPreferable = b;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

