/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.objecteditor;

import java.util.Properties;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.model.ui.objecteditor.AttributeWrapper;
import org.jboss.tools.common.model.ui.objecteditor.CellModifierImpl;
import org.jboss.tools.common.model.ui.objecteditor.ExtendedCellEditorProvider;
import org.jboss.tools.common.model.ui.objecteditor.ExtendedProperties;
import org.jboss.tools.common.model.ui.objecteditor.ExtendedTextCellEditor;
import org.jboss.tools.common.model.ui.objecteditor.XCellEditor;
import org.jboss.tools.common.model.ui.objecteditor.XTable;
import org.jboss.tools.common.model.ui.objecteditor.XTableProvider;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class ExtendedPropertiesEditor {
    static Color DEFAULT_COLOR = Display.getDefault().getSystemColor(2);
    static Color DISABLED_COLOR = Display.getDefault().getSystemColor(15);
    static Image EMPTY = EclipseResourceUtil.getImage((String)"images/actions/empty.gif");
    protected XTable xtable = new XTable();
    protected ExtendedProperties attributes;
    protected ICellModifier modifier = new CellModifierImpl();
    protected boolean readOnly = false;
    ExtendedCellEditorProvider cellEditorProvider = null;
    Properties context = new Properties();

    public ExtendedPropertiesEditor() {
        this.xtable.setTableProvider(new XTableProviderImpl());
    }

    public void setExtendedProperties(ExtendedProperties attributes) {
        if (this.attributes == attributes) {
            return;
        }
        this.stopEditing();
        this.attributes = attributes;
        if (attributes != null) {
            this.context.setProperty("nodeName", attributes.getNodeName());
            this.cellEditorProvider = attributes.createCellEditorProvider();
            if (attributes.getNode() != null) {
                this.context.put("node", attributes.getNode());
            }
        }
        if (this.xtable.getTable() == null || this.xtable.getTable().isDisposed()) {
            return;
        }
        this.xtable.getTable().setSelection(-1);
        this.update();
    }

    public void setReadOnly(boolean b) {
        this.readOnly = b;
    }

    public Control createControl(Composite parent) {
        return this.createControl(parent, this.xtable.style);
    }

    public Control createControl(Composite parent, int style) {
        this.xtable.createControl(parent, style);
        this.xtable.getViewer().setColumnProperties(new String[]{"name", "value"});
        this.xtable.getViewer().setCellModifier(this.modifier);
        if (!this.readOnly) {
            ExtendedTextCellEditor cellEditor = this.cellEditorProvider != null ? this.cellEditorProvider.createCellEditor((Composite)this.xtable.getTable(), this.context) : new ExtendedTextCellEditor((Composite)this.xtable.getTable());
            CellEditor[] cellEditorArray = new CellEditor[2];
            cellEditorArray[1] = cellEditor;
            this.xtable.getViewer().setCellEditors(cellEditorArray);
        }
        this.update();
        return this.xtable.getTable();
    }

    public Control getControl() {
        return this.xtable.getTable();
    }

    public void stopEditing() {
        if (this.attributes != null && this.xtable.getViewer() != null && this.xtable.getViewer().isCellEditorActive()) {
            CellEditor editor = this.xtable.getViewer().getCellEditors()[1];
            if (editor instanceof XCellEditor) {
                ((XCellEditor)editor).applyEditorValue();
            } else if (editor instanceof ExtendedCellEditorProvider.StoppableCellEditor) {
                ((ExtendedCellEditorProvider.StoppableCellEditor)editor).stopEditing();
            }
        }
    }

    public void update() {
        if (this.xtable.getTable() == null) {
            return;
        }
        this.xtable.update();
    }

    public void dispose() {
        if (this.xtable != null) {
            this.xtable.dispose();
        }
        this.xtable = null;
        if (this.context != null) {
            this.context.clear();
            this.context = null;
        }
    }

    class XTableProviderImpl
    implements XTableProvider {
        XTableProviderImpl() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ExtendedPropertiesEditor.this.attributes == null ? 0 : ExtendedPropertiesEditor.this.attributes.getAttributes().length;
        }

        @Override
        public String getColumnName(int c) {
            return c == 0 ? "name" : "value";
        }

        @Override
        public String getValueAt(int r, int c) {
            String name = ExtendedPropertiesEditor.this.attributes.getAttributes()[r];
            return c == 0 ? name : ExtendedPropertiesEditor.this.attributes.getAttributeValue(name);
        }

        @Override
        public Object getDataAt(int r) {
            if (ExtendedPropertiesEditor.this.attributes == null) {
                return null;
            }
            AttributeWrapper w = new AttributeWrapper();
            w.attributes = ExtendedPropertiesEditor.this.attributes;
            w.name = ExtendedPropertiesEditor.this.attributes.getAttributes()[r];
            w.value = ExtendedPropertiesEditor.this.attributes.getAttributeValue(w.name);
            return w;
        }

        @Override
        public Color getColor(int r) {
            if (ExtendedPropertiesEditor.this.attributes == null) {
                return DISABLED_COLOR;
            }
            String name = ExtendedPropertiesEditor.this.attributes.getAttributes()[r];
            return ExtendedPropertiesEditor.this.attributes.isEditableAttribute(name) && !ExtendedPropertiesEditor.this.readOnly ? DEFAULT_COLOR : DISABLED_COLOR;
        }

        @Override
        public int getWidthHint(int c) {
            return c == 0 ? 10 : 20;
        }

        @Override
        public void dispose() {
            ExtendedPropertiesEditor.this.attributes = null;
        }
    }
}

