/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.preferences;

import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.impl.SharableElementImpl;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.preferences.IPreferencePageExt;
import org.jboss.tools.common.model.ui.util.ModelUtilities;

public class XMOBasedPreferencesPage
extends PreferencePage
implements IPreferencePageExt,
IWorkbenchPreferencePage {
    public Composite control;
    protected XModel preferenceModel = ModelUtilities.getPreferenceModel();
    protected XAttributeSupport support;
    protected XModelObject object;
    String path;

    public XMOBasedPreferencesPage(XModelObject xmo) {
        this(xmo, null);
    }

    public XMOBasedPreferencesPage(XModelObject xmo, XEntityData data) {
        this.object = xmo;
        this.path = xmo.getPath();
        this.support = new XAttributeSupport();
        if (data == null) {
            this.support.init(xmo);
        } else {
            this.support.init(xmo, data, true);
        }
        this.support.setAutoStore(false);
    }

    public void dispose() {
        super.dispose();
        if (this.support != null) {
            this.support.dispose();
        }
        this.support = null;
    }

    public String getTitle() {
        String s;
        String value = this.support.getTitle();
        if (this.object != null && (s = WizardKeys.getVisualListValue((XAttribute)this.object.getModelEntity().getAttribute("name"), (String)value)) != null) {
            return s;
        }
        return value;
    }

    public void init(IWorkbench workbench) {
    }

    public Control createContents(Composite parent) {
        this.control = this.support.createControl(parent);
        return this.control;
    }

    public boolean isValid() {
        return super.isValid();
    }

    public boolean performCancel() {
        this.support.load();
        return super.performCancel();
    }

    @Override
    public void performDefaults() {
        if (this.object instanceof SharableElementImpl) {
            SharableElementImpl s = (SharableElementImpl)this.object;
            List l = this.support.getAdapterList();
            int i = 0;
            while (i < l.size()) {
                IModelPropertyEditorAdapter a = (IModelPropertyEditorAdapter)l.get(i);
                String n = a.getAttribute().getName();
                String v = s.getDefaultValue(n);
                if (v != null && v.length() > 0) {
                    a.setValue(v);
                }
                ++i;
            }
        }
        super.performDefaults();
    }

    public void performHelp() {
    }

    public boolean performOk() {
        this.support.store();
        this.support.save();
        return true;
    }

    public void initPageProperties() {
    }

    public final XAttributeSupport getAttributeSupport() {
        return this.support;
    }

    public final XModelObject getObject() {
        return this.object;
    }

    public final XAttributeSupport getSupport() {
        return this.support;
    }

    public final Composite getSupportControl() {
        return this.control;
    }
}

