/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.navigator;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class FilteredTreesCache {
    static FilteredTreesCache instance = new FilteredTreesCache();
    Map<String, Map<XModel, XFilteredTree>> map = new HashMap<String, Map<XModel, XFilteredTree>>();
    Set<XModelTreeListener> listeners = new HashSet<XModelTreeListener>();

    public static FilteredTreesCache getInstance() {
        return instance;
    }

    private FilteredTreesCache() {
    }

    public XFilteredTree getFilteredTree(String name, XModel model) {
        if (name == null || model == null) {
            return null;
        }
        Map<XModel, XFilteredTree> nmap = this.getNamedMap(name);
        XFilteredTree result = nmap.get(model);
        if (result == null && (result = this.createTree(name, model)) != null) {
            nmap.put(model, result);
        }
        return result;
    }

    Map<XModel, XFilteredTree> getNamedMap(String name) {
        Map<XModel, XFilteredTree> nmap = this.map.get(name);
        if (nmap == null) {
            nmap = new HashMap<XModel, XFilteredTree>();
            this.map.put(name, nmap);
        }
        return nmap;
    }

    public void remove(XModel model) {
        if (model == null) {
            return;
        }
        Collection<Map<XModel, XFilteredTree>> i1 = this.map.values();
        for (Map<XModel, XFilteredTree> m : i1) {
            m.remove(model);
            for (XModelTreeListener l : this.listeners) {
                model.removeModelTreeListener(l);
            }
        }
    }

    XFilteredTree createTree(String name, XModel model) {
        if (model == null || name == null) {
            return null;
        }
        String classname = model.getMetaData().getMapping("FilteredTrees").getValue(name);
        XFilteredTree result = null;
        try {
            result = (XFilteredTree)ModelFeatureFactory.getInstance().createFeatureInstance(classname);
        }
        catch (ClassCastException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
        result.setModel(model);
        if (result.getRoot() == null) {
            result = null;
            IProject p = EclipseResourceUtil.getProject((XModelObject)model.getRoot());
            IModelNature nature = EclipseResourceUtil.getModelNature((IProject)p);
            if (nature != null) {
                ModelUIPlugin.getPluginLog().logInfo("Red Hat Project " + p.getName() + " is corrupted.");
            }
        }
        return result;
    }

    public void addListener(XModelTreeListener listener, XModel model) {
        this.listeners.add(listener);
        model.addModelTreeListener(listener);
    }

    public void removeListener(XModelTreeListener listener) {
        this.listeners.remove(listener);
        Collection<Map<XModel, XFilteredTree>> i1 = this.map.values();
        for (Map<XModel, XFilteredTree> m : i1) {
            Collection<XFilteredTree> i2 = m.values();
            for (XFilteredTree t : i2) {
                XModel model = t.getRoot().getModel();
                if (model == null) continue;
                model.removeModelTreeListener(listener);
            }
        }
    }
}

