/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.spec.se.manifest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImportException;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.jboss.shrinkwrap.descriptor.impl.spec.se.manifest.ManifestDescriptorImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.se.manifest.ManifestModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestDescriptorImporter
implements DescriptorImporter<ManifestDescriptor> {
    private final String descriptorName;

    public ManifestDescriptorImporter(String descriptorName) {
        this.descriptorName = descriptorName;
    }

    public ManifestDescriptor from(File file) throws IllegalArgumentException, DescriptorImportException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        try {
            return new ManifestDescriptorImpl(this.descriptorName, new ManifestModel(file));
        }
        catch (Exception e) {
            throw new DescriptorImportException(e.getMessage(), (Throwable)e);
        }
    }

    public ManifestDescriptor from(InputStream in) throws IllegalArgumentException, DescriptorImportException {
        return this.from(in, true);
    }

    public ManifestDescriptor from(InputStream in, boolean close) throws IllegalArgumentException, DescriptorImportException {
        if (in == null) {
            throw new IllegalArgumentException("Stream cannot be null");
        }
        try {
            ManifestDescriptorImpl manifestDescriptorImpl = new ManifestDescriptorImpl(this.descriptorName, new ManifestModel(in));
            return manifestDescriptorImpl;
        }
        catch (Exception e) {
            throw new DescriptorImportException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (close) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new DescriptorImportException("Input stream not closed", (Throwable)e);
                }
            }
        }
    }

    public ManifestDescriptor from(String manifest) throws IllegalArgumentException, DescriptorImportException {
        if (manifest == null) {
            throw new IllegalArgumentException("Manifest cannot be null");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(manifest.getBytes());
        try {
            return new ManifestDescriptorImpl(this.descriptorName, new ManifestModel(inputStream));
        }
        catch (IOException e) {
            throw new DescriptorImportException(e.getMessage(), (Throwable)e);
        }
    }
}

