/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.PluginMetadata;
import org.jboss.forge.shell.constraint.ConstraintEnforcer;
import org.jboss.forge.shell.constraint.ConstraintException;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.util.ConstraintInspector;

public class PluginMetadataImpl
implements PluginMetadata {
    private String help = "";
    private String name = "";
    private String topic = "Other";
    private Class<? extends Plugin> type;
    private Set<Class<? extends Resource<?>>> resourceScopes = Collections.emptySet();
    private final Map<String, List<CommandMetadata>> commandMap = new HashMap<String, List<CommandMetadata>>();
    private final Map<String, Map<Class<? extends Resource<?>>, CommandMetadata>> commandAccessCache = new HashMap();
    private CommandMetadata defaultCommand;
    private CommandMetadata setupCommand;
    private boolean scopeOverloaded = false;

    public CommandMetadata getCommand(String name) {
        return this.getCommand(name, (Class)null);
    }

    public CommandMetadata getCommand(String name, Shell shell) {
        return this.getCommand(name, shell.getCurrentResourceScope());
    }

    public CommandMetadata getCommand(String name, Class<? extends Resource<?>> scope) {
        if (scope == null) {
            if (this.commandMap.containsKey(name) && this.commandMap.get(name).size() > 1) {
                throw new RuntimeException("ambiguous query: overloaded commands exist. you must specify a scope.");
            }
            return this.commandMap.get(name).iterator().next();
        }
        if (this.commandAccessCache.containsKey(name) && this.commandAccessCache.get(name).containsKey(scope)) {
            return this.commandAccessCache.get(name).get(scope);
        }
        List<CommandMetadata> cmdMetadata = this.commandMap.get(name);
        if (cmdMetadata == null) {
            return null;
        }
        for (CommandMetadata c : cmdMetadata) {
            if (!c.usableWithResource(scope)) continue;
            return c;
        }
        return null;
    }

    public Map<String, List<CommandMetadata>> getCommandMap() {
        return this.commandMap;
    }

    public boolean hasCommand(String name, Shell shell) {
        return this.getCommand(name, shell.getCurrentResourceScope()) != null;
    }

    public boolean hasCommand(String name, Class<? extends Resource<?>> scope) {
        return this.getCommand(name, scope) != null;
    }

    public boolean hasDefaultCommand() {
        return this.getDefaultCommand() != null;
    }

    public boolean hasCommands() {
        return !this.commandMap.isEmpty();
    }

    public boolean hasSetupCommand() {
        return this.getSetupCommand() != null;
    }

    public CommandMetadata getSetupCommand() {
        return this.setupCommand;
    }

    public CommandMetadata getDefaultCommand() {
        return this.defaultCommand;
    }

    public void addCommands(List<CommandMetadata> commands) {
        for (CommandMetadata c : commands) {
            this.addCommand(c);
        }
    }

    public void addCommand(CommandMetadata command) {
        if (command.isDefault()) {
            if (this.defaultCommand != null) {
                throw new RuntimeException("default command already defined: " + command.getName() + "; for plugin: " + this.name);
            }
            this.defaultCommand = command;
        }
        if (command.isSetup()) {
            if (this.setupCommand != null) {
                throw new RuntimeException("setup command already defined: " + command.getName() + "; for plugin: " + this.name);
            }
            this.setupCommand = command;
        }
        if (!this.commandMap.containsKey(command.getName())) {
            this.commandMap.put(command.getName(), new ArrayList());
        } else {
            this.scopeOverloaded = true;
        }
        this.commandMap.get(command.getName()).add(command);
    }

    public List<CommandMetadata> getCommands() {
        return this.getCommands((Class)null);
    }

    public List<CommandMetadata> getCommands(Shell shell) {
        return this.getCommands(shell.getCurrentResourceScope());
    }

    private List<CommandMetadata> getCommands(Class<? extends Resource<?>> scope) {
        if (scope == null && this.scopeOverloaded) {
            throw new RuntimeException("ambiguous query: overloaded commands exist. you must specify a scope.");
        }
        ArrayList<CommandMetadata> result = new ArrayList<CommandMetadata>();
        for (List<CommandMetadata> cl : this.commandMap.values()) {
            for (CommandMetadata c : cl) {
                if (scope != null && !c.usableWithResource(scope)) continue;
                result.add(c);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List<CommandMetadata> getAllCommands() {
        ArrayList<CommandMetadata> result = new ArrayList<CommandMetadata>();
        for (List<CommandMetadata> cl : this.commandMap.values()) {
            for (CommandMetadata c : cl) {
                result.add(c);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public boolean isCommandOverloaded(String name) {
        return this.commandMap.containsKey(name) && this.commandMap.get(name).size() > 1;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<? extends Plugin> getType() {
        return this.type;
    }

    public void setType(Class<? extends Plugin> type) {
        this.type = type;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic.toUpperCase();
    }

    public boolean constrantsSatisfied(Shell shell) {
        try {
            ConstraintEnforcer enforcer = new ConstraintEnforcer();
            enforcer.verifyAvailable(shell.getCurrentProject(), this);
            return this.usableWithScope(shell.getCurrentResourceScope());
        }
        catch (ConstraintException e) {
            return false;
        }
    }

    public boolean usableWithScope(Class<? extends Resource> scope) {
        return this.resourceScopes.isEmpty() || this.resourceScopes.contains(scope);
    }

    public Set<Class<? extends Resource<?>>> getResourceScopes() {
        return this.resourceScopes;
    }

    public void setResourceScopes(List<Class<? extends Resource<?>>> resourceScopes) {
        this.resourceScopes = new HashSet(resourceScopes);
    }

    public boolean isSetupAvailable(Shell shell) {
        if (this.hasSetupCommand() && (!ConstraintInspector.requiresProject(this.getType()) || ConstraintInspector.requiresProject(this.getType()) && shell.getCurrentProject() != null)) {
            CommandMetadata setupCommand = this.getSetupCommand();
            return setupCommand.usableWithResource(shell.getCurrentResourceScope());
        }
        return false;
    }
}

