/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.event.Observes;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.command.PluginRegistry;
import org.jboss.forge.shell.events.PostStartup;
import org.jboss.forge.shell.events.ReinitializeEnvironment;

public class PluginDiffObserver {
    private static volatile Set<String> LAST_PLUGINS_DIFF;

    public void onRestart(@Observes ReinitializeEnvironment restart, PluginRegistry pluginRegistry) {
        LAST_PLUGINS_DIFF = new TreeSet<String>();
        LAST_PLUGINS_DIFF.addAll(pluginRegistry.getPlugins().keySet());
    }

    public void onInitialize(@Observes PostStartup start, PluginRegistry pluginRegistry, Shell shell) {
        if (LAST_PLUGINS_DIFF != null) {
            Set loadedPlugins = pluginRegistry.getPlugins().keySet();
            TreeSet currentPlugins = new TreeSet();
            currentPlugins.addAll(loadedPlugins);
            currentPlugins.removeAll(LAST_PLUGINS_DIFF);
            if (!LAST_PLUGINS_DIFF.isEmpty() && !currentPlugins.isEmpty()) {
                shell.print("The following plugins have been activated: ");
                shell.println(ShellColor.BOLD, ((Object)currentPlugins).toString());
            }
            LAST_PLUGINS_DIFF.removeAll(loadedPlugins);
            if (!LAST_PLUGINS_DIFF.isEmpty()) {
                shell.print("The following plugins have been deactivated: ");
                shell.println(ShellColor.BOLD, LAST_PLUGINS_DIFF.toString());
            }
            LAST_PLUGINS_DIFF = null;
        }
    }
}

