/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.project;

import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyFilter;
import org.jboss.forge.project.dependencies.DependencyInstaller;
import org.jboss.forge.project.dependencies.DependencyQuery;
import org.jboss.forge.project.dependencies.DependencyQueryBuilder;
import org.jboss.forge.project.dependencies.NonSnapshotDependencyFilter;
import org.jboss.forge.project.dependencies.ScopeType;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.shell.ShellPrompt;

public class DependencyInstallerImpl
implements DependencyInstaller {
    private final ShellPrompt prompt;

    @Inject
    public DependencyInstallerImpl(ShellPrompt prompt) {
        this.prompt = prompt;
    }

    public Dependency install(Project project, Dependency dependency) {
        return this.install(project, dependency, (ScopeType)null);
    }

    public Dependency install(Project project, Dependency dependency, DependencyFilter filter) {
        return this.install(project, dependency, null, filter);
    }

    public Dependency install(Project project, Dependency dependency, ScopeType type) {
        return this.install(project, dependency, type, null);
    }

    public Dependency install(Project project, Dependency dependency, ScopeType type, DependencyFilter filter) {
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        Dependency existing = deps.getEffectiveDependency(dependency);
        Dependency existingManaged = deps.getEffectiveManagedDependency(dependency);
        DependencyBuilder unversioned = this.getUnversioned(dependency, type);
        if (existing != null) {
            if (!Strings.isNullOrEmpty((String)existing.getVersion()) && (existing.getVersion().equals(dependency.getVersion()) || Strings.isNullOrEmpty((String)dependency.getVersion()))) {
                return existing;
            }
            if (Strings.isNullOrEmpty((String)existing.getVersion()) && !Strings.isNullOrEmpty((String)dependency.getVersion())) {
                return this.updateAll(deps, dependency, unversioned);
            }
            return this.promptAndUpdateAll(deps, dependency, unversioned, filter);
        }
        if (existingManaged != null) {
            if (!Strings.isNullOrEmpty((String)existingManaged.getVersion()) && (existingManaged.getVersion().equals(dependency.getVersion()) || Strings.isNullOrEmpty((String)dependency.getVersion()))) {
                deps.removeDependency(dependency);
                this.updateDependency(deps, unversioned);
                return existingManaged;
            }
            if (Strings.isNullOrEmpty((String)existingManaged.getVersion()) && !Strings.isNullOrEmpty((String)dependency.getVersion())) {
                return this.updateAll(deps, dependency, unversioned);
            }
            return this.promptAndUpdateAll(deps, dependency, unversioned, filter);
        }
        if (Strings.isNullOrEmpty((String)dependency.getVersion())) {
            return this.promptAndUpdateAll(deps, dependency, unversioned, filter);
        }
        return this.updateAll(deps, dependency, unversioned);
    }

    public Dependency installManaged(Project project, Dependency dependency) {
        return this.installManaged(project, dependency, (DependencyFilter)null);
    }

    public Dependency installManaged(Project project, Dependency dependency, DependencyFilter filter) {
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        if (Strings.isNullOrEmpty((String)dependency.getVersion())) {
            return this.promptAndUpdateManaged(deps, dependency, filter);
        }
        this.updateManagedDependency(deps, dependency);
        return dependency;
    }

    public Dependency installManaged(Project project, Dependency dependency, ScopeType type) {
        return this.installManaged(project, dependency, (DependencyFilter)null);
    }

    public Dependency installManaged(Project project, Dependency dependency, ScopeType type, DependencyFilter filter) {
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        DependencyBuilder withScopeType = this.getWithScopeType(dependency, type);
        if (Strings.isNullOrEmpty((String)dependency.getVersion())) {
            return this.promptAndUpdateManaged(deps, (Dependency)withScopeType, filter);
        }
        this.updateManagedDependency(deps, (Dependency)withScopeType);
        return withScopeType;
    }

    public boolean isInstalled(Project project, Dependency dependency) {
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        return deps.hasEffectiveDependency(dependency);
    }

    private DependencyBuilder getUnversioned(Dependency dependency, ScopeType type) {
        return this.getWithScopeType(dependency, type).setVersion(null);
    }

    private DependencyBuilder getWithScopeType(Dependency dependency, ScopeType type) {
        return DependencyBuilder.create((Dependency)dependency).setVersion(dependency.getVersion()).setScopeType(type == null ? dependency.getScopeType() : type.toString()).setPackagingType(dependency.getPackagingType());
    }

    private Dependency promptAndUpdateAll(DependencyFacet deps, Dependency dependency, DependencyBuilder unversioned, DependencyFilter filter) {
        DependencyBuilder toAdd = DependencyBuilder.create((Dependency)this.promptVersion(deps, dependency, filter));
        toAdd.setScopeType(dependency.getScopeType()).setClassifier(dependency.getClassifier()).setPackagingType(dependency.getPackagingType());
        this.updateAll(deps, (Dependency)toAdd, unversioned);
        return toAdd;
    }

    private Dependency promptAndUpdateManaged(DependencyFacet deps, Dependency dependency, DependencyFilter filter) {
        DependencyBuilder toAdd = DependencyBuilder.create((Dependency)this.promptVersion(deps, dependency, filter));
        toAdd.setScopeType(dependency.getScopeType()).setClassifier(dependency.getClassifier()).setPackagingType(dependency.getPackagingType());
        this.updateManagedDependency(deps, (Dependency)toAdd);
        return toAdd;
    }

    private Dependency updateAll(DependencyFacet deps, Dependency dependency, DependencyBuilder unversioned) {
        this.updateDependency(deps, unversioned);
        this.updateManagedDependency(deps, dependency);
        return dependency;
    }

    private void updateManagedDependency(DependencyFacet deps, Dependency dependency) {
        deps.addDirectManagedDependency(dependency);
    }

    private void updateDependency(DependencyFacet deps, DependencyBuilder dependency) {
        deps.addDirectDependency((Dependency)dependency);
    }

    private Dependency promptVersion(DependencyFacet deps, Dependency dependency, DependencyFilter filter) {
        Dependency result = dependency;
        List versions = deps.resolveAvailableVersions((DependencyQuery)DependencyQueryBuilder.create((Dependency)dependency).setFilter((DependencyFilter)(filter == null ? new NonSnapshotDependencyFilter() : filter)));
        if (versions.size() > 0) {
            Dependency deflt = (Dependency)versions.get(versions.size() - 1);
            result = (Dependency)this.prompt.promptChoiceTyped("Use which version of '" + dependency.getArtifactId() + "' ?", versions, (Object)deflt);
        }
        return result;
    }
}

