/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jface.text.Document;
import org.jboss.forge.parser.ParserException;
import org.jboss.forge.parser.java.JavaAnnotation;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaEnum;
import org.jboss.forge.parser.java.JavaInterface;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.ast.TypeDeclarationFinderVisitor;
import org.jboss.forge.parser.java.impl.JavaAnnotationImpl;
import org.jboss.forge.parser.java.impl.JavaClassImpl;
import org.jboss.forge.parser.java.impl.JavaEnumImpl;
import org.jboss.forge.parser.java.impl.JavaInterfaceImpl;
import org.jboss.forge.parser.spi.JavaParserProvider;

public class JavaParserImpl
implements JavaParserProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaSource<?> parse(File file) throws FileNotFoundException {
        FileInputStream stream = new FileInputStream(file);
        try {
            JavaSource<?> javaSource = this.parse(stream);
            return javaSource;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException io) {}
        }
    }

    public JavaSource<?> parse(InputStream data) {
        try {
            char[] source = Util.getInputStreamAsCharArray((InputStream)data, (int)data.available(), (String)"ISO8859_1");
            JavaSource<?> javaSource = this.parse(source);
            return javaSource;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("InputStream must be a parsable java file: ", e);
        }
        finally {
            try {
                data.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public JavaSource<?> parse(char[] data) {
        return this.parse(new String(data));
    }

    public JavaSource<?> parse(String data) {
        Document document = new Document(data);
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setSource(document.get().toCharArray());
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "1.7");
        options.put("org.eclipse.jdt.core.encoding", "UTF-8");
        parser.setCompilerOptions((Map)options);
        parser.setResolveBindings(true);
        parser.setKind(8);
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        unit.recordModifications();
        TypeDeclarationFinderVisitor visitor = new TypeDeclarationFinderVisitor();
        unit.accept((ASTVisitor)visitor);
        List<AbstractTypeDeclaration> declarations = visitor.getTypeDeclarations();
        if (!declarations.isEmpty()) {
            AbstractTypeDeclaration declaration = declarations.get(0);
            return JavaParserImpl.getJavaSource(null, document, unit, (BodyDeclaration)declaration);
        }
        throw new ParserException("Could not find type declaration in Java source - is this actually code?");
    }

    public static JavaSource<?> getJavaSource(JavaSource<?> enclosingType, Document document, CompilationUnit unit, BodyDeclaration declaration) {
        if (declaration instanceof TypeDeclaration) {
            if (((TypeDeclaration)declaration).isInterface()) {
                return new JavaInterfaceImpl(enclosingType, document, unit, declaration);
            }
            return new JavaClassImpl(enclosingType, document, unit, declaration);
        }
        if (declaration instanceof EnumDeclaration) {
            return new JavaEnumImpl(enclosingType, document, unit, declaration);
        }
        if (declaration instanceof AnnotationTypeDeclaration) {
            return new JavaAnnotationImpl(enclosingType, document, unit, declaration);
        }
        throw new ParserException("Unknown Java source type [" + declaration + "]");
    }

    public <T extends JavaSource<?>> T create(Class<T> type) {
        if (JavaClass.class.isAssignableFrom(type)) {
            return (T)this.parse("public class JavaClass { }");
        }
        if (JavaEnum.class.isAssignableFrom(type)) {
            return (T)this.parse("public enum JavaEnum { }");
        }
        if (JavaAnnotation.class.isAssignableFrom(type)) {
            return (T)this.parse("public @interface JavaAnnotation { }");
        }
        if (JavaInterface.class.isAssignableFrom(type)) {
            return (T)this.parse("public interface JavaInterface { }");
        }
        throw new ParserException("Unknown JavaSource type [" + type.getName() + "]");
    }

    public <T extends JavaSource<?>> T parse(Class<T> type, InputStream data) {
        JavaSource<?> source = this.parse(data);
        if (type.isAssignableFrom(source.getClass())) {
            return (T)source;
        }
        throw new ParserException("Source does not represent a [" + type.getSimpleName() + "], instead was [" + source.getClass().getSimpleName() + "] - Cannot convert.");
    }

    public <T extends JavaSource<?>> T parse(Class<T> type, char[] data) {
        JavaSource<?> source = this.parse(data);
        if (type.isAssignableFrom(source.getClass())) {
            return (T)source;
        }
        throw new ParserException("Source does not represent a [" + type.getSimpleName() + "], instead was [" + source.getClass().getSimpleName() + "] - Cannot convert.");
    }

    public <T extends JavaSource<?>> T parse(Class<T> type, String data) {
        JavaSource<?> source = this.parse(data);
        if (type.isAssignableFrom(source.getClass())) {
            return (T)source;
        }
        throw new ParserException("Source does not represent a [" + type.getSimpleName() + "], instead was [" + source.getClass().getSimpleName() + "] - Cannot convert.");
    }

    public <T extends JavaSource<?>> T parse(Class<T> type, File file) throws FileNotFoundException {
        JavaSource<?> source = this.parse(file);
        if (type.isAssignableFrom(source.getClass())) {
            return (T)source;
        }
        throw new ParserException("Source does not represent a [" + type.getSimpleName() + "], instead was [" + source.getClass().getSimpleName() + "] - Cannot convert.");
    }
}

