/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template.expression;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionAttrPresent;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionSrc;
import org.jboss.tools.vpe.editor.template.expression.VpeValue;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.w3c.dom.Node;

public class VpeFunctionHref
extends VpeFunctionSrc {
    @Override
    protected String getUnresolved() {
        return "";
    }

    @Override
    String[] getSignatures() {
        return VpeFunctionAttrPresent.SIGNATURE_ANY_ATTR_ARAY;
    }

    @Override
    public VpeValue exec(VpePageContext pageContext, Node sourceNode) throws VpeExpressionException {
        String device;
        String tagValue = this.getParameter(0).exec(pageContext, sourceNode).stringValue();
        Path tagPath = new Path(tagValue);
        if (tagPath.isEmpty()) {
            return new VpeValue(this.getUnresolved());
        }
        String string = device = tagPath.getDevice() == null ? tagPath.segment(0) : tagPath.getDevice();
        if (device != null && ("http:".equalsIgnoreCase(device) || "file:".equalsIgnoreCase(device))) {
            return new VpeValue(tagValue);
        }
        File locFile = tagPath.toFile();
        if (locFile.exists()) {
            return new VpeValue(String.valueOf(this.getPrefix()) + tagPath.toString());
        }
        IEditorInput input = pageContext.getEditPart().getEditorInput();
        IPath inputPath = this.getInputParentPath(input);
        IPath imgPath = null;
        if (input instanceof ILocationProvider) {
            imgPath = inputPath.append(tagValue);
        } else {
            IPath basePath;
            IPath iPath = basePath = tagPath.isAbsolute() ? VpeStyleUtil.getRootPath(input) : inputPath;
            if (basePath != null) {
                imgPath = basePath.append((IPath)tagPath);
            }
        }
        if (imgPath != null && imgPath.toFile().exists()) {
            return new VpeValue(String.valueOf(this.getPrefix()) + imgPath.toString());
        }
        return new VpeValue(this.getUnresolved());
    }
}

