/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.wizards;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.vpe.editor.template.VpeAnyData;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.wizards.VpeImportExportWizardPage;
import org.jboss.tools.vpe.editor.wizards.VpeImportExportWizardsUtils;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.resref.core.ReferenceWizardPage;

public class ExportUserTagsTemplatesWizardPage
extends WizardPage
implements VpeImportExportWizardPage {
    private String pathString;
    private Table tagsTable;
    private List<VpeAnyData> tagsList;

    protected ExportUserTagsTemplatesWizardPage(String pageName, List<VpeAnyData> currentList) {
        super(pageName);
        this.setTitle(VpeUIMessages.EXPORT_USER_TAGS_PAGE_TITLE);
        this.setDescription(VpeUIMessages.EXPORT_USER_TAGS_PAGE_DESCRIPTION);
        this.setImageDescriptor(ReferenceWizardPage.getImageDescriptor());
        this.tagsList = currentList;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setFont(parent.getFont());
        this.tagsTable = new Table(composite, 2048);
        TableLayout layout = new TableLayout();
        this.tagsTable.setLayout((Layout)layout);
        this.tagsTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.tagsTable.setHeaderVisible(true);
        this.tagsTable.setLinesVisible(true);
        int i = 0;
        while (i < COLUMNS_NAMES.length) {
            TableColumn column = new TableColumn(this.tagsTable, 0);
            column.setText(COLUMNS_NAMES[i]);
            ColumnWeightData columnLayoutData = new ColumnWeightData(COLUMNS_WIDTHS[i], true);
            layout.addColumnData((ColumnLayoutData)columnLayoutData);
            ++i;
        }
        VpeImportExportWizardsUtils.updateTagsTable(this.tagsTable, this.tagsList, true);
        Label fileNamaLabel = new Label(composite, 0);
        fileNamaLabel.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
        fileNamaLabel.setText(VpeUIMessages.FILE_NAME_LABEL);
        final Text pathText = new Text(composite, 2048);
        pathText.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportUserTagsTemplatesWizardPage.this.pathString = ((Text)e.getSource()).getText();
                ExportUserTagsTemplatesWizardPage.this.setPageComplete(ExportUserTagsTemplatesWizardPage.this.isPageComplete());
            }
        });
        Button browseButton = new Button(composite, 0);
        browseButton.setText(VpeUIMessages.BROWSE_BUTTON_TEXT);
        browseButton.setLayoutData((Object)new GridData(4, 1024, false, false, 1, 1));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 0);
                String path = dialog.open();
                if (path != null) {
                    File file = new File(path);
                    ExportUserTagsTemplatesWizardPage.this.pathString = file.toString();
                    pathText.setText(ExportUserTagsTemplatesWizardPage.this.pathString);
                }
            }
        });
        this.setPageComplete(this.isPageComplete());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        boolean isPageComplete = false;
        if (this.pathString != null && !"".equalsIgnoreCase(this.pathString) && Path.ROOT.isValidPath(this.pathString)) {
            isPageComplete = true;
        }
        return isPageComplete;
    }

    public boolean finish() {
        Path path = new Path(this.pathString);
        VpeTemplateManager.getInstance().setAnyTemplates(this.tagsList, (IPath)path);
        return true;
    }
}

