/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.MenuComponent;
import org.richfaces.component.UIMenuItem;
import org.richfaces.component.util.ViewUtil;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.html.MenuItemRendererDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuItemRendererBase
extends CompositeRenderer {
    private MenuItemRendererDelegate delegate = new MenuItemRendererDelegate();

    protected Class getComponentClass() {
        return UIMenuItem.class;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void doDecode(FacesContext context, UIComponent component) {
        String mode;
        super.doDecode(context, component);
        ExternalContext exCtx = context.getExternalContext();
        Map rqMap = exCtx.getRequestParameterMap();
        Object clnId = rqMap.get(component.getClientId(context));
        if (clnId == null) {
            clnId = rqMap.get(component.getClientId(context) + ":hidden");
        }
        UIMenuItem menuItem = (UIMenuItem)component;
        if (clnId != null && !"none".equalsIgnoreCase(mode = this.resolveSubmitMode(menuItem))) {
            ActionEvent actionEvent = new ActionEvent((UIComponent)menuItem);
            if ("ajax".equalsIgnoreCase(mode)) {
                new AjaxEvent((UIComponent)menuItem).queue();
                if (AjaxRendererUtils.isAjaxRequest((FacesContext)context)) {
                    AjaxContext.getCurrentInstance((FacesContext)context).addAreasToProcessFromComponent(context, (UIComponent)menuItem);
                }
            }
            if (menuItem.isImmediate()) {
                actionEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                actionEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            menuItem.queueEvent((FacesEvent)actionEvent);
        }
    }

    public List encodeParams(FacesContext context, UIMenuItem component) throws IOException {
        UIMenuItem menuItem = component;
        ArrayList<String> params = new ArrayList<String>();
        List children = menuItem.getChildren();
        for (UIComponent child : children) {
            UIParameter param;
            String name;
            if (!(child instanceof UIParameter) || (name = (param = (UIParameter)child).getName()) == null) continue;
            StringBuffer buff = new StringBuffer();
            Object value = param.getValue();
            buff.append("params[");
            buff.append(ScriptUtils.toScript((Object)name));
            buff.append("] = ");
            buff.append(ScriptUtils.toScript((Object)value));
            buff.append(";");
            params.add(buff.toString());
        }
        return params;
    }

    public Map<String, Object> getParamsAsMap(FacesContext context, UIMenuItem component) throws IOException {
        LinkedHashMap<String, Object> paramsMap = new LinkedHashMap<String, Object>();
        for (UIComponent child : component.getChildren()) {
            UIParameter param;
            String name;
            if (!(child instanceof UIParameter) || (name = (param = (UIParameter)child).getName()) == null) continue;
            paramsMap.put(name, param.getValue());
        }
        return paramsMap;
    }

    protected boolean isNestedInMenu(UIComponent component) {
        for (UIComponent c = component; c != null; c = c.getParent()) {
            if (!(c instanceof MenuComponent)) continue;
            return true;
        }
        return false;
    }

    protected String collectItemInlineStyles(FacesContext context, UIMenuItem menuItem, boolean isOnmouseover) {
        return this.delegate.collectInlineStyles(context, (UIComponent)menuItem, isOnmouseover);
    }

    protected String collectItemClasses(FacesContext context, UIMenuItem menuItem, boolean isOnmouseover) {
        return this.delegate.collectClasses(context, (UIComponent)menuItem, isOnmouseover);
    }

    public void initializeResources(FacesContext context, UIMenuItem menuItem) throws IOException {
        String resource;
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)menuItem);
        String string = resource = menuItem.isDisabled() ? ViewUtil.getResourceURL((String)menuItem.getIconDisabled()) : ViewUtil.getResourceURL((String)menuItem.getIcon());
        if (resource == null || resource.length() == 0) {
            resource = this.getResource("images/spacer.gif").getUri(context, (Object)menuItem);
        }
        variables.setVariable("icon", (Object)resource);
        RendererUtils rendererUtils = this.getUtils();
        if (menuItem.isDisabled()) {
            variables.setVariable("iconDisabledClasses", (Object)"rich-menu-item-icon-disabled");
        } else {
            Map menuItemAttributes = menuItem.getAttributes();
            HashMap attrMap = new HashMap(3);
            if (!this.isNestedInMenu((UIComponent)menuItem)) {
                rendererUtils.addToScriptHash(attrMap, "styleClass", menuItemAttributes.get("styleClass"), null, RendererUtils.ScriptHashVariableWrapper.DEFAULT);
                rendererUtils.addToScriptHash(attrMap, "onselect", menuItemAttributes.get("onselect"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
            }
            StringBuilder scriptValue = new StringBuilder();
            String mode = this.resolveSubmitMode(menuItem);
            if ("ajax".equalsIgnoreCase(mode)) {
                scriptValue.append("RichFaces.Menu.updateItem(event,this");
                if (!attrMap.isEmpty()) {
                    scriptValue.append(',');
                    scriptValue.append(ScriptUtils.toScript(attrMap));
                }
                scriptValue.append(");");
                String event = null;
                Object onclick = menuItemAttributes.get("onclick");
                if (onclick != null && onclick.toString().length() > 0) {
                    event = "onclick";
                } else {
                    Object onselect = menuItemAttributes.get("onselect");
                    if (onselect != null && onselect.toString().length() > 0) {
                        event = "onselect";
                    }
                }
                scriptValue.append(AjaxRendererUtils.buildOnEvent((UIComponent)menuItem, (FacesContext)context, (String)event, (boolean)true).toString());
                menuItemAttributes.put("onselect", null);
            } else if ("server".equalsIgnoreCase(mode)) {
                Object onclick = menuItemAttributes.get("onclick");
                if (onclick != null && onclick.toString().length() > 0) {
                    scriptValue.append(onclick.toString());
                    scriptValue.append(";");
                }
                scriptValue.append("RichFaces.Menu.submitForm(event,this");
                HashMap scriptOptionsMap = new HashMap(5);
                rendererUtils.addToScriptHash(scriptOptionsMap, "a", attrMap, null, RendererUtils.ScriptHashVariableWrapper.DEFAULT);
                Map<String, Object> paramsMap = this.getParamsAsMap(context, menuItem);
                rendererUtils.addToScriptHash(scriptOptionsMap, "p", paramsMap, null, RendererUtils.ScriptHashVariableWrapper.DEFAULT);
                String target = (String)menuItemAttributes.get("target");
                rendererUtils.addToScriptHash(scriptOptionsMap, "t", (Object)target, null, RendererUtils.ScriptHashVariableWrapper.DEFAULT);
                if (!scriptOptionsMap.isEmpty()) {
                    scriptValue.append(',');
                    scriptValue.append(ScriptUtils.toScript(scriptOptionsMap));
                }
                scriptValue.append(")");
            } else {
                scriptValue.append("RichFaces.Menu.updateItem(event,this");
                if (!attrMap.isEmpty()) {
                    scriptValue.append(',');
                    scriptValue.append(ScriptUtils.toScript(attrMap));
                }
                scriptValue.append(");");
                scriptValue.append(this.getStringAttributeOrEmptyString((UIComponent)menuItem, "onclick"));
            }
            if (resource.length() > 0) {
                variables.setVariable("onclick", (Object)scriptValue.toString());
            }
        }
    }

    protected String getStringAttributeOrEmptyString(UIComponent component, String attributeName) {
        String attributeValue = (String)component.getAttributes().get(attributeName);
        if (null == attributeValue) {
            attributeValue = "";
        }
        return attributeValue;
    }

    protected UIComponent getIconFacet(UIMenuItem menuItem) {
        UIComponent iconFacet = null;
        iconFacet = menuItem.isDisabled() ? menuItem.getFacet("iconDisabled") : menuItem.getFacet("icon");
        return iconFacet;
    }

    protected String resolveSubmitMode(UIMenuItem menuItem) {
        String submitMode = menuItem.getSubmitMode();
        if (null != submitMode) {
            return submitMode;
        }
        for (UIComponent parent = menuItem.getParent(); null != parent; parent = parent.getParent()) {
            if (!(parent instanceof MenuComponent)) continue;
            return ((MenuComponent)parent).getSubmitMode();
        }
        return "server";
    }

    protected UIComponent getParentMenu(FacesContext context, UIMenuItem menuItem) {
        return this.delegate.getParentMenu(context, (UIComponent)menuItem);
    }

    public void initializeStyles(FacesContext context, UIMenuItem menuItem) {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)menuItem);
        this.delegate.initializeStyles(context, (UIComponent)menuItem, menuItem.isDisabled(), variables);
    }

    public String toScript(Map<?, ?> map) {
        return ScriptUtils.toScript(map);
    }
}

