/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;

public abstract class ColorUtils {
    public static float[] RGBtoHSL(int r, int g, int b) {
        float varR = (float)r / 255.0f;
        float varG = (float)g / 255.0f;
        float varB = (float)b / 255.0f;
        float varMin = Math.min(varR, Math.min(varG, varB));
        float varMax = Math.max(varR, Math.max(varG, varB));
        float delMax = varMax - varMin;
        float h = 0.0f;
        float s = 0.0f;
        float l = (varMax + varMin) / 2.0f;
        if (delMax == 0.0f || l == 0.0f) {
            s = 0.0f;
        } else if (l == 1.0f) {
            s = 1.0f;
        } else if ((double)l <= 0.5) {
            s = delMax / (2.0f * (1.0f - l));
        } else if ((double)l > 0.5) {
            s = delMax / (2.0f * l);
        }
        if (delMax == 0.0f) {
            h = 0.0f;
        } else if (varMax == varR && g >= b) {
            h = 60.0f * (varG - varB) / delMax + 0.0f;
        } else if (varMax == varR && varG < (float)b) {
            h = 60.0f * (varG - varB) / delMax + 360.0f;
        } else if (varMax == varG) {
            h = 60.0f * (varB - varR) / delMax + 120.0f;
        } else if (varMax == varB) {
            h = 60.0f * (varR - varG) / delMax + 240.0f;
        }
        return new float[]{h, s, l};
    }

    public static Color HSLtoRGB(float h, float s, float l) {
        float q = (double)l < 0.5 ? l * (1.0f + s) : l + s - l * s;
        float p = 2.0f * l - q;
        float hNorm = h / 360.0f;
        float tR = hNorm + 0.33333334f;
        float tG = hNorm;
        float tB = hNorm - 0.33333334f;
        float r = ColorUtils.tC2C(tR, p, q);
        float g = ColorUtils.tC2C(tG, p, q);
        float b = ColorUtils.tC2C(tB, p, q);
        return new Color(r, g, b);
    }

    private static float tC2C(float tC, float p, float q) {
        if (tC < 0.0f) {
            tC += 1.0f;
        }
        if (tC > 1.0f) {
            tC -= 1.0f;
        }
        float retVal = 6.0f * tC < 1.0f ? p + (q - p) * 6.0f * tC : (2.0f * tC < 1.0f ? q : (3.0f * tC < 2.0f ? p + (q - p) * 6.0f * (0.6666667f - tC) : p));
        return retVal;
    }

    public static Color adjustBrightness(Color c, float difference) {
        if ((double)difference < -1.0 || (double)difference > 1.0) {
            throw new IllegalArgumentException("Difference parameter outside of expected range: Difference parameter should be floating-point values between -1 and 1");
        }
        Color retVal = null;
        if (c != null) {
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            float brightness = Math.min(1.0f, Math.max(0.0f, hsb[2] + difference));
            retVal = new Color(Color.HSBtoRGB(hsb[0], hsb[1], brightness));
        }
        return retVal;
    }

    public static Color adjustLightness(Color c, float difference) {
        if ((double)difference < -1.0 || (double)difference > 1.0) {
            throw new IllegalArgumentException("Difference parameter outside of expected range: Difference parameter should be floating-point values between -1 and 1");
        }
        Color retVal = null;
        if (c != null) {
            float[] hsl = ColorUtils.RGBtoHSL(c.getRed(), c.getGreen(), c.getBlue());
            float lightness = Math.min(1.0f, Math.max(0.0f, hsl[2] + difference));
            retVal = ColorUtils.HSLtoRGB(hsl[0], hsl[1], lightness);
        }
        return retVal;
    }

    public static Color overwriteAlpha(Color c, float alpha) {
        Color retVal = c;
        if (c != null) {
            retVal = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)((double)(alpha * 255.0f) + 0.5));
        }
        return retVal;
    }
}

