package org.jboss.eap.util.xp.patch.stream.manager;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public class ManagerActionUtils {
    private static final String SERVER_TARGET_STREAMS = "server-target-streams";
    private static final String SERVER_TARGET_LAYERS = "server-target-layers";
    private static final String SERVER_TARGET_PATCH_NAME_PATTERNS = "server-target-patch-name-patterns";

    static List<String> getManagedModuleLayerNames() throws Exception {
        return ManagerActionUtils.readList(SERVER_TARGET_LAYERS);
    }

    static List<String> getManagedPatchStreamNames() throws Exception {
        return ManagerActionUtils.readList(SERVER_TARGET_STREAMS);
    }

    static List<String> getManagedPatchNamePatterns() throws Exception {
        return ManagerActionUtils.readList(SERVER_TARGET_PATCH_NAME_PATTERNS);
    }

    static List<String> readList(String name) throws Exception {
        String rawLayers = readValue(name);
        if (rawLayers == null) {
            return Collections.emptyList();
        }
        List<String> layers = new ArrayList<>();
        String[] tokens = rawLayers.split(",");
        for (String layer : tokens) {
            layer = layer.trim();
            if (layer.length() > 0) {
                layers.add(layer);
            }
        }
        return layers;
    }

    static String readValue(String name) throws Exception {
        // Doing a simple ManifestUtils.class.getClassLoader().getResource("META-INF/MANIFEST.MF") doesn't always work
        // since it sometimes first tries to load from jar:file:/System/Library/Java/Extensions/MRJToolkit.jar!/META-INF/MANIFEST.MF
        for (Enumeration<URL> e = ManagerActionUtils.class.getClassLoader().getResources("META-INF/MANIFEST.MF"); e.hasMoreElements() ; ) {
            URL url = e.nextElement();
            try (InputStream stream = url.openStream()) {
                Manifest manifest = null;
                if (stream != null) {
                    manifest = new Manifest(stream);
                    String value = manifest.getMainAttributes().getValue(name);
                    if (value != null) {
                        return value;
                    }
                }
            }
        }

        throw ManagerLogger.LOGGER.manifestEntryNotFound(name);
    }
}
