/*
 * JBoss, Home of Professional Open Source.
 *
 * Copyright 2022 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wildfly.test.integration.observability.opentelemetry;

import static org.wildfly.test.integration.observability.setuptask.ServiceNameSetupTask.SERVICE_NAME;

import java.util.List;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.testcontainers.api.DockerRequired;
import org.jboss.as.arquillian.api.ContainerResource;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.test.integration.observability.container.OpenTelemetryCollectorContainer;
import org.wildfly.test.integration.observability.opentelemetry.jaeger.JaegerTrace;
import org.wildfly.test.integration.observability.setuptask.OpenTelemetrySetupTask;
import org.wildfly.test.integration.observability.setuptask.ServiceNameSetupTask;

@RunWith(Arquillian.class)
@ServerSetup({OpenTelemetrySetupTask.class})
@RunAsClient
@DockerRequired(AssumptionViolatedException.class)
public class OpenTelemetryIntegrationTestCase extends BaseOpenTelemetryTest {
    @ContainerResource
    ManagementClient managementClient;

    @Deployment
    public static WebArchive getDeployment() {
        return buildBaseArchive(OpenTelemetryIntegrationTestCase.class.getSimpleName());
    }

    @Test
    @InSequence(1)
    public void setup() throws Exception {
        new ServiceNameSetupTask().setup(managementClient, null);
    }

    @Test
    @InSequence(2)
    public void testServiceNameOverride() throws Exception {
        try (Client client = ClientBuilder.newClient()) {
            Response response = client.target(url.toURI()).request().get();
            Assert.assertEquals(200, response.getStatus());
        }

        List<JaegerTrace> traces = OpenTelemetryCollectorContainer.getInstance()
                .getTraces(SERVICE_NAME);
        Assert.assertFalse("Traces not found for service", traces.isEmpty());
    }

    @Test
    @InSequence(3)
    public void tearDown() throws Exception {
        new ServiceNameSetupTask().tearDown(managementClient, null);
    }
}
