/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jbossatx.jts.jca;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TxImporter;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TxWorkManager;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.WorkSynchronization;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.XATerminatorImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.tm.JBossXATerminator;
import org.jboss.util.UnexpectedThrowable;

public class XATerminator
extends XATerminatorImple
implements JBossXATerminator {
    public void registerWork(Work work, Xid xid, long timeout) throws WorkCompletedException {
        try {
            TransactionImple tx = TxImporter.importTransaction((Xid)xid, (int)((int)timeout));
            switch (tx.getStatus()) {
                case 5: 
                case 6: {
                    throw new WorkCompletedException(jtaLogger.logMesg.getString("com.arjuna.ats.jbossatx.jts.jca.inactive"), "3");
                }
                case 0: {
                    break;
                }
                default: {
                    throw new WorkCompletedException(jtaLogger.logMesg.getString("com.arjuna.ats.jbossatx.jts.jca.completing"), "2");
                }
            }
            TxWorkManager.addWork((Work)work, (TransactionImple)tx);
            tx.registerSynchronization((Synchronization)new WorkSynchronization(tx));
        }
        catch (WorkCompletedException ex) {
            throw ex;
        }
        catch (XAException ex) {
            throw new WorkCompletedException((Throwable)ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new WorkCompletedException(jtaLogger.logMesg.getString("com.arjuna.ats.jbossatx.jts.jca.unknown"), "-1");
        }
    }

    public void startWork(Work work, Xid xid) throws WorkCompletedException {
        try {
            TransactionImple tx = TxImporter.importTransaction((Xid)xid);
            if (!TxWorkManager.getWork((TransactionImple)tx).equals(work)) {
                throw new WorkCompletedException(jtaLogger.logMesg.getString("com.arjuna.ats.jbossatx.jts.jca.unknownwork"), "-1");
            }
            TransactionManager.transactionManager().resume((Transaction)tx);
        }
        catch (XAException ex) {
            throw new WorkCompletedException((Throwable)ex);
        }
        catch (InvalidTransactionException ex) {
            throw new WorkCompletedException(jtaLogger.logMesg.getString("com.arjuna.ats.jbossatx.jts.jca.inactive"), "3");
        }
        catch (SystemException ex) {
            throw new WorkCompletedException(jtaLogger.logMesg.getString("com.arjuna.ats.jbossatx.jts.jca.unknown"), "-1");
        }
    }

    public void endWork(Work work, Xid xid) {
        try {
            TransactionImple tx = TxImporter.importTransaction((Xid)xid);
            TransactionManager.transactionManager().suspend();
            TxWorkManager.removeWork((Work)work, (TransactionImple)tx);
        }
        catch (Exception ex) {
            throw new UnexpectedThrowable((Throwable)ex);
        }
    }

    public void cancelWork(Work work, Xid xid) {
        try {
            TransactionImple tx = TxImporter.importTransaction((Xid)xid);
            TxWorkManager.removeWork((Work)work, (TransactionImple)tx);
        }
        catch (Exception ex) {
            throw new UnexpectedThrowable((Throwable)ex);
        }
    }
}

