/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.mail;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.mail.inflow.MailActivation;
import org.jboss.resource.adapter.mail.inflow.MailActivationSpec;
import org.jboss.resource.adapter.mail.inflow.NewMsgsWorker;

public class MailResourceAdapter
implements ResourceAdapter {
    private static Logger log = Logger.getLogger((Class)MailResourceAdapter.class);
    private BootstrapContext ctx;
    private ConcurrentReaderHashMap activations = new ConcurrentReaderHashMap();
    private NewMsgsWorker newMsgsWorker;

    public WorkManager getWorkManager() {
        return this.ctx.getWorkManager();
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        log.debug((Object)"start");
        this.ctx = ctx;
        WorkManager mgr = ctx.getWorkManager();
        this.newMsgsWorker = new NewMsgsWorker(mgr);
        try {
            mgr.scheduleWork((Work)this.newMsgsWorker);
        }
        catch (WorkException e) {
            throw new ResourceAdapterInternalException((Throwable)e);
        }
    }

    public void stop() {
        log.debug((Object)"stop");
        this.newMsgsWorker.release();
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        log.debug((Object)("endpointActivation, spec=" + spec));
        MailActivationSpec mailSpec = (MailActivationSpec)spec;
        MailActivation activation = new MailActivation(this, endpointFactory, mailSpec);
        try {
            this.newMsgsWorker.watch(activation);
        }
        catch (InterruptedException e) {
            throw new ResourceException("Failed to schedule new msg check", (Throwable)e);
        }
        this.activations.put((Object)spec, (Object)activation);
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        log.debug((Object)("endpointDeactivation, spec=" + spec));
        MailActivation activation = (MailActivation)this.activations.remove((Object)spec);
        if (activation != null) {
            activation.release();
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return new XAResource[0];
    }
}

