/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.encoding.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.http.HTTPException;
import org.jboss.com.sun.xml.messaging.saaj.packaging.mime.MessagingException;
import org.jboss.com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType;
import org.jboss.com.sun.xml.messaging.saaj.packaging.mime.internet.InternetHeaders;
import org.jboss.com.sun.xml.messaging.saaj.packaging.mime.internet.MimeBodyPart;
import org.jboss.com.sun.xml.messaging.saaj.packaging.mime.internet.MimeMultipart;
import org.jboss.com.sun.xml.messaging.saaj.soap.AttachmentPartImpl;
import org.jboss.com.sun.xml.messaging.saaj.util.ByteInputStream;
import org.jboss.com.sun.xml.messaging.saaj.util.ByteOutputStream;
import org.jboss.com.sun.xml.ws.encoding.jaxb.JAXBTypeSerializer;
import org.jboss.com.sun.xml.ws.protocol.xml.XMLMessageException;
import org.jboss.com.sun.xml.ws.streaming.XMLStreamWriterFactory;
import org.jboss.com.sun.xml.ws.util.ByteArrayBuffer;
import org.jboss.com.sun.xml.ws.util.FastInfosetReflection;
import org.jboss.com.sun.xml.ws.util.FastInfosetUtil;
import org.jboss.com.sun.xml.ws.util.xml.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLMessage {
    private static final Logger log = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.protocol.xml");
    private static final int PLAIN_XML_FLAG = 1;
    private static final int MIME_MULTIPART_FLAG = 2;
    private static final int FI_ENCODED_FLAG = 16;
    private final DataRepresentation data;
    protected boolean useFastInfoset = false;

    public XMLMessage(MimeHeaders headers, InputStream in) {
        String ct = null;
        if (headers != null) {
            ct = XMLMessage.getContentType(headers);
        }
        this.data = this.getData(ct, in);
    }

    private InputStream hasSomeData(InputStream in) throws IOException {
        if (in != null && in.available() < 1) {
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
            in.mark(1);
            if (in.read() != -1) {
                in.reset();
            } else {
                in = null;
            }
        }
        return in;
    }

    private DataRepresentation getData(String ct, InputStream in) {
        DataRepresentation data;
        try {
            in = this.hasSomeData(in);
            if (in == null) {
                return new NullContent();
            }
            if (ct != null) {
                boolean isFastInfoset;
                ContentType contentType = new ContentType(ct);
                int contentTypeId = XMLMessage.identifyContentType(contentType);
                boolean bl = isFastInfoset = (contentTypeId & 0x10) > 0;
                data = (contentTypeId & 2) != 0 ? new XMLMultiPart(ct, in, isFastInfoset) : ((contentTypeId & 1) != 0 || (contentTypeId & 0x10) != 0 ? new XMLSource(in, isFastInfoset) : new UnknownContent(ct, in));
            } else {
                data = new NullContent();
            }
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
        return data;
    }

    public XMLMessage(Source source, boolean useFastInfoset) {
        this.data = source == null ? new NullContent() : new XMLSource(source);
        this.useFastInfoset = useFastInfoset;
        this.data.getMimeHeaders().addHeader("Content-Type", useFastInfoset ? "application/fastinfoset" : "text/xml");
    }

    public XMLMessage(Exception err, boolean useFastInfoset) {
        this.data = new XMLErr(err);
        this.useFastInfoset = useFastInfoset;
        this.data.getMimeHeaders().addHeader("Content-Type", useFastInfoset ? "application/fastinfoset" : "text/xml");
    }

    public XMLMessage(DataSource ds, boolean useFastInfoset) {
        this.useFastInfoset = useFastInfoset;
        try {
            this.data = ds == null ? new NullContent() : this.getData(ds.getContentType(), ds.getInputStream());
        }
        catch (IOException ioe) {
            throw new WebServiceException((Throwable)ioe);
        }
        String contentType = ds != null ? ds.getContentType() : null;
        contentType = contentType == null ? (contentType = "text/xml") : contentType;
        this.data.getMimeHeaders().addHeader("Content-Type", !useFastInfoset ? contentType : contentType.replaceFirst("text/xml", "application/fastinfoset"));
    }

    public XMLMessage(Object object, JAXBContext context, boolean useFastInfoset) {
        this.data = object == null ? new NullContent() : new XMLJaxb(object, context);
        this.useFastInfoset = useFastInfoset;
        this.data.getMimeHeaders().addHeader("Content-Type", useFastInfoset ? "application/fastinfoset" : "text/xml");
    }

    public XMLMessage(Source source, Map<String, DataHandler> attachments, boolean useFastInfoset) {
        this.data = attachments == null ? (source == null ? new NullContent() : new XMLSource(source)) : (source == null ? new UnknownContent(attachments) : new XMLMultiPart(source, attachments, useFastInfoset));
        this.useFastInfoset = useFastInfoset;
        this.data.getMimeHeaders().addHeader("Content-Type", useFastInfoset ? "application/fastinfoset" : "text/xml");
    }

    public XMLMessage(Object object, JAXBContext context, Map<String, DataHandler> attachments, boolean useFastInfoset) {
        this.data = attachments == null ? (object == null ? new NullContent() : new XMLJaxb(object, context)) : (object == null ? new UnknownContent(attachments) : new XMLMultiPart(JAXBTypeSerializer.serialize(object, context), attachments, useFastInfoset));
        this.useFastInfoset = useFastInfoset;
        this.data.getMimeHeaders().addHeader("Content-Type", useFastInfoset ? "application/fastinfoset" : "text/xml");
    }

    public boolean isFastInfoset() {
        return this.data.isFastInfoset();
    }

    public boolean useFastInfoset() {
        return this.useFastInfoset;
    }

    public boolean acceptFastInfoset() {
        return FastInfosetUtil.isFastInfosetAccepted(this.getMimeHeaders().getHeader("Accept"));
    }

    public Source getSource() {
        return this.data.getSource();
    }

    public DataSource getDataSource() {
        return this.data.getDataSource();
    }

    private static int identifyContentType(ContentType contentType) {
        String primary = contentType.getPrimaryType();
        String sub = contentType.getSubType();
        if (primary.equalsIgnoreCase("multipart") && sub.equalsIgnoreCase("related")) {
            String type = contentType.getParameter("type");
            if (type != null) {
                if (XMLMessage.isXMLType(type)) {
                    return 3;
                }
                if (XMLMessage.isFastInfosetType(type)) {
                    return 18;
                }
            }
            return 0;
        }
        if (XMLMessage.isXMLType(primary, sub)) {
            return 1;
        }
        if (XMLMessage.isFastInfosetType(primary, sub)) {
            return 16;
        }
        return 0;
    }

    protected static boolean isXMLType(String primary, String sub) {
        return (primary.equalsIgnoreCase("text") || primary.equalsIgnoreCase("application")) && sub.equalsIgnoreCase("xml");
    }

    protected static boolean isXMLType(String type) {
        return type.toLowerCase().startsWith("text/xml") || type.toLowerCase().startsWith("application/xml");
    }

    protected static boolean isFastInfosetType(String primary, String sub) {
        return primary.equalsIgnoreCase("application") && sub.equalsIgnoreCase("fastinfoset");
    }

    protected static boolean isFastInfosetType(String type) {
        return type.toLowerCase().startsWith("application/fastinfoset");
    }

    public MimeHeaders getMimeHeaders() {
        return this.data.getMimeHeaders();
    }

    private static String getContentType(MimeHeaders headers) {
        String[] values = headers.getHeader("Content-Type");
        return values == null ? null : values[0];
    }

    public int getStatus() {
        return this.data.getStatus();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.data.writeTo(out, this.useFastInfoset);
    }

    public Source getPayload() {
        return this.data.getPayload();
    }

    public Map<String, DataHandler> getAttachments() {
        return this.data.getAttachments();
    }

    public Object getPayload(JAXBContext context) {
        return JAXBTypeSerializer.deserialize(this.getPayload(), context);
    }

    static {
        new AttachmentPartImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NullContent
    extends DataRepresentation {
        private final MimeHeaders headers = new MimeHeaders();

        private NullContent() {
        }

        @Override
        public Source getPayload() {
            return null;
        }

        @Override
        public Map<String, DataHandler> getAttachments() {
            return null;
        }

        @Override
        public void writeTo(OutputStream out, boolean useFastInfoset) throws IOException {
        }

        @Override
        boolean isFastInfoset() {
            return false;
        }

        @Override
        Source getSource() {
            return null;
        }

        @Override
        DataSource getDataSource() {
            return null;
        }

        @Override
        MimeHeaders getMimeHeaders() {
            return this.headers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XMLErr
    extends DataRepresentation {
        private final Exception err;
        private final MimeHeaders headers = new MimeHeaders();

        XMLErr(Exception err) {
            this.err = err;
        }

        @Override
        public Source getPayload() {
            return null;
        }

        @Override
        public Map<String, DataHandler> getAttachments() {
            return null;
        }

        @Override
        public void writeTo(OutputStream out, boolean useFastInfoset) throws IOException {
            String msg = this.err.getMessage();
            if (msg == null) {
                msg = this.err.toString();
            }
            msg = "<err>" + msg + "</err>";
            if (useFastInfoset) {
                FastInfosetUtil.transcodeXMLStringToFI(msg, out);
            } else {
                out.write(msg.getBytes());
            }
        }

        @Override
        boolean isFastInfoset() {
            return false;
        }

        @Override
        Source getSource() {
            return null;
        }

        @Override
        DataSource getDataSource() {
            return null;
        }

        @Override
        int getStatus() {
            if (this.err instanceof HTTPException) {
                return ((HTTPException)this.err).getStatusCode();
            }
            return 500;
        }

        @Override
        MimeHeaders getMimeHeaders() {
            return this.headers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnknownContent
    extends DataRepresentation {
        private final String ct;
        private final InputStream in;
        private final MimeMultipart multipart;
        private final MimeHeaders headers = new MimeHeaders();

        public UnknownContent(String ct, InputStream in) {
            this.ct = ct;
            this.in = in;
            this.multipart = null;
        }

        public UnknownContent(Map<String, DataHandler> atts) {
            this.in = null;
            this.multipart = new MimeMultipart("mixed");
            for (Map.Entry<String, DataHandler> e : atts.entrySet()) {
                MimeBodyPart part = new MimeBodyPart();
                part.setDataHandler(e.getValue());
                this.multipart.addBodyPart(part);
            }
            this.ct = this.multipart.getContentType().toString();
        }

        @Override
        public void writeTo(OutputStream out, boolean useFastInfoset) {
            try {
                int len;
                if (this.multipart != null) {
                    this.multipart.writeTo(out);
                }
                byte[] buf = new byte[1024];
                while ((len = this.in.read(buf)) != -1) {
                    out.write(buf, 0, len);
                }
            }
            catch (Exception ex) {
                throw new WebServiceException((Throwable)ex);
            }
        }

        @Override
        boolean isFastInfoset() {
            return false;
        }

        @Override
        public Source getSource() {
            return null;
        }

        @Override
        DataSource getDataSource() {
            return new DataSource(){

                public InputStream getInputStream() {
                    if (UnknownContent.this.multipart != null) {
                        try {
                            ByteOutputStream bos = new ByteOutputStream();
                            UnknownContent.this.multipart.writeTo((OutputStream)bos);
                            return bos.newInputStream();
                        }
                        catch (Exception ioe) {
                            throw new WebServiceException((Throwable)ioe);
                        }
                    }
                    return UnknownContent.this.in;
                }

                public OutputStream getOutputStream() {
                    return null;
                }

                public String getContentType() {
                    assert (UnknownContent.this.ct != null);
                    return UnknownContent.this.ct;
                }

                public String getName() {
                    return "";
                }
            };
        }

        @Override
        public Source getPayload() {
            return null;
        }

        @Override
        public Map<String, DataHandler> getAttachments() {
            return null;
        }

        @Override
        MimeHeaders getMimeHeaders() {
            this.headers.removeHeader("Content-Type");
            this.headers.addHeader("Content-Type", this.ct);
            return this.headers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XMLJaxb
    extends DataRepresentation {
        private final Object object;
        private final JAXBContext jaxbContext;
        private final MimeHeaders headers = new MimeHeaders();

        public XMLJaxb(Object object, JAXBContext jaxbContext) {
            this.object = object;
            this.jaxbContext = jaxbContext;
        }

        @Override
        public void writeTo(OutputStream out, boolean useFastInfoset) {
            if (useFastInfoset) {
                JAXBTypeSerializer.serializeDocument(this.object, XMLStreamWriterFactory.createFIStreamWriter(out), this.jaxbContext);
            } else {
                JAXBTypeSerializer.serialize(this.object, out, this.jaxbContext);
            }
        }

        @Override
        boolean isFastInfoset() {
            return false;
        }

        @Override
        public Source getSource() {
            return JAXBTypeSerializer.serialize(this.object, this.jaxbContext);
        }

        @Override
        DataSource getDataSource() {
            return new DataSource(){

                public InputStream getInputStream() {
                    ByteOutputStream bos = new ByteOutputStream();
                    JAXBTypeSerializer.serialize(XMLJaxb.this.object, (OutputStream)bos, XMLJaxb.this.jaxbContext);
                    return bos.newInputStream();
                }

                public OutputStream getOutputStream() {
                    return null;
                }

                public String getContentType() {
                    return XMLJaxb.this.isFastInfoset() ? "application/fastinfoset" : "text/xml";
                }

                public String getName() {
                    return "";
                }
            };
        }

        @Override
        public Source getPayload() {
            return this.getSource();
        }

        @Override
        public Map<String, DataHandler> getAttachments() {
            return null;
        }

        @Override
        MimeHeaders getMimeHeaders() {
            return this.headers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XMLSource
    extends DataRepresentation {
        private Source source;
        private boolean isFastInfoset;
        private final MimeHeaders headers = new MimeHeaders();

        public XMLSource(InputStream in, boolean isFastInfoset) throws Exception {
            this.source = isFastInfoset ? FastInfosetReflection.FastInfosetSource_new(in) : new StreamSource(in);
            this.isFastInfoset = isFastInfoset;
        }

        public XMLSource(Source source) {
            this.source = source;
            this.isFastInfoset = source != null ? source.getClass() == FastInfosetReflection.fiFastInfosetSource : false;
        }

        @Override
        public boolean isFastInfoset() {
            return this.isFastInfoset;
        }

        @Override
        public void writeTo(OutputStream out, boolean useFastInfoset) {
            try {
                InputStream is = null;
                boolean canAvoidTransform = false;
                if (this.source instanceof StreamSource) {
                    is = ((StreamSource)this.source).getInputStream();
                    canAvoidTransform = !useFastInfoset;
                } else if (this.source.getClass() == FastInfosetReflection.fiFastInfosetSource) {
                    is = FastInfosetReflection.FastInfosetSource_getInputStream(this.source);
                    canAvoidTransform = useFastInfoset;
                }
                if (canAvoidTransform && is != null && is instanceof ByteInputStream) {
                    ByteInputStream bis = (ByteInputStream)is;
                    byte[] buf = bis.getBytes();
                    out.write(buf);
                    bis.close();
                    return;
                }
                Transformer transformer = XmlUtil.newTransformer();
                transformer.transform(this.source, useFastInfoset ? FastInfosetReflection.FastInfosetResult_new(out) : new StreamResult(out));
            }
            catch (Exception e) {
                throw new WebServiceException((Throwable)e);
            }
        }

        @Override
        public Source getSource() {
            return this.source;
        }

        @Override
        DataSource getDataSource() {
            return new DataSource(){

                public InputStream getInputStream() {
                    try {
                        InputStream is = null;
                        if (XMLSource.this.source instanceof StreamSource) {
                            is = ((StreamSource)XMLSource.this.source).getInputStream();
                        } else if (XMLSource.this.source.getClass() == FastInfosetReflection.fiFastInfosetSource) {
                            is = FastInfosetReflection.FastInfosetSource_getInputStream(XMLSource.this.source);
                        }
                        if (is != null) {
                            return is;
                        }
                        ByteArrayBuffer bab = new ByteArrayBuffer();
                        Transformer transformer = XmlUtil.newTransformer();
                        transformer.transform(XMLSource.this.source, XMLSource.this.isFastInfoset() ? FastInfosetReflection.FastInfosetResult_new(bab) : new StreamResult(bab));
                        bab.close();
                        return bab.newInputStream();
                    }
                    catch (Exception e) {
                        throw new WebServiceException((Throwable)e);
                    }
                }

                public OutputStream getOutputStream() {
                    return null;
                }

                public String getContentType() {
                    return XMLSource.this.isFastInfoset() ? "application/fastinfoset" : "text/xml";
                }

                public String getName() {
                    return "";
                }
            };
        }

        @Override
        public Source getPayload() {
            try {
                if (this.source instanceof DOMSource) {
                    return this.source;
                }
                InputStream is = null;
                if (this.source instanceof StreamSource) {
                    is = ((StreamSource)this.source).getInputStream();
                } else if (this.source.getClass() == FastInfosetReflection.fiFastInfosetSource) {
                    is = FastInfosetReflection.FastInfosetSource_getInputStream(this.source);
                }
                if (is != null && is instanceof ByteInputStream) {
                    ByteInputStream bis = (ByteInputStream)is;
                    byte[] buf = bis.getBytes();
                    ByteArrayInputStream bais = new ByteArrayInputStream(buf);
                    bis.close();
                    return this.isFastInfoset ? FastInfosetReflection.FastInfosetSource_new(is) : new StreamSource(bais);
                }
                ByteArrayBuffer bab = new ByteArrayBuffer();
                Transformer transformer = XmlUtil.newTransformer();
                Properties oprops = new Properties();
                oprops.put("omit-xml-declaration", "yes");
                transformer.setOutputProperties(oprops);
                transformer.transform(this.source, this.isFastInfoset ? FastInfosetReflection.FastInfosetResult_new(bab) : new StreamResult(bab));
                bab.close();
                InputStream bis = bab.size() == 0 ? null : bab.newInputStream();
                this.source = this.isFastInfoset ? FastInfosetReflection.FastInfosetSource_new(bis) : new StreamSource(bis);
                bis = bab.newInputStream();
                return this.isFastInfoset ? FastInfosetReflection.FastInfosetSource_new(bis) : new StreamSource(bis);
            }
            catch (Exception e) {
                throw new WebServiceException((Throwable)e);
            }
        }

        @Override
        public Map<String, DataHandler> getAttachments() {
            return null;
        }

        @Override
        MimeHeaders getMimeHeaders() {
            return this.headers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XMLMultiPart
    extends DataRepresentation {
        private DataSource dataSource;
        private MimeMultipart multipart;
        private XMLSource xmlSource;
        private boolean isFastInfoset;
        private final MimeHeaders headers = new MimeHeaders();

        public XMLMultiPart(final String contentType, final InputStream is, boolean isFastInfoset) {
            this.isFastInfoset = isFastInfoset;
            this.dataSource = new DataSource(){

                public InputStream getInputStream() {
                    return is;
                }

                public OutputStream getOutputStream() {
                    return null;
                }

                public String getContentType() {
                    return contentType;
                }

                public String getName() {
                    return "";
                }
            };
        }

        public XMLMultiPart(Source source, Map<String, DataHandler> atts, boolean isFastInfoset) {
            this.isFastInfoset = isFastInfoset;
            this.multipart = new MimeMultipart("related");
            this.multipart.getContentType().setParameter("type", "text/xml");
            ByteOutputStream bos = new ByteOutputStream();
            new XMLSource(source).writeTo((OutputStream)bos, isFastInfoset);
            InternetHeaders headers = new InternetHeaders();
            headers.addHeader("Content-Type", isFastInfoset ? "application/fastinfoset" : "text/xml");
            MimeBodyPart rootPart = new MimeBodyPart(headers, bos.getBytes(), bos.getCount());
            this.multipart.addBodyPart(rootPart, 0);
            for (Map.Entry<String, DataHandler> e : atts.entrySet()) {
                MimeBodyPart part = new MimeBodyPart();
                part.setDataHandler(e.getValue());
                this.multipart.addBodyPart(part);
            }
        }

        public XMLMultiPart(DataSource dataSource, boolean isFastInfoset) {
            this.dataSource = dataSource;
            this.isFastInfoset = isFastInfoset;
        }

        @Override
        public boolean isFastInfoset() {
            return this.isFastInfoset;
        }

        @Override
        public DataSource getDataSource() {
            if (this.dataSource != null) {
                return this.dataSource;
            }
            if (this.multipart != null) {
                return new DataSource(){

                    public InputStream getInputStream() {
                        try {
                            if (XMLMultiPart.this.xmlSource != null) {
                                XMLMultiPart.this.replaceRootPart(false);
                            }
                            ByteOutputStream bos = new ByteOutputStream();
                            XMLMultiPart.this.multipart.writeTo((OutputStream)bos);
                            return bos.newInputStream();
                        }
                        catch (MessagingException me) {
                            throw new XMLMessageException("xml.get.ds.err", new Object[]{me});
                        }
                        catch (IOException ioe) {
                            throw new XMLMessageException("xml.get.ds.err", ioe);
                        }
                    }

                    public OutputStream getOutputStream() {
                        return null;
                    }

                    public String getContentType() {
                        return XMLMultiPart.this.multipart.getContentType().toString();
                    }

                    public String getName() {
                        return "";
                    }
                };
            }
            return null;
        }

        private MimeBodyPart getRootPart() {
            try {
                this.convertToMultipart();
                ContentType contentType = this.multipart.getContentType();
                String startParam = contentType.getParameter("start");
                MimeBodyPart sourcePart = startParam == null ? this.multipart.getBodyPart(0) : this.multipart.getBodyPart(startParam);
                return sourcePart;
            }
            catch (MessagingException ex) {
                throw new XMLMessageException("xml.get.source.err", new Object[]{ex});
            }
        }

        private void replaceRootPart(boolean useFastInfoset) {
            if (this.xmlSource == null) {
                return;
            }
            try {
                MimeBodyPart sourcePart = this.getRootPart();
                String ctype = sourcePart.getContentType();
                this.multipart.removeBodyPart(sourcePart);
                ByteOutputStream bos = new ByteOutputStream();
                this.xmlSource.writeTo((OutputStream)bos, useFastInfoset);
                InternetHeaders headers = new InternetHeaders();
                headers.addHeader("Content-Type", useFastInfoset ? "application/fastinfoset" : ctype);
                sourcePart = new MimeBodyPart(headers, bos.getBytes(), bos.getCount());
                this.multipart.addBodyPart(sourcePart, 0);
            }
            catch (MessagingException ex) {
                throw new XMLMessageException("xml.get.source.err", new Object[]{ex});
            }
        }

        private void convertToMultipart() {
            if (this.dataSource != null) {
                try {
                    this.multipart = new MimeMultipart(this.dataSource, null);
                    this.dataSource = null;
                }
                catch (MessagingException ex) {
                    throw new XMLMessageException("xml.get.source.err", new Object[]{ex});
                }
            }
        }

        @Override
        public Source getSource() {
            try {
                if (this.xmlSource != null) {
                    return this.xmlSource.getPayload();
                }
                this.convertToMultipart();
                MimeBodyPart sourcePart = this.getRootPart();
                ContentType ctype = new ContentType(sourcePart.getContentType());
                String baseType = ctype.getBaseType();
                if (XMLMessage.isXMLType(baseType)) {
                    return new StreamSource(sourcePart.getInputStream());
                }
                if (XMLMessage.isFastInfosetType(baseType)) {
                    return FastInfosetReflection.FastInfosetSource_new(sourcePart.getInputStream());
                }
                throw new XMLMessageException("xml.root.part.invalid.Content-Type", baseType);
            }
            catch (MessagingException ex) {
                throw new XMLMessageException("xml.get.source.err", new Object[]{ex});
            }
            catch (Exception ioe) {
                throw new XMLMessageException("xml.get.source.err", ioe);
            }
        }

        @Override
        public Source getPayload() {
            return this.getSource();
        }

        @Override
        public void writeTo(OutputStream out, boolean useFastInfoset) {
            try {
                if (this.xmlSource != null) {
                    this.convertToMultipart();
                }
                if (this.dataSource != null) {
                    if (this.isFastInfoset == useFastInfoset) {
                        int len;
                        InputStream is = this.dataSource.getInputStream();
                        byte[] buf = new byte[1024];
                        while ((len = is.read(buf)) != -1) {
                            out.write(buf, 0, len);
                        }
                        return;
                    }
                    this.xmlSource = new XMLSource(this.getSource());
                }
                this.replaceRootPart(useFastInfoset);
                this.multipart.writeTo(out);
            }
            catch (Exception e) {
                throw new WebServiceException((Throwable)e);
            }
        }

        @Override
        public Map<String, DataHandler> getAttachments() {
            if (this.xmlSource != null) {
                this.convertToMultipart();
            }
            try {
                MimeBodyPart rootPart = this.getRootPart();
                HashMap<String, DataHandler> map = new HashMap<String, DataHandler>();
                int count = this.multipart.getCount();
                for (int i = 0; i < count; ++i) {
                    MimeBodyPart part = this.multipart.getBodyPart(i);
                    if (part == rootPart) continue;
                    map.put(part.getContentID(), part.getDataHandler());
                }
                return map;
            }
            catch (MessagingException ex) {
                throw new XMLMessageException("xml.get.source.err", new Object[]{ex});
            }
        }

        @Override
        MimeHeaders getMimeHeaders() {
            this.headers.removeHeader("Content-Type");
            if (this.dataSource != null) {
                this.headers.addHeader("Content-Type", this.dataSource.getContentType());
            } else if (this.multipart != null) {
                this.headers.addHeader("Content-Type", this.multipart.getContentType().toString());
            }
            return this.headers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class DataRepresentation {
        private DataRepresentation() {
        }

        abstract Source getPayload();

        abstract void writeTo(OutputStream var1, boolean var2) throws IOException;

        abstract boolean isFastInfoset();

        abstract Source getSource();

        abstract DataSource getDataSource();

        abstract Map<String, DataHandler> getAttachments();

        abstract MimeHeaders getMimeHeaders();

        int getStatus() {
            return 200;
        }
    }
}

