/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;

public class CallbackPoller
extends TimerTask {
    public static final long DEFAULT_POLL_PERIOD = 5000L;
    public static final String CALLBACK_POLL_PERIOD = "callbackPollPeriod";
    public static final String CALLBACK_SCHEDULE_MODE = "scheduleMode";
    public static final String SCHEDULE_FIXED_RATE = "scheduleFixedRate";
    public static final String SCHEDULE_FIXED_DELAY = "scheduleFixedDelay";
    public static final String REPORT_STATISTICS = "reportStatistics";
    private Client client = null;
    private InvokerCallbackHandler callbackHandler = null;
    private Map metadata = null;
    private Object callbackHandlerObject = null;
    private long pollPeriod = 5000L;
    private Timer timer;
    private String scheduleMode = "scheduleFixedRate";
    private boolean reportStatistics;
    private ArrayList toHandleList = new ArrayList();
    private ArrayList toAcknowledgeList = new ArrayList();
    private HandleThread handleThread;
    private AcknowledgeThread acknowledgeThread;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$callback$CallbackPoller == null ? (class$org$jboss$remoting$callback$CallbackPoller = CallbackPoller.class$("org.jboss.remoting.callback.CallbackPoller")) : class$org$jboss$remoting$callback$CallbackPoller));
    static /* synthetic */ Class class$org$jboss$remoting$callback$CallbackPoller;
    static /* synthetic */ Class class$java$lang$String;

    public CallbackPoller(Client client, InvokerCallbackHandler callbackhandler, Map metadata, Object callbackHandlerObject) {
        this.client = client;
        this.callbackHandler = callbackhandler;
        this.metadata = metadata;
        this.callbackHandlerObject = callbackHandlerObject;
    }

    public void start() throws Exception {
        if (this.callbackHandler == null) {
            throw new NullPointerException("Can not poll for callbacks when InvokerCallbackHandler is null.");
        }
        if (this.client == null) {
            throw new NullPointerException("Can not poll for callbacks when Client is null.");
        }
        this.client.connect();
        if (this.metadata != null) {
            Object val = this.metadata.get(CALLBACK_POLL_PERIOD);
            if (val != null) {
                if (val instanceof String) {
                    try {
                        this.pollPeriod = Long.parseLong((String)val);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Error converting callbackPollPeriod to type long.  " + e.getMessage()));
                    }
                } else {
                    log.warn((Object)("Value for callbackPollPeriod configuration must be of type " + (class$java$lang$String == null ? (class$java$lang$String = CallbackPoller.class$("java.lang.String")) : class$java$lang$String).getName() + " and is " + val.getClass().getName()));
                }
            }
            if ((val = this.metadata.get(CALLBACK_SCHEDULE_MODE)) != null) {
                if (val instanceof String) {
                    if (SCHEDULE_FIXED_DELAY.equals(val) || SCHEDULE_FIXED_RATE.equals(val)) {
                        this.scheduleMode = (String)val;
                    } else {
                        log.warn((Object)("Unrecognized value for scheduleMode: " + val));
                        log.warn((Object)("Using " + this.scheduleMode));
                    }
                } else {
                    log.warn((Object)("Value for scheduleMode must be of type " + (class$java$lang$String == null ? (class$java$lang$String = CallbackPoller.class$("java.lang.String")) : class$java$lang$String).getName() + " and is " + val.getClass().getName()));
                }
            }
            if (this.metadata.get(REPORT_STATISTICS) != null) {
                this.reportStatistics = true;
            }
        }
        this.handleThread = new HandleThread("HandleThread");
        this.handleThread.start();
        this.timer = new Timer(true);
        if (SCHEDULE_FIXED_DELAY.equals(this.scheduleMode)) {
            this.timer.schedule((TimerTask)this, this.pollPeriod, this.pollPeriod);
        } else {
            this.timer.scheduleAtFixedRate((TimerTask)this, this.pollPeriod, this.pollPeriod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        try {
            List callbacks = this.client.getCallbacks(this.callbackHandler);
            if (callbacks != null && callbacks.size() > 0) {
                ArrayList arrayList = this.toHandleList;
                synchronized (arrayList) {
                    this.toHandleList.addAll(callbacks);
                    if (this.toHandleList.size() == callbacks.size()) {
                        this.toHandleList.notify();
                    }
                }
            }
            if (this.reportStatistics) {
                this.reportStatistics(callbacks);
            }
        }
        catch (Throwable throwable) {
            log.error((Object)"Error getting callbacks from server.", throwable);
        }
    }

    public synchronized void stop() {
        log.debug((Object)(this + " is shutting down"));
        this.cancel();
        if (this.handleThread != null) {
            this.handleThread.shutdown();
            this.handleThread = null;
        }
        if (this.acknowledgeThread != null) {
            this.acknowledgeThread.shutdown();
            this.acknowledgeThread = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        log.debug((Object)(this + " has shut down"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForAcknowledgeRequest(Callback callback) {
        Object o;
        Object callbackId;
        Map returnPayload = callback.getReturnPayload();
        if (returnPayload != null && (callbackId = returnPayload.get("callbackId")) != null && ((o = returnPayload.get("remotingAcknowledgesPushCallbacks")) instanceof String && Boolean.valueOf((String)o).booleanValue() || o instanceof Boolean && ((Boolean)o).booleanValue())) {
            ArrayList arrayList = this.toAcknowledgeList;
            synchronized (arrayList) {
                this.toAcknowledgeList.add(callback);
                if (this.toAcknowledgeList.size() == 1) {
                    if (this.acknowledgeThread == null) {
                        this.acknowledgeThread = new AcknowledgeThread("AcknowledgeThread");
                        this.acknowledgeThread.start();
                    } else {
                        this.toAcknowledgeList.notify();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportStatistics(List callbacks) {
        int toHandle;
        int toAcknowledge = 0;
        ArrayList arrayList = this.toHandleList;
        synchronized (arrayList) {
            toHandle = this.toHandleList.size() + this.handleThread.toHandleListCopy.size();
        }
        arrayList = this.toAcknowledgeList;
        synchronized (arrayList) {
            if (this.acknowledgeThread != null) {
                toAcknowledge = this.toAcknowledgeList.size() + this.acknowledgeThread.toAcknowledgeListCopy.size();
            }
        }
        StringBuffer message = new StringBuffer("\n");
        message.append("================================\n").append("  retrieved " + callbacks.size() + " callbacks\n").append("  callbacks waiting to be processed: " + toHandle + "\n").append("  callbacks waiting to be acknowledged: " + toAcknowledge + "\n").append("================================");
        log.info((Object)message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Object access$200(CallbackPoller x0) {
        return x0.callbackHandlerObject;
    }

    static /* synthetic */ void access$400(CallbackPoller x0, Callback x1) {
        x0.checkForAcknowledgeRequest(x1);
    }

    class AcknowledgeThread
    extends Thread {
        boolean running = true;
        boolean done;
        ArrayList toAcknowledgeListCopy = new ArrayList();

        AcknowledgeThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                ArrayList arrayList = CallbackPoller.this.toAcknowledgeList;
                synchronized (arrayList) {
                    while (CallbackPoller.this.toAcknowledgeList.isEmpty() && this.running) {
                        try {
                            CallbackPoller.this.toAcknowledgeList.wait();
                        }
                        catch (InterruptedException e) {
                            log.warn((Object)"unexpected interrupt");
                        }
                    }
                    if (CallbackPoller.this.toAcknowledgeList.isEmpty()) {
                        this.done = true;
                        CallbackPoller.this.toAcknowledgeList.notify();
                        return;
                    }
                    this.toAcknowledgeListCopy.addAll(CallbackPoller.this.toAcknowledgeList);
                    CallbackPoller.this.toAcknowledgeList.clear();
                }
                try {
                    if (log.isTraceEnabled()) {
                        Iterator it = this.toAcknowledgeListCopy.iterator();
                        while (it.hasNext()) {
                            Callback cb = (Callback)it.next();
                            Map map = cb.getReturnPayload();
                            log.trace((Object)("acknowledging: " + map.get("callbackId")));
                        }
                    }
                    CallbackPoller.this.client.acknowledgeCallbacks(CallbackPoller.this.callbackHandler, this.toAcknowledgeListCopy);
                    this.toAcknowledgeListCopy.clear();
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)("Error acknowledging callback for callback handler (" + CallbackPoller.this.callbackHandler + ")."), t);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            log.debug((Object)(this + " is shutting down"));
            ArrayList arrayList = CallbackPoller.this.toAcknowledgeList;
            synchronized (arrayList) {
                this.running = false;
                CallbackPoller.this.toAcknowledgeList.notify();
                if (!this.done) {
                    try {
                        CallbackPoller.this.toAcknowledgeList.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return;
                }
            }
            log.debug((Object)(this + " has shut down"));
        }
    }

    class HandleThread
    extends Thread {
        boolean running = true;
        boolean done;
        ArrayList toHandleListCopy = new ArrayList();
        Callback callback;

        HandleThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block7: while (true) {
                var1_1 = CallbackPoller.access$000(CallbackPoller.this);
                synchronized (var1_1) {
                    if (CallbackPoller.access$000(CallbackPoller.this).isEmpty() && this.running) {
                        try {
                            CallbackPoller.access$000(CallbackPoller.this).wait();
                        }
                        catch (InterruptedException e) {
                            CallbackPoller.access$100().warn((Object)"unexpected interrupt");
                            continue;
                        }
                    }
                    if (CallbackPoller.access$000(CallbackPoller.this).isEmpty()) {
                        this.done = true;
                        CallbackPoller.access$000(CallbackPoller.this).notify();
                        return;
                    }
                    this.toHandleListCopy.addAll(CallbackPoller.access$000(CallbackPoller.this));
                    CallbackPoller.access$000(CallbackPoller.this).clear();
                }
                while (true) {
                    if (!this.toHandleListCopy.isEmpty()) ** break;
                    continue block7;
                    try {
                        this.callback = (Callback)this.toHandleListCopy.remove(0);
                        this.callback.setCallbackHandleObject(CallbackPoller.access$200(CallbackPoller.this));
                        CallbackPoller.access$300(CallbackPoller.this).handleCallback(this.callback);
                    }
                    catch (HandleCallbackException e) {
                        CallbackPoller.access$100().error((Object)("Error delivering callback to callback handler (" + CallbackPoller.access$300(CallbackPoller.this) + ")."), (Throwable)e);
                    }
                    CallbackPoller.access$400(CallbackPoller.this, this.callback);
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void shutdown() {
            log.debug((Object)(this + " is shutting down"));
            ArrayList arrayList = CallbackPoller.this.toHandleList;
            synchronized (arrayList) {
                this.running = false;
                CallbackPoller.this.toHandleList.notify();
                if (!this.done) {
                    try {
                        CallbackPoller.this.toHandleList.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return;
                }
            }
            log.debug((Object)(this + " has shut down"));
        }
    }
}

