/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl.template;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.drools.lang.dsl.template.NLMappingItem;

public class NLGrammar
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List mappings = new ArrayList();
    private static final Pattern itemPrefix = Pattern.compile("\\[\\s*(when|then)\\s*\\].*");
    private String description;

    public void addNLItem(NLMappingItem nLMappingItem) {
        this.mappings.add(nLMappingItem);
    }

    public List getMappings() {
        return this.mappings;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void removeMapping(NLMappingItem nLMappingItem) {
        this.mappings.remove(nLMappingItem);
    }

    public void load(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                while (string.endsWith("\\")) {
                    string = string.substring(0, string.length() - 1) + bufferedReader.readLine();
                }
                if ((string = string.trim()).startsWith("#")) {
                    this.description = string.substring(1);
                    continue;
                }
                if (string.equals("")) continue;
                this.mappings.add(this.parseLine(string));
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to read DSL configuration.");
        }
    }

    public void save(Writer writer) {
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        try {
            bufferedWriter.write("#" + this.description + "\n");
            Iterator iterator = this.mappings.iterator();
            while (iterator.hasNext()) {
                NLMappingItem nLMappingItem = (NLMappingItem)iterator.next();
                if (nLMappingItem.getScope().equals("*")) {
                    bufferedWriter.write(nLMappingItem.getNaturalTemplate() + "=" + nLMappingItem.getTargetTemplate() + "\n");
                    continue;
                }
                bufferedWriter.write("[" + nLMappingItem.getScope() + "]" + nLMappingItem.getNaturalTemplate() + "=" + nLMappingItem.getTargetTemplate() + "\n");
            }
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unable to save DSL configuration.");
        }
    }

    public List getMappings(String string) {
        ArrayList<NLMappingItem> arrayList = new ArrayList<NLMappingItem>();
        Iterator iterator = this.mappings.iterator();
        while (iterator.hasNext()) {
            NLMappingItem nLMappingItem = (NLMappingItem)iterator.next();
            if (!nLMappingItem.getScope().equals("*") && !nLMappingItem.getScope().equals(string)) continue;
            arrayList.add(nLMappingItem);
        }
        return arrayList;
    }

    public NLMappingItem parseLine(String string) {
        int n = string.indexOf("=");
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        Matcher matcher = itemPrefix.matcher(string2 = StringUtils.replace((String)string2, (String)"\\", (String)""));
        if (matcher.matches()) {
            String string4 = matcher.group(1);
            string2 = string2.substring(string2.indexOf("]") + 1).trim();
            return new NLMappingItem(string2, string3, string4);
        }
        return new NLMappingItem(string2, string3, "*");
    }

    public List validateMapping(NLMappingItem nLMappingItem) {
        List list = nLMappingItem.validateTokenUsage();
        list.addAll(nLMappingItem.validateUnmatchingBraces());
        return list;
    }
}

