/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.MessageBody;
import com.meterware.httpunit.MessageBodyWebRequest;
import com.meterware.httpunit.MimeEncodedMessageBody;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.URLEncodedMessageBody;
import com.meterware.httpunit.URLEncodedString;
import com.meterware.httpunit.WebForm;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class PostMethodWebRequest
extends MessageBodyWebRequest {
    private MessageBody _body;

    public PostMethodWebRequest(String urlString) {
        super(urlString);
    }

    public PostMethodWebRequest(String urlString, InputStream source, String contentType) {
        super(urlString);
        this._body = new MessageBodyWebRequest.InputStreamMessageBody(this, source, contentType);
    }

    public PostMethodWebRequest(URL urlBase, String urlString, String target) {
        super(urlBase, urlString, target);
    }

    public void setMimeEncoded(boolean mimeEncoded) {
        super.setMimeEncoded(mimeEncoded);
    }

    public String getMethod() {
        return "POST";
    }

    public String getQueryString() {
        try {
            URLEncodedString encoder = new URLEncodedString();
            this.getParameterHolder().recordPredefinedParameters(encoder);
            return encoder.getString();
        }
        catch (IOException e) {
            throw new RuntimeException("Programming error: " + e);
        }
    }

    protected boolean maySelectFile(String parameterName) {
        return this.isMimeEncoded() && this.isFileParameter(parameterName);
    }

    protected MessageBody getMessageBody() {
        if (this._body == null) {
            this._body = this.isMimeEncoded() ? new MimeEncodedMessageBody(this) : new URLEncodedMessageBody(this);
        }
        return this._body;
    }

    PostMethodWebRequest(WebForm sourceForm, SubmitButton button, int x, int y) {
        super(sourceForm, button, x, y);
    }
}

