/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import java.io.ByteArrayOutputStream;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.binding.BindingException;
import org.jboss.ws.core.jaxrpc.binding.SerializationContext;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.utils.DOMWriter;
import org.jboss.ws.core.utils.XMLPredefinedEntityReferenceResolver;
import org.w3c.dom.Node;

public abstract class DeserializerSupport
implements Deserializer {
    private static final Logger log = Logger.getLogger(DeserializerSupport.class);

    public Object deserialize(SOAPContentElement soapElement, SerializationContext serContext) throws BindingException {
        QName xmlName = soapElement.getElementQName();
        QName xmlType = soapElement.getXmlType();
        Source source = soapElement.getXMLFragment().getSource();
        return this.deserialize(xmlName, xmlType, source, serContext);
    }

    public abstract Object deserialize(QName var1, QName var2, Source var3, SerializationContext var4) throws BindingException;

    protected static String sourceToString(Source source) {
        String xmlFragment = null;
        try {
            if (source instanceof DOMSource) {
                Node node = ((DOMSource)source).getNode();
                xmlFragment = DOMWriter.printNode(node, false);
            } else {
                TransformerFactory tf = TransformerFactory.newInstance();
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                StreamResult streamResult = new StreamResult(baos);
                tf.newTransformer().transform(source, streamResult);
                xmlFragment = new String(baos.toByteArray());
                if (xmlFragment.startsWith("<?xml")) {
                    int index = xmlFragment.indexOf(">");
                    xmlFragment = xmlFragment.substring(index + 1);
                }
            }
        }
        catch (TransformerException e) {
            WSException.rethrow(e);
        }
        return xmlFragment;
    }

    protected String unwrapValueStr(String xmlFragment) {
        if (this.isEmptyElement(xmlFragment)) {
            return this.isNil(xmlFragment) ? null : "";
        }
        int endOfStartTag = xmlFragment.indexOf(">");
        int startOfEndTag = xmlFragment.lastIndexOf("</");
        if (endOfStartTag < 0 || startOfEndTag < 0) {
            throw new IllegalArgumentException("Invalid XML fragment: " + xmlFragment);
        }
        String valueStr = xmlFragment.substring(endOfStartTag + 1, startOfEndTag);
        return XMLPredefinedEntityReferenceResolver.resolve(valueStr);
    }

    protected boolean isEmptyElement(String xmlFragment) {
        return xmlFragment.startsWith("<") && xmlFragment.endsWith("/>");
    }

    protected boolean isNil(String xmlFragment) {
        boolean isNil = false;
        if (this.isEmptyElement(xmlFragment)) {
            int endOfStartTag = xmlFragment.indexOf(">");
            String startTag = xmlFragment.substring(0, endOfStartTag);
            isNil = startTag.indexOf(":nil='1'") > 0 || startTag.indexOf(":nil=\"1\"") > 0;
            isNil = isNil || startTag.indexOf(":nil='true'") > 0 || startTag.indexOf(":nil=\"true\"") > 0;
        }
        return isNil;
    }

    public String getMechanismType() {
        throw new NotImplementedException();
    }
}

