/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.engine.bufferedengine.buffer;

import com.octo.captcha.Captcha;
import com.octo.captcha.CaptchaException;
import com.octo.captcha.engine.bufferedengine.buffer.CaptchaBuffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiskCaptchaBuffer
implements CaptchaBuffer {
    private static final Log log = LogFactory.getLog((String)(class$com$octo$captcha$engine$bufferedengine$buffer$DiskCaptchaBuffer == null ? (class$com$octo$captcha$engine$bufferedengine$buffer$DiskCaptchaBuffer = DiskCaptchaBuffer.class$("com.octo.captcha.engine.bufferedengine.buffer.DiskCaptchaBuffer")) : class$com$octo$captcha$engine$bufferedengine$buffer$DiskCaptchaBuffer).getName());
    private RandomAccessFile randomAccessFile;
    private HashedMap diskElements = null;
    private ArrayList freeSpace;
    private boolean persistant = false;
    private final String name;
    private File dataFile;
    private File indexFile;
    private boolean isInitalized = false;
    private long totalSize;
    private int maxDataSize;
    private boolean isDisposed = false;
    static /* synthetic */ Class class$com$octo$captcha$engine$bufferedengine$buffer$DiskCaptchaBuffer;

    public DiskCaptchaBuffer(String fileName, boolean persistant) {
        log.debug((Object)"Creating new Diskbuffer");
        this.freeSpace = new ArrayList();
        this.name = fileName;
        this.persistant = persistant;
        try {
            this.initialiseFiles();
        }
        catch (Exception e) {
            log.debug((Object)("Error while initialising files " + e));
        }
    }

    private final void initialiseFiles() throws Exception {
        this.dataFile = new File(this.name + ".data");
        this.indexFile = new File(this.name + ".index");
        this.readIndex();
        if (this.diskElements == null || !this.persistant) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Index file dirty or empty. Deleting data file " + this.getDataFileName()));
            }
            this.dataFile.delete();
            this.diskElements = new HashedMap();
        }
        this.randomAccessFile = new RandomAccessFile(this.dataFile, "rw");
        this.isInitalized = true;
        log.info((Object)"Buffer initialized");
    }

    protected synchronized Collection remove(int number, Locale locale) throws IOException {
        if (!this.isInitalized) {
            return new ArrayList(0);
        }
        DiskElement diskElement = null;
        int index = 0;
        boolean diskEmpty = false;
        UnboundedFifoBuffer collection = new UnboundedFifoBuffer();
        if (!this.diskElements.containsKey((Object)locale)) {
            return collection;
        }
        try {
            while (!diskEmpty && index < number) {
                try {
                    diskElement = (DiskElement)((LinkedList)this.diskElements.get((Object)locale)).removeFirst();
                    this.randomAccessFile.seek(diskElement.position);
                    byte[] buffer = new byte[diskElement.payloadSize];
                    this.randomAccessFile.readFully(buffer);
                    ByteArrayInputStream instr = new ByteArrayInputStream(buffer);
                    ObjectInputStream objstr = new ObjectInputStream(instr);
                    collection.add(objstr.readObject());
                    instr.close();
                    objstr.close();
                    this.freeBlock(diskElement);
                    ++index;
                }
                catch (NoSuchElementException e) {
                    diskEmpty = true;
                    log.debug((Object)("disk is empty for locale : " + locale.toString()));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while reading on disk ", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("removed  " + collection.size() + " from disk buffer with locale " + locale.toString()));
        }
        return collection;
    }

    protected synchronized void store(Collection collection, Locale locale) throws IOException {
        if (!this.isInitalized) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            ByteArrayOutputStream outstr = new ByteArrayOutputStream();
            ObjectOutputStream objstr = new ObjectOutputStream(outstr);
            objstr.writeObject(element);
            objstr.close();
            byte[] buffer = outstr.toByteArray();
            this.store(element, locale);
        }
    }

    protected synchronized void store(Object element, Locale locale) throws IOException {
        if (!this.isInitalized) {
            return;
        }
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        ObjectOutputStream objstr = new ObjectOutputStream(outstr);
        objstr.writeObject(element);
        objstr.close();
        byte[] buffer = outstr.toByteArray();
        DiskElement diskElement = this.findFreeBlock(buffer.length);
        if (diskElement == null) {
            diskElement = new DiskElement();
            diskElement.position = this.randomAccessFile.length();
            diskElement.blockSize = buffer.length;
        }
        this.randomAccessFile.seek(diskElement.position);
        this.randomAccessFile.write(buffer);
        diskElement.payloadSize = buffer.length;
        this.totalSize += (long)buffer.length;
        if (!this.diskElements.containsKey((Object)locale)) {
            this.diskElements.put((Object)locale, new LinkedList());
        }
        ((LinkedList)this.diskElements.get((Object)locale)).addLast(diskElement);
        if (log.isDebugEnabled()) {
            long menUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            log.debug((Object)("Store " + locale.toString() + " on object, total size : " + this.size() + " Total unsed elements : " + this.freeSpace.size() + " memory used " + menUsed));
        }
    }

    private void freeBlock(DiskElement element) {
        this.totalSize -= (long)element.payloadSize;
        element.payloadSize = 0;
        this.freeSpace.add(element);
    }

    public synchronized void clearFile() throws IOException {
        try {
            this.diskElements.clear();
            this.freeSpace.clear();
            this.totalSize = 0L;
            this.randomAccessFile.setLength(0L);
            this.indexFile.delete();
            this.indexFile.createNewFile();
        }
        catch (Exception e) {
            log.error((Object)" Cache: Could not rebuild disk store", (Throwable)e);
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        this.isDisposed = true;
        try {
            this.writeIndex();
            this.diskElements.clear();
            this.freeSpace.clear();
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Cache: Could not shut down disk cache", (Throwable)e);
        }
        finally {
            this.randomAccessFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void writeIndex() throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            FileOutputStream fout = new FileOutputStream(this.indexFile);
            objectOutputStream = new ObjectOutputStream(fout);
            objectOutputStream.writeObject(this.diskElements);
            objectOutputStream.writeObject(this.freeSpace);
            Object var4_3 = null;
            if (objectOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (objectOutputStream == null) throw throwable;
            objectOutputStream.flush();
            objectOutputStream.close();
            throw throwable;
        }
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized void readIndex() throws IOException {
        block27: {
            block28: {
                ObjectInputStream objectInputStream = null;
                FileInputStream fin = null;
                if (!this.indexFile.exists() || !this.persistant) break block28;
                fin = new FileInputStream(this.indexFile);
                objectInputStream = new ObjectInputStream(fin);
                this.diskElements = (HashedMap)objectInputStream.readObject();
                this.freeSpace = (ArrayList)objectInputStream.readObject();
                Object var5_3 = null;
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    } else if (fin != null) {
                        fin.close();
                    }
                    break block27;
                }
                catch (IOException e2) {
                    log.error((Object)"Problem closing the index file.");
                }
                break block27;
                {
                    catch (StreamCorruptedException e) {
                        log.error((Object)"Corrupt index file. Creating new index.");
                        this.createNewIndexFile();
                        Object var5_4 = null;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            } else if (fin != null) {
                                fin.close();
                            }
                            break block27;
                        }
                        catch (IOException e2) {
                            log.error((Object)"Problem closing the index file.");
                        }
                        break block27;
                    }
                    catch (IOException e) {
                        log.error((Object)"IOException reading index. Creating new index. ");
                        this.createNewIndexFile();
                        Object var5_5 = null;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            } else if (fin != null) {
                                fin.close();
                            }
                            break block27;
                        }
                        catch (IOException e2) {
                            log.error((Object)"Problem closing the index file.");
                        }
                        break block27;
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)"Class loading problem reading index. Creating new index. ", (Throwable)e);
                        this.createNewIndexFile();
                        Object var5_6 = null;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            } else if (fin != null) {
                                fin.close();
                            }
                            break block27;
                        }
                        catch (IOException e2) {
                            log.error((Object)"Problem closing the index file.");
                        }
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        } else if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (IOException e2) {
                        log.error((Object)"Problem closing the index file.");
                    }
                    throw throwable;
                }
            }
            this.createNewIndexFile();
        }
    }

    private void createNewIndexFile() throws IOException {
        if (this.indexFile.exists()) {
            this.indexFile.delete();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Index file " + this.indexFile + " deleted."));
            }
        }
        if (this.indexFile.createNewFile()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Index file " + this.indexFile + " created successfully"));
            }
        } else {
            throw new IOException("Index file " + this.indexFile + " could not created.");
        }
    }

    private DiskElement findFreeBlock(int length) {
        for (int i = 0; i < this.freeSpace.size(); ++i) {
            DiskElement element = (DiskElement)this.freeSpace.get(i);
            if (element.blockSize < length) continue;
            this.freeSpace.remove(i);
            return element;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ dataFile = ").append(this.dataFile.getAbsolutePath()).append(", totalSize=").append(this.totalSize).append(", status=").append(this.isInitalized).append(" ]");
        return sb.toString();
    }

    public long getTotalFileSize() {
        return this.getDataFileSize() + this.getIndexFileSize();
    }

    public long getDataFileSize() {
        return this.dataFile.length();
    }

    public float calculateDataFileSparseness() {
        return 1.0f - (float)this.getUsedDataSize() / (float)this.getDataFileSize();
    }

    public long getUsedDataSize() {
        return this.totalSize;
    }

    public long getIndexFileSize() {
        if (this.indexFile == null) {
            return 0L;
        }
        return this.indexFile.length();
    }

    public String getDataFileName() {
        return this.name + ".data";
    }

    public String getIndexFileName() {
        return this.name + ".index";
    }

    public Captcha removeCaptcha() throws NoSuchElementException {
        if (this.isDisposed) {
            return null;
        }
        return this.removeCaptcha(Locale.getDefault());
    }

    public Collection removeCaptcha(int number) {
        if (this.isDisposed) {
            return null;
        }
        log.debug((Object)"Entering removeCaptcha(int number) ");
        Collection c = null;
        try {
            c = this.remove(number, Locale.getDefault());
        }
        catch (IOException e) {
            throw new CaptchaException(e);
        }
        return c;
    }

    public void putCaptcha(Captcha captcha) {
        log.debug((Object)"Entering putCaptcha(Captcha captcha)");
        this.putCaptcha(captcha, Locale.getDefault());
    }

    public void putAllCaptcha(Collection captchas) {
        log.debug((Object)"Entering putAllCaptcha()");
        this.putAllCaptcha(captchas, Locale.getDefault());
    }

    public int size() {
        if (!this.isInitalized) {
            return 0;
        }
        int total = 0;
        MapIterator it = this.diskElements.mapIterator();
        while (it.hasNext()) {
            it.next();
            total += ((LinkedList)it.getValue()).size();
        }
        return total;
    }

    public int maxSize() {
        return this.maxDataSize;
    }

    public Captcha removeCaptcha(Locale locale) throws NoSuchElementException {
        log.debug((Object)"entering removeCaptcha(Locale locale)");
        Collection captchas = null;
        try {
            captchas = this.remove(1, locale);
        }
        catch (IOException e) {
            throw new CaptchaException(e);
        }
        if (captchas.size() == 0) {
            throw new NoSuchElementException();
        }
        return (Captcha)captchas.toArray()[0];
    }

    public Collection removeCaptcha(int number, Locale locale) {
        if (this.isDisposed) {
            return null;
        }
        try {
            return this.remove(number, locale);
        }
        catch (IOException e) {
            throw new CaptchaException(e);
        }
    }

    public void putCaptcha(Captcha captcha, Locale locale) {
        if (this.isDisposed) {
            return;
        }
        try {
            this.store(captcha, locale);
        }
        catch (IOException e) {
            throw new CaptchaException(e);
        }
    }

    public void putAllCaptcha(Collection captchas, Locale locale) {
        if (this.isDisposed) {
            return;
        }
        try {
            this.store(captchas, locale);
            log.debug((Object)("trying to store " + captchas.size()));
        }
        catch (IOException e) {
            throw new CaptchaException(e);
        }
    }

    public int size(Locale locale) {
        if (!this.isInitalized || this.isDisposed) {
            return 0;
        }
        return ((LinkedList)this.diskElements.get((Object)locale)).size();
    }

    public void clear() {
        try {
            this.clearFile();
        }
        catch (IOException e) {
            throw new CaptchaException(e);
        }
    }

    public Collection getLocales() {
        if (this.isDisposed) {
            return null;
        }
        return this.diskElements.keySet();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DiskElement
    implements Serializable {
        private long position;
        private int payloadSize;
        private int blockSize;
        private long expiryTime;

        private DiskElement() {
        }
    }
}

