/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.coordinator;

import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
import com.arjuna.ats.arjuna.logging.tsLogger;

public class ReaperThread
extends Thread {
    private TransactionReaper reaperObject;
    private long sleepPeriod;
    private boolean _shutdown;

    public ReaperThread(TransactionReaper arg) {
        this.reaperObject = arg;
        this.sleepPeriod = this.reaperObject.checkingPeriod();
        this._shutdown = false;
    }

    public void run() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "ReaperThread.run ()");
        }
        while (true) {
            boolean done = false;
            while (!done) {
                long oldPeriod = this.sleepPeriod = this.reaperObject.checkingPeriod();
                long beforeTime = System.currentTimeMillis();
                try {
                    if (tsLogger.arjLoggerI18N.debugAllowed()) {
                        tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_1", new Object[]{Thread.currentThread(), Long.toString(this.sleepPeriod)});
                    }
                    Thread.sleep(this.sleepPeriod);
                    done = true;
                }
                catch (InterruptedException e1) {
                    if (this.reaperObject.checkingPeriod() != oldPeriod) {
                        done = true;
                        continue;
                    }
                    long afterTime = System.currentTimeMillis();
                    if (afterTime - beforeTime >= this.reaperObject.checkingPeriod()) continue;
                    done = true;
                }
                catch (Exception e2) {
                    done = true;
                }
            }
            if (this._shutdown) {
                return;
            }
            this.reaperObject.check(System.currentTimeMillis());
            if (this.reaperObject.numberOfTransactions() != 0L) continue;
            this.sleepPeriod = Long.MAX_VALUE;
        }
    }

    public void shutdown() {
        this._shutdown = true;
    }
}

