/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts;

import com.arjuna.ats.internal.jta.transaction.jts.TransactionImple;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jts.OTSManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Unavailable;

public class BaseTransaction {
    private static boolean _supportSubtransactions = false;

    public void begin() throws NotSupportedException, javax.transaction.SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.begin");
        }
        if (!_supportSubtransactions) {
            try {
                this.checkTransactionState();
            }
            catch (IllegalStateException e1) {
                throw new NotSupportedException();
            }
            catch (SystemException e2) {
                throw new javax.transaction.SystemException(e2.toString());
            }
        }
        try {
            TransactionImple.putTransaction(new TransactionImple());
        }
        catch (SubtransactionsUnavailable e3) {
            throw new NotSupportedException();
        }
        catch (SystemException e4) {
            throw new javax.transaction.SystemException(e4.toString());
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, javax.transaction.SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.commit");
        }
        TransactionImple theTransaction = TransactionImple.getTransaction();
        try {
            theTransaction.commitAndDisassociate();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            throw new IllegalStateException("BaseTransaction.commit - " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.notxe") + ex);
        }
        this.checkTransactionState();
    }

    public void rollback() throws IllegalStateException, SecurityException, javax.transaction.SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.rollback");
        }
        TransactionImple theTransaction = TransactionImple.getTransaction();
        try {
            theTransaction.rollbackAndDisassociate();
        }
        catch (NullPointerException ex) {
            throw new IllegalStateException();
        }
        this.checkTransactionState();
    }

    public void setRollbackOnly() throws IllegalStateException, javax.transaction.SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.setRollbackOnly");
        }
        TransactionImple theTransaction = TransactionImple.getTransaction();
        try {
            theTransaction.setRollbackOnly();
        }
        catch (NullPointerException ex) {
            throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.nosuchtx"));
        }
    }

    public int getStatus() throws javax.transaction.SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.getStatus");
        }
        TransactionImple theTransaction = TransactionImple.getTransaction();
        try {
            return theTransaction.getStatus();
        }
        catch (NullPointerException ex) {
            return 6;
        }
        catch (Exception e) {
            throw new javax.transaction.SystemException(e.toString());
        }
    }

    public void setTransactionTimeout(int seconds) throws javax.transaction.SystemException {
        try {
            OTSImpleManager.current().set_timeout(seconds);
        }
        catch (Exception e) {
            throw new javax.transaction.SystemException(e.toString());
        }
    }

    public int getTimeout() throws javax.transaction.SystemException {
        try {
            return OTSImpleManager.current().get_timeout();
        }
        catch (Exception e) {
            throw new javax.transaction.SystemException(e.toString());
        }
    }

    protected BaseTransaction() {
    }

    final void checkTransactionState() throws IllegalStateException, javax.transaction.SystemException {
        try {
            Control cont = OTSManager.get_current().get_control();
            if (cont != null) {
                Coordinator coord = cont.get_coordinator();
                if (coord != null && coord.get_status() == Status.StatusActive && !_supportSubtransactions) {
                    throw new IllegalStateException("BaseTransaction.checkTransactionState - " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.alreadyassociated"));
                }
                cont = null;
            }
        }
        catch (SystemException e1) {
            throw new javax.transaction.SystemException(e1.toString());
        }
        catch (Unavailable e2) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    static {
        String subtran = jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.supportSubtransactions");
        if (subtran != null && subtran.equals("YES")) {
            _supportSubtransactions = true;
        }
    }
}

