/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class EchoProperties
extends Task {
    private File destfile = null;
    private boolean failonerror = true;
    private String prefix = null;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$lang$String;

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void execute() throws BuildException {
        Hashtable allProps = this.project.getProperties();
        try {
            if (this.destfile == null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.saveProperties(allProps, baos);
                this.log(baos.toString(), 2);
            } else {
                FileOutputStream os = new FileOutputStream(this.destfile);
                this.saveProperties(allProps, os);
            }
        }
        catch (IOException ioe) {
            String message = "Destfile " + this.destfile + " could not be written to.";
            if (this.failonerror) {
                throw new BuildException(message, (Throwable)ioe, this.location);
            }
            this.log(message, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveProperties(Hashtable allProps, OutputStream os) throws IOException, BuildException {
        Properties props = new Properties();
        Enumeration enumeration = allProps.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = (String)allProps.get(name);
            if (this.prefix != null && name.indexOf(this.prefix) != 0) continue;
            props.put(name, value);
        }
        try {
            this.jdkSaveProperties(props, os, "Ant properties");
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            os.close();
            throw throwable;
        }
        os.close();
    }

    protected void jdkSaveProperties(Properties props, OutputStream os, String header) throws IOException {
        try {
            Method m = props.getClass().getMethod("store", class$java$io$OutputStream == null ? (class$java$io$OutputStream = EchoProperties.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$java$lang$String == null ? (class$java$lang$String = EchoProperties.class$("java.lang.String")) : class$java$lang$String);
            m.invoke((Object)props, os, header);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            this.jdk10SaveProperties(props, os, header);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            this.jdk10SaveProperties(props, os, header);
        }
    }

    protected void jdk10SaveProperties(Properties props, OutputStream os, String header) {
        props.save(os, header);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

