/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.context.effects.LocalEffectEncoder;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.w3c.dom.Element;

public class CheckboxRenderer
extends DomBasicInputRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        String componentClientId;
        this.validateParameters(facesContext, uiComponent, null);
        if (CheckboxRenderer.isStatic(uiComponent)) {
            return;
        }
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String decodedValue = (String)requestParameterMap.get(componentClientId = uiComponent.getClientId(facesContext));
        if (decodedValue == null) {
            decodedValue = "false";
        } else if (decodedValue.equalsIgnoreCase("on") || decodedValue.equalsIgnoreCase("yes") || decodedValue.equalsIgnoreCase("true")) {
            decodedValue = "true";
        }
        ((EditableValueHolder)uiComponent).setSubmittedValue((Object)decodedValue);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        Element input = null;
        if (!domContext.isInitialized()) {
            if (uiComponent.getChildCount() > 0) {
                Element root = domContext.createRootElement("span");
                root.setAttribute("id", clientId + "span");
                root.setAttribute("style", "float:left");
                input = domContext.createElement("input");
                root.appendChild(input);
            } else {
                input = domContext.createRootElement("input");
            }
            input.setAttribute("type", "checkbox");
            input.setAttribute("id", clientId);
            input.setAttribute("name", clientId);
        }
        input = uiComponent.getChildCount() > 0 ? (Element)domContext.getRootNode().getFirstChild() : (Element)domContext.getRootNode();
        String currentValue = this.getValue(facesContext, uiComponent);
        if (currentValue != null && currentValue.equalsIgnoreCase("true")) {
            input.setAttribute("checked", "checked");
        } else {
            input.removeAttribute("checked");
        }
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        if (styleClass != null) {
            input.setAttribute("class", styleClass);
        }
        JavascriptContext.fireEffect(uiComponent, facesContext);
        LocalEffectEncoder.encodeLocalEffects(uiComponent, input, facesContext);
        this.renderPassThruAttributes(uiComponent, input);
        HashSet excludes = new HashSet();
        this.addJavaScript(facesContext, uiComponent, input, excludes);
    }

    public void renderPassThruAttributes(UIComponent uiComponent, Element input) {
        Iterator passTrhuAttributes = PassThruAttributeRenderer.getpassThruAttributeNames().iterator();
        while (passTrhuAttributes.hasNext()) {
            String attribute = passTrhuAttributes.next().toString();
            CheckboxRenderer.renderAttribute(uiComponent, input, attribute, attribute);
        }
        CheckboxRenderer.renderAttribute(uiComponent, input, "disabled", "disabled");
        String original = (String)uiComponent.getAttributes().get("onfocus");
        String onfocus = "setFocus(this.id);";
        if (original == null) {
            original = "";
        }
        input.setAttribute("onfocus", onfocus + original);
        original = (String)uiComponent.getAttributes().get("onblur");
        String onblur = "setFocus('');";
        if (original == null) {
            original = "";
        }
        input.setAttribute("onblur", onblur + original);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        Iterator children = uiComponent.getChildren().iterator();
        domContext.setCursorParent(domContext.getRootNode());
        while (children.hasNext()) {
            UIComponent nextChild = (UIComponent)children.next();
            if (!nextChild.isRendered()) continue;
            CheckboxRenderer.encodeParentAndChildren(facesContext, nextChild);
        }
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        if (!(submittedValue instanceof String)) {
            throw new ConverterException("Expecting submittedValue to be String");
        }
        return Boolean.valueOf((String)submittedValue);
    }

    protected void addJavaScript(FacesContext facesContext, UIComponent uiComponent, Element root, Set excludes) {
    }
}

