/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.selector;

import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.jtests.jms.framework.PTPTestCase;

public class SelectorSyntaxTest
extends PTPTestCase {
    static /* synthetic */ Class class$org$objectweb$jtests$jms$conform$selector$SelectorSyntaxTest;

    public void testValidIdentifiersStart() {
        String identifier = null;
        try {
            identifier = "_correct";
            SelectorSyntaxTest.assertTrue((String)(identifier + " starts with an invalid Java identifier start character"), (boolean)Character.isJavaIdentifierStart(identifier.charAt(0)));
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, identifier + " IS NULL");
            identifier = "$correct";
            SelectorSyntaxTest.assertTrue((String)(identifier + " starts with an invalid Java identifier start character"), (boolean)Character.isJavaIdentifierStart(identifier.charAt(0)));
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, identifier + " IS NULL");
        }
        catch (JMSException e) {
            SelectorSyntaxTest.fail((String)(identifier + " is a correct identifier. \n" + (Object)((Object)e)));
        }
    }

    public void testInvalidIdentifiersStart() {
        String identifier = null;
        try {
            identifier = "1uncorrect";
            SelectorSyntaxTest.assertTrue((String)(identifier + " starts with an invalid Java identifier start character"), (!Character.isJavaIdentifierStart(identifier.charAt(0)) ? 1 : 0) != 0);
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, identifier + " IS NULL");
            SelectorSyntaxTest.fail((String)(identifier + " starts with an invalid Java identifier start character"));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            identifier = "%uncorrect";
            SelectorSyntaxTest.assertTrue((String)(identifier + " starts with an invalid Java identifier start character"), (!Character.isJavaIdentifierStart(identifier.charAt(0)) ? 1 : 0) != 0);
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, identifier + " IS NULL");
            SelectorSyntaxTest.fail((String)(identifier + " starts with an invalid Java identifier start character"));
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testEmptyStringAsSelector() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "");
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testIdentifierNULL() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "NULL = ZERO");
            SelectorSyntaxTest.fail((String)"NULL is not a valid identifier");
        }
        catch (InvalidSelectorException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testIdentifierTRUE() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "TRUE > 0");
            SelectorSyntaxTest.fail((String)"TRUE is not a valid identifier");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testIdentifierFALSE() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "FALSE > 0");
            SelectorSyntaxTest.fail((String)"FALSE is not a valid identifier");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testIdentifierNOT() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "NOT > 0");
            SelectorSyntaxTest.fail((String)"NOT is not a valid identifier");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testIdentifierAND() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "AND > 0");
            SelectorSyntaxTest.fail((String)"AND is not a valid identifier");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testIdentifierOR() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "OR > 0");
            SelectorSyntaxTest.fail((String)"OR is not a valid identifier");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testIdentifierBETWEEN() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "BETWEEN > 0");
            SelectorSyntaxTest.fail((String)"BETWEEN is not a valid identifier");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testIdentifierLIKE() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "LIKE > 0");
            SelectorSyntaxTest.fail((String)"LIKE is not a valid identifier");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testIdentifierIN() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "IN > 0");
            SelectorSyntaxTest.fail((String)"IN is not a valid identifier");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testIdentifierIS() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "IS > 0");
            SelectorSyntaxTest.fail((String)"IS is not a valid identifier");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testIdentifierESCAPE() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "ESCAPE > 0");
            SelectorSyntaxTest.fail((String)"ESCAPE is not a valid identifier");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testNull() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "prop_name IS NULL");
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "prop_name IS NOT NULL");
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLike() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "phone LIKE '12%3'");
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "word LIKE 'l_se'");
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "underscored LIKE '\\_%' ESCAPE '\\'");
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "phone NOT LIKE '12%3'");
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testIn() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "Country IN ('UK', 'US', 'France')");
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "Country NOT IN ('UK', 'US', 'France')");
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBetween() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "age BETWEEN 15 and 19");
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "age NOT BETWEEN 15 and 19");
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testApproximateNumericLiteral() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "average = +6.2");
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "average = -95.7");
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "average = 7.");
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testExactNumericLiteral() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "average = +62");
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "max = -957");
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "max = 57");
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testZero() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "max = 0");
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "max = 0.0");
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "max = 0.");
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString() {
        try {
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "string = 'literal'");
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "string = 'literal''s'");
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$objectweb$jtests$jms$conform$selector$SelectorSyntaxTest == null ? (class$org$objectweb$jtests$jms$conform$selector$SelectorSyntaxTest = SelectorSyntaxTest.class$("org.objectweb.jtests.jms.conform.selector.SelectorSyntaxTest")) : class$org$objectweb$jtests$jms$conform$selector$SelectorSyntaxTest);
    }

    public SelectorSyntaxTest(String name) {
        super(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

