package com.sun.facelets.compiler;

import com.sun.facelets.tag.Tag;

/**
 * @author Mark Collette
 */

public abstract class TagCompilationUnit extends CompilationUnit {
    protected String alias;

    public TagCompilationUnit(String alias) {
        super();
        this.alias = alias;
    }

    public abstract void startTag(Tag tag);

    public abstract void endTag();

    public abstract boolean isClosed();

    /**
     * After a tag has been closed, can this
     *  TagCompilationUnit be reused, or must
     *  a new one be constructed
     *
     * @return If is reusable
     */
    public abstract boolean isReusable();
}
