/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ParserUtil {
    static /* synthetic */ Class class$java$awt$Color;

    public static int parseInt(String string, String string2) throws SAXException {
        if (string == null) {
            throw new SAXException(string2);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("NumberFormatError: " + string2);
        }
    }

    public static int parseInt(String string, int n) {
        if (string == null) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static float parseFloat(String string, String string2) throws SAXException {
        if (string == null) {
            throw new SAXException(string2);
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("NumberFormatError: " + string2);
        }
    }

    public static float parseFloat(String string, float f) {
        if (string == null) {
            return f;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public static boolean parseBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        return string.equalsIgnoreCase("true");
    }

    public static String parseString(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string;
    }

    public static Stroke parseStroke(String string) {
        try {
            if (string != null) {
                Float f = new Float(string);
                return new BasicStroke(f.floatValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new BasicStroke(1.0f);
    }

    public static Color parseColor(String string) {
        return ParserUtil.parseColor(string, Color.black);
    }

    public static Color parseColor(String string, Color color) {
        if (string == null) {
            return color;
        }
        try {
            return Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Field field = (class$java$awt$Color == null ? (class$java$awt$Color = ParserUtil.class$("java.awt.Color")) : class$java$awt$Color).getField(string);
                return (Color)field.get(null);
            }
            catch (Exception exception) {
                return color;
            }
        }
    }

    public static float parseRelativeFloat(String string, String string2) throws SAXException {
        if (string == null) {
            throw new SAXException(string2);
        }
        String string3 = string.trim();
        if (string3.endsWith("%")) {
            String string4 = string3.substring(0, string3.indexOf("%"));
            float f = ParserUtil.parseFloat(string4, string2) * -1.0f;
            return f;
        }
        return ParserUtil.parseFloat(string3, string2);
    }

    public static Rectangle2D getElementPosition(Attributes attributes) throws SAXException {
        float f = ParserUtil.parseRelativeFloat(attributes.getValue("x"), "Element x not specified");
        float f2 = ParserUtil.parseRelativeFloat(attributes.getValue("y"), "Element y not specified");
        float f3 = ParserUtil.parseRelativeFloat(attributes.getValue("width"), "Element width not specified");
        float f4 = ParserUtil.parseRelativeFloat(attributes.getValue("height"), "Element height not specified");
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3, f4);
        return float_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

