/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.BaseAST;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.Node;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ArrayInitializerPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new ArrayInitializerPrinter();

    protected ArrayInitializerPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        AST child;
        int maxElementsPerLine = settings.getInt(ConventionKeys.LINE_WRAP_ARRAY_ELEMENTS, 0);
        boolean wrapAsNeeded = maxElementsPerLine == 0;
        int lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        boolean bracesPadding = settings.getBoolean(ConventionKeys.PADDING_BRACES, true);
        boolean spaceAfterComma = settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        int numElements = 0;
        int last = out.last;
        boolean multiArray = this.hasArrayChild(node);
        if (multiArray) {
            maxElementsPerLine = 1;
            wrapAsNeeded = false;
        }
        if (this.isFirstOfMultiArray((JavaNode)node)) {
            if (!out.newline) {
                out.printNewline();
            }
            this.printIndentation(out);
        }
        JavaNode firstElement = (JavaNode)node.getFirstChild();
        if (maxElementsPerLine != Integer.MAX_VALUE && out.mode == 1) {
            TestNodeWriter tester = out.testers.get();
            child = firstElement;
            while (child != null) {
                switch (child.getType()) {
                    case 82: {
                        break;
                    }
                    default: {
                        ++numElements;
                    }
                }
                PrinterFactory.create(child).print(child, tester);
                if (wrapAsNeeded && tester.length > lineLength) break;
                child = child.getNextSibling();
            }
            if (!(numElements <= maxElementsPerLine || wrapAsNeeded && out.column + tester.length <= lineLength)) {
                if (!out.newline) {
                    if (out.getIndentLength() != out.column - 1 && settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false) && ((JavaNode)node).getParent().getType() != 33) {
                        out.printNewline();
                        this.printIndentation(out);
                    } else {
                        switch (last) {
                            case 21: {
                                if (!settings.getBoolean(ConventionKeys.SPACE_BEFORE_BRACES, true)) break;
                                out.print(" ", out.last);
                            }
                        }
                    }
                }
                out.print("{", 7);
                Marker marker = null;
                if (settings.getBoolean(ConventionKeys.INDENT_DEEP, false)) {
                    if (!out.state.markers.isMarked()) {
                        marker = out.state.markers.add(out.line, out.column - 2);
                        out.state.markers.add(out.line, out.state.markers.getLast().column + out.indentSize);
                    } else {
                        marker = out.state.markers.add(out.line, out.state.markers.getLast().column + out.indentSize);
                    }
                } else {
                    out.indent();
                }
                boolean wrapped = false;
                if (firstElement.getType() != 33 && (!multiArray || this.hasArrayParent(node))) {
                    out.printNewline();
                    this.printIndentation(out);
                    wrapped = true;
                }
                int count = 0;
                JavaNode child2 = firstElement;
                while (child2 != null) {
                    switch (child2.getType()) {
                        case 82: {
                            if (!child2.hasCommentsAfter()) {
                                out.print(",", 82);
                                break;
                            }
                            out.print(",", 82);
                            wrapped = this.printCommentsAfter(child2, false, !this.isLastElement(child2), out);
                            count = 0;
                            break;
                        }
                        case 8: {
                            break;
                        }
                        default: {
                            ++count;
                            if (!wrapped) {
                                tester.reset();
                                PrinterFactory.create(child2).print(child2, tester);
                                if (!wrapAsNeeded && count > maxElementsPerLine || wrapAsNeeded && out.column + tester.length > lineLength) {
                                    JavaNode n = child2;
                                    if (!n.hasCommentsBefore() || n.getHiddenBefore().getLine() != n.getStartLine()) {
                                        out.printNewline();
                                        this.printIndentation(out);
                                        wrapped = true;
                                        count = 1;
                                        int blankLines = this.getOriginalBlankLines(child2);
                                        if (blankLines > 0) {
                                            out.printBlankLines(blankLines);
                                        }
                                    }
                                } else {
                                    int blankLines = this.getOriginalBlankLines(child2);
                                    if (blankLines > 0) {
                                        out.printNewline();
                                        this.printIndentation(out);
                                        wrapped = true;
                                        count = 1;
                                        out.printBlankLines(blankLines);
                                    } else if (spaceAfterComma && count > 1) {
                                        out.print(" ", 153);
                                    }
                                }
                            }
                            wrapped = false;
                            PrinterFactory.create(child2).print(child2, out);
                        }
                    }
                    child2 = (JavaNode)child2.getNextSibling();
                }
                if (marker != null) {
                    out.state.markers.remove(marker);
                } else {
                    out.unindent();
                }
                if (!out.newline) {
                    out.printNewline();
                }
                this.printIndentation(out);
                out.print("}", 33);
                out.testers.release(tester);
                return;
            }
            out.testers.release(tester);
        }
        switch (last) {
            case 21: {
                if (!settings.getBoolean(ConventionKeys.SPACE_BEFORE_BRACES, true)) break;
                out.print(" ", out.last);
            }
        }
        if (bracesPadding) {
            out.print("{ ", 7);
        } else {
            out.print("{", 7);
        }
        this.printCommentsAfter(node, false, false, out);
        out.indent();
        String comma = spaceAfterComma ? ", " : ",";
        child = (JavaNode)node.getFirstChild();
        while (child != null) {
            block13 : switch (((Node)child).getType()) {
                case 82: {
                    this.printCommentsBefore(child, out);
                    if (!((JavaNode)child).hasCommentsAfter()) {
                        if (this.isLast(child)) {
                            out.print(",", 82);
                            break;
                        }
                        out.print(comma, 82);
                        break;
                    }
                    out.print(",", 82);
                    this.printCommentsAfter(child, false, true, out);
                    break;
                }
                default: {
                    switch (((Node)child).getType()) {
                        case 32: {
                            JavaNode c = (JavaNode)((BaseAST)child).getFirstChild();
                            if (c.hasCommentsBefore()) {
                                out.printNewline();
                                this.printIndentation(out);
                                bracesPadding = false;
                            }
                            PrinterFactory.create(child).print(child, out);
                            if (!c.hasCommentsAfter()) break block13;
                            bracesPadding = false;
                            break block13;
                        }
                        default: {
                            PrinterFactory.create(child).print(child, out);
                            if (!((JavaNode)child).hasCommentsAfter()) break block13;
                            bracesPadding = false;
                        }
                    }
                }
            }
            child = (JavaNode)((BaseAST)child).getNextSibling();
        }
        out.unindent();
        if (bracesPadding) {
            out.print(" }", 8);
        } else {
            out.print("}", 8);
        }
    }

    private boolean isFirstOfMultiArray(JavaNode node) {
        JavaNode parent = node.getParent();
        return parent.getType() == 33 && node.getPreviousSibling() == parent;
    }

    private boolean isLast(AST node) {
        return node.getNextSibling().getType() == 8;
    }

    private boolean isLastElement(JavaNode node) {
        AST next = node.getNextSibling();
        return next == null || next.getType() == 8;
    }

    private boolean isMultiArray(AST node) {
        AST first = node.getFirstChild();
        return first != null && first.getType() == 33;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean hasArrayChild(AST node) {
        AST child = node.getFirstChild();
        while (child != null) {
            switch (child.getType()) {
                case 33: {
                    return true;
                }
                case 32: {
                    AST child1 = child.getFirstChild();
                    switch (child1.getType()) {
                        case 146: {
                            if (!this.hasArrayChild(child1.getFirstChild())) break;
                            return true;
                        }
                    }
                    break;
                }
            }
            child = child.getNextSibling();
        }
        return false;
    }

    private boolean hasArrayParent(AST node) {
        JavaNode parent = ((JavaNode)node).getParent();
        switch (parent.getType()) {
            case 33: {
                return true;
            }
            case 146: {
                return parent.getParent().getParent().getType() == 33;
            }
        }
        return false;
    }
}

