/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.def;

import com.ibm.wsdl.Constants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.jbpm.bpel.graph.def.Import;
import org.jbpm.bpel.variable.def.ElementType;
import org.jbpm.bpel.variable.def.MessageType;
import org.jbpm.bpel.variable.def.SchemaType;
import org.jbpm.bpel.wsdl.PartnerLinkType;
import org.jbpm.bpel.wsdl.Property;
import org.jbpm.bpel.wsdl.util.WsdlUtil;
import org.jbpm.bpel.wsdl.xml.WsdlConstants;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.module.exe.ModuleInstance;

public class ImportsDefinition
extends ModuleDefinition {
    private List imports;
    private Map partnerLinkTypes = new HashMap();
    private Map portTypes = new HashMap();
    private Map properties = new HashMap();
    private Map messages = new HashMap();
    private Map messageTypes = new HashMap();
    private Map elementTypes = new HashMap();
    private Map schemaTypes = new HashMap();
    private static final long serialVersionUID = 1L;

    public List getImports() {
        return this.imports;
    }

    public void setImports(List imports) {
        this.imports = imports;
    }

    public void addImport(Import imp) {
        if (this.imports == null) {
            this.imports = new ArrayList();
        }
        this.imports.add(imp);
    }

    public PartnerLinkType getPartnerLinkType(QName name) {
        PartnerLinkType partnerLinkType = (PartnerLinkType)this.partnerLinkTypes.get(name);
        if (partnerLinkType == null) {
            int n = this.imports.size();
            for (int i = 0; i < n; ++i) {
                Import imp = (Import)this.imports.get(i);
                if (!Import.Type.WSDL.equals((Object)imp.getType()) || (partnerLinkType = WsdlUtil.getPartnerLinkType((Definition)imp.getDocument(), name)) == null) continue;
                this.addPartnerLinkType(partnerLinkType);
                break;
            }
        }
        return partnerLinkType;
    }

    public void addPartnerLinkType(PartnerLinkType partnerLinkType) {
        PartnerLinkType.Role role = partnerLinkType.getFirstRole();
        if (role != null) {
            role.setPortType(this.addPortType(role.getPortType()));
        }
        if ((role = partnerLinkType.getSecondRole()) != null) {
            role.setPortType(this.addPortType(role.getPortType()));
        }
        this.partnerLinkTypes.put(partnerLinkType.getQName(), partnerLinkType);
    }

    public PortType getPortType(QName name) {
        PortType portType = (PortType)this.portTypes.get(name);
        if (portType == null) {
            int n = this.imports.size();
            for (int i = 0; i < n; ++i) {
                Import imp = (Import)this.imports.get(i);
                if (!Import.Type.WSDL.equals((Object)imp.getType()) || (portType = WsdlUtil.getPortType((Definition)imp.getDocument(), name)) == null) continue;
                this.portTypes.put(name, portType);
                break;
            }
        }
        return portType;
    }

    public PortType addPortType(PortType portType) {
        QName name = portType.getQName();
        PortType internPortType = (PortType)this.portTypes.get(name);
        if (internPortType == null) {
            Iterator operationIt = portType.getOperations().iterator();
            while (operationIt.hasNext()) {
                Output output;
                Operation operation = (Operation)operationIt.next();
                Input input = operation.getInput();
                if (input != null) {
                    input.setMessage(this.addMessage(input.getMessage()));
                }
                if ((output = operation.getOutput()) != null) {
                    output.setMessage(this.addMessage(output.getMessage()));
                }
                Iterator faultIt = operation.getFaults().values().iterator();
                while (faultIt.hasNext()) {
                    Fault fault = (Fault)faultIt.next();
                    fault.setMessage(this.addMessage(fault.getMessage()));
                }
            }
            this.portTypes.put(name, portType);
            internPortType = portType;
        }
        return internPortType;
    }

    public Message getMessage(QName name) {
        Message message = (Message)this.messages.get(name);
        if (message == null) {
            int n = this.imports.size();
            for (int i = 0; i < n; ++i) {
                Import imp = (Import)this.imports.get(i);
                if (!Import.Type.WSDL.equals((Object)imp.getType()) || (message = WsdlUtil.getMessage((Definition)imp.getDocument(), name)) == null) continue;
                this.messages.put(name, message);
                break;
            }
        }
        return message;
    }

    public Message addMessage(Message message) {
        QName name = message.getQName();
        Message internMessage = (Message)this.messages.get(name);
        if (internMessage == null) {
            this.messages.put(name, message);
            internMessage = message;
            this.addMessageType(message);
        }
        return internMessage;
    }

    public Property getProperty(QName name) {
        Property property = (Property)this.properties.get(name);
        if (property == null) {
            int n = this.imports.size();
            for (int i = 0; i < n; ++i) {
                Import imp = (Import)this.imports.get(i);
                if (!Import.Type.WSDL.equals((Object)imp.getType()) || (property = WsdlUtil.getProperty((Definition)imp.getDocument(), name)) == null) continue;
                this.properties.put(name, property);
                break;
            }
        }
        return property;
    }

    public void addProperty(Property property) {
        this.properties.put(property.getQName(), property);
    }

    public Import getDeclaringImport(QName name, QName element) {
        int n = this.imports.size();
        for (int i = 0; i < n; ++i) {
            Import imp = (Import)this.imports.get(i);
            if (!imp.getType().equals((Object)Import.Type.WSDL)) continue;
            Definition def = (Definition)imp.getDocument();
            if (!(Constants.Q_ELEM_PORT_TYPE.equals(element) && WsdlUtil.getPortType(def, name) != null || Constants.Q_ELEM_MESSAGE.equals(element) && WsdlUtil.getMessage(def, name) != null || WsdlConstants.Q_PARTNER_LINK_TYPE.equals(element) && WsdlUtil.getPartnerLinkType(def, name) != null) && (!WsdlConstants.Q_PROPERTY.equals(element) || WsdlUtil.getProperty(def, name) == null)) continue;
            return imp;
        }
        return null;
    }

    public MessageType getMessageType(QName name) {
        Message message;
        MessageType type;
        if (this.messageTypes == null) {
            this.messageTypes = new HashMap();
        }
        if ((type = (MessageType)this.messageTypes.get(name)) == null && (message = this.getMessage(name)) != null) {
            type = this.addMessageType(message);
        }
        return type;
    }

    private MessageType addMessageType(Message message) {
        MessageType type = new MessageType(message);
        this.messageTypes.put(message.getQName(), type);
        return type;
    }

    public ElementType getElementType(QName name) {
        ElementType type;
        if (this.elementTypes == null) {
            this.elementTypes = new HashMap();
        }
        if ((type = (ElementType)this.elementTypes.get(name)) == null) {
            type = new ElementType(name);
            this.elementTypes.put(name, type);
        }
        return type;
    }

    public SchemaType getSchemaType(QName name) {
        SchemaType type;
        if (this.schemaTypes == null) {
            this.schemaTypes = new HashMap();
        }
        if ((type = (SchemaType)this.schemaTypes.get(name)) == null) {
            type = new SchemaType(name);
            this.schemaTypes.put(name, type);
        }
        return type;
    }

    public ModuleInstance createInstance() {
        return null;
    }
}

