/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.par;

import java.io.ByteArrayInputStream;
import java.util.List;
import javax.wsdl.Definition;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.def.Import;
import org.jbpm.bpel.par.DefDescriptor;
import org.jbpm.bpel.xml.BpelReader;
import org.jbpm.bpel.xml.DefDescriptorReader;
import org.jbpm.bpel.xml.ProblemCollector;
import org.jbpm.bpel.xml.ProblemHandler;
import org.jbpm.bpel.xml.ProcessArchiveWsdlLocator;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jpdl.par.ProcessArchive;
import org.jbpm.jpdl.par.ProcessArchiveParser;
import org.jbpm.jpdl.xml.Problem;
import org.xml.sax.InputSource;

public class DefDescriptorArchiveParser
implements ProcessArchiveParser {
    public static final String DEFINITION_DESC_NAME = "META-INF/bpel-definition.xml";
    private static final long serialVersionUID = 1L;

    public ProcessDefinition readFromArchive(ProcessArchive archive, ProcessDefinition processDefinition) {
        BpelProcessDefinition bpelProcessDefinition = new BpelProcessDefinition();
        byte[] entry = archive.removeEntry(DEFINITION_DESC_NAME);
        if (entry != null) {
            ProblemCollector collector = new ProblemCollector(DEFINITION_DESC_NAME);
            DefDescriptor defDescriptor = this.readDescriptor(entry, collector);
            bpelProcessDefinition.setLocation(defDescriptor.getLocation());
            List imports = defDescriptor.getImports();
            if (!imports.isEmpty()) {
                this.readDocuments(imports, archive, collector);
                bpelProcessDefinition.getImports().setImports(imports);
            }
            archive.getProblems().addAll(collector.getProblems());
        } else {
            Problem problem = new Problem(2, "definition descriptor not found");
            archive.addProblem(problem);
        }
        return bpelProcessDefinition;
    }

    protected DefDescriptor readDescriptor(byte[] entry, ProblemHandler problemHandler) {
        DefDescriptorReader reader = DefDescriptorReader.getInstance();
        reader.setProblemHandler(problemHandler);
        DefDescriptor defDescriptor = new DefDescriptor();
        reader.read(defDescriptor, new InputSource(new ByteArrayInputStream(entry)));
        reader.setProblemHandler(null);
        return defDescriptor;
    }

    protected void readDocuments(List imports, ProcessArchive archive, ProblemHandler problemHandler) {
        BpelReader bpelReader = new BpelReader();
        bpelReader.setProblemHandler(problemHandler);
        ProcessArchiveWsdlLocator wsdlLocator = new ProcessArchiveWsdlLocator("", archive);
        wsdlLocator.setProblemHandler(problemHandler);
        int n = imports.size();
        for (int i = 0; i < n; ++i) {
            Import imp = (Import)imports.get(i);
            Import.Type impType = imp.getType();
            if (!Import.Type.WSDL.equals((Object)impType)) continue;
            bpelReader.readWsdlDocument(imp, wsdlLocator);
            Definition def = (Definition)imp.getDocument();
            String namespace = imp.getNamespace();
            if (namespace == null) {
                imp.setNamespace(def.getTargetNamespace());
                continue;
            }
            if (namespace.equals(def.getTargetNamespace())) continue;
            problemHandler.add(new Problem(2, "import namespace does not match target of referenced definitions"));
        }
        bpelReader.setProblemHandler(null);
    }
}

