/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.sublang.xpath;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;
import org.jbpm.bpel.sublang.xpath.ScopeVariableContext;
import org.jbpm.bpel.sublang.xpath.XPathEvaluatorFactory;
import org.jbpm.bpel.sublang.xpath.XPathQueryEvaluator;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.variable.exe.MessageValue;
import org.w3c.dom.Element;

class GetVariableDataFunction
implements Function {
    private static final Log log = LogFactory.getLog((Class)GetVariableDataFunction.class);

    GetVariableDataFunction() {
    }

    public Object call(Context context, List args) throws FunctionCallException {
        Object value;
        switch (args.size()) {
            case 1: {
                value = GetVariableDataFunction.evaluate(args.get(0), context);
                break;
            }
            case 2: {
                value = GetVariableDataFunction.evaluate(args.get(0), args.get(1), context);
                break;
            }
            case 3: {
                value = GetVariableDataFunction.evaluate(args.get(0), args.get(1), args.get(2), context);
                break;
            }
            default: {
                throw new FunctionCallException("getVariableData() requires one to three arguments");
            }
        }
        return value;
    }

    public static Object evaluate(Object variableArg, Context context) throws FunctionCallException {
        log.debug((Object)("evaluate(" + variableArg + ")"));
        String variableName = StringFunction.evaluate((Object)variableArg, (Navigator)context.getNavigator());
        ScopeVariableContext variableContext = (ScopeVariableContext)context.getContextSupport().getVariableContext();
        VariableDefinition variable = variableContext.getVariableDefinition(variableName);
        if (variable == null) {
            throw new FunctionCallException("variable not found: " + variableName);
        }
        Object variableValue = variable.getValue(variableContext.getToken());
        if (variableValue instanceof MessageValue) {
            throw new FunctionCallException("illegal access to message variable: " + variableName);
        }
        log.debug((Object)("evaluate : " + variableValue));
        return variableValue;
    }

    public static Object evaluate(Object variableArg, Object partArg, Context context) throws FunctionCallException {
        log.debug((Object)("evaluate(" + variableArg + ", " + partArg + ")"));
        Navigator nav = context.getNavigator();
        String variableName = StringFunction.evaluate((Object)variableArg, (Navigator)nav);
        ScopeVariableContext variableContext = (ScopeVariableContext)context.getContextSupport().getVariableContext();
        VariableDefinition variable = variableContext.getVariableDefinition(variableName);
        if (variable == null) {
            throw new FunctionCallException("variable not found: " + variableName);
        }
        Object variableValue = variable.getValue(variableContext.getToken());
        if (!(variableValue instanceof MessageValue)) {
            throw new FunctionCallException("variable is not a message: " + variableName);
        }
        String partName = StringFunction.evaluate((Object)partArg, (Navigator)nav);
        Element partValue = ((MessageValue)variableValue).getPart(partName);
        log.debug((Object)("evaluate : " + partValue));
        return partValue;
    }

    public static Object evaluate(Object variableArg, Object partArg, Object locationArg, Context context) throws FunctionCallException {
        log.debug((Object)("evaluate(" + variableArg + ", " + partArg + ", " + locationArg + ")"));
        Navigator navigator = context.getNavigator();
        String variableName = StringFunction.evaluate((Object)variableArg, (Navigator)navigator);
        ContextSupport support = context.getContextSupport();
        ScopeVariableContext variableContext = (ScopeVariableContext)support.getVariableContext();
        VariableDefinition variable = variableContext.getVariableDefinition(variableName);
        if (variable == null) {
            throw new FunctionCallException("variable not found: " + variableName);
        }
        Object variableValue = variable.getValue(variableContext.getToken());
        if (!(variableValue instanceof MessageValue)) {
            throw new FunctionCallException("variable is not a message: " + variableName);
        }
        String partName = StringFunction.evaluate((Object)partArg, (Navigator)navigator);
        Element partValue = ((MessageValue)variableValue).getPart(partName);
        String locationString = StringFunction.evaluate((Object)locationArg, (Navigator)navigator);
        try {
            XPathQueryEvaluator locationEvaluator = XPathEvaluatorFactory.createQueryEvaluator(locationString);
            locationEvaluator.setNamespaceContext(support.getNamespaceContext());
            Object queryValue = locationEvaluator.evaluate(partValue.getOwnerDocument());
            log.debug((Object)("evaluate : " + queryValue));
            return queryValue;
        }
        catch (JaxenException e) {
            throw new FunctionCallException("could not parse query", (Exception)((Object)e));
        }
    }
}

