/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.wsdl.util;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.extensions.soap.SOAPConstants;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.def.BpelVisitorSupport;
import org.jbpm.bpel.graph.def.Import;
import org.jbpm.bpel.graph.def.ImportsDefinition;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.integration.def.PartnerLinkDefinition;
import org.jbpm.bpel.wsdl.PartnerLinkType;
import org.jbpm.bpel.wsdl.util.WsdlUtil;
import org.jbpm.bpel.xml.DefaultProblemHandler;
import org.jbpm.bpel.xml.ProblemHandler;
import org.jbpm.jpdl.xml.Problem;

public class ServiceGenerator {
    private String outputDirectory;
    private String serviceFile = "service.wsdl";
    private String bindingFile = "binding.wsdl";
    private ProblemHandler problemHandler;
    private Set writtenInterfaceFiles = new HashSet();
    private static final String ADDRESS_LOCATION_URI = "REPLACE_WITH_ACTUAL_URI";
    static final Log log = LogFactory.getLog((Class)ServiceGenerator.class);

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getBindingFile() {
        return this.bindingFile;
    }

    public void setBindingFile(String bindingFile) {
        this.bindingFile = bindingFile;
    }

    public String getServiceFile() {
        return this.serviceFile;
    }

    public void setServiceFile(String serviceFile) {
        this.serviceFile = serviceFile;
    }

    public ProblemHandler getProblemHandler() {
        if (this.problemHandler == null) {
            this.problemHandler = new DefaultProblemHandler();
        }
        return this.problemHandler;
    }

    public void setProblemHandler(ProblemHandler problemHandler) {
        this.problemHandler = problemHandler;
    }

    public void generatePortComponents(BpelProcessDefinition process) {
        this.writtenInterfaceFiles.clear();
        PortBuilder portBuilder = new PortBuilder();
        portBuilder.visit(process);
        Map bindingDefinitions = portBuilder.getBindingDefinitions();
        Definition serviceDefinition = portBuilder.getServiceDefinition();
        int dotIndex = this.bindingFile.lastIndexOf(46);
        String base = this.bindingFile.substring(0, dotIndex);
        String extension = this.bindingFile.substring(dotIndex + 1);
        WSDLWriter writer = WsdlUtil.getFactory().newWSDLWriter();
        Iterator it = bindingDefinitions.values().iterator();
        int i = 1;
        while (it.hasNext()) {
            Definition bindingDefinition = (Definition)it.next();
            String location = base + i + '.' + extension;
            javax.wsdl.Import bindingImport = serviceDefinition.createImport();
            bindingImport.setDefinition(bindingDefinition);
            bindingImport.setNamespaceURI(bindingDefinition.getTargetNamespace());
            bindingImport.setLocationURI(location);
            serviceDefinition.addImport(bindingImport);
            try {
                WsdlUtil.writeFile(writer, bindingDefinition, new File(this.outputDirectory, location));
                log.info((Object)("wrote binding definition: " + location));
            }
            catch (WSDLException e) {
                Problem problem = new Problem(2, "could not write binding wsdl: " + location, (Throwable)e);
                this.getProblemHandler().add(problem);
                return;
            }
            ++i;
        }
        try {
            WsdlUtil.writeFile(writer, serviceDefinition, new File(this.outputDirectory, this.serviceFile));
            log.info((Object)("wrote service definition: " + this.serviceFile));
        }
        catch (WSDLException e) {
            Problem problem = new Problem(2, "could not write service wsdl: " + this.serviceFile, (Throwable)e);
            this.getProblemHandler().add(problem);
        }
    }

    protected Definition generateServiceDefinition(BpelProcessDefinition process) {
        return this.createDefinition(process.getTargetNamespace());
    }

    protected String generateServiceLocalName(BpelProcessDefinition process) {
        return process.getName() + "Service";
    }

    protected Definition generateBindingDefinition(PortType portType, ImportsDefinition imports, Map bindingDefinitions) throws WSDLException {
        Import processImport;
        QName portTypeName = portType.getQName();
        String targetNamespace = portTypeName.getNamespaceURI();
        Definition bindingDefinition = (Definition)bindingDefinitions.get(targetNamespace);
        if (bindingDefinition == null) {
            bindingDefinition = this.createDefinition(targetNamespace);
            bindingDefinitions.put(targetNamespace, bindingDefinition);
        }
        if ((processImport = imports.getDeclaringImport(portTypeName, Constants.Q_ELEM_PORT_TYPE)) == null) {
            Problem problem = new Problem(2, "declaring import not found: portType=" + portTypeName);
            this.getProblemHandler().add(problem);
        } else if (!this.containsInterfaceImport(bindingDefinition, processImport)) {
            javax.wsdl.Import interfaceImport = this.generateInterfaceImport(bindingDefinition, processImport);
            bindingDefinition.addImport(interfaceImport);
        }
        return bindingDefinition;
    }

    protected boolean containsInterfaceImport(Definition def, Import processImport) {
        List interfaceImports = def.getImports(processImport.getNamespace());
        if (interfaceImports != null) {
            String location = processImport.getLocation();
            Iterator interfaceImportIt = interfaceImports.iterator();
            while (interfaceImportIt.hasNext()) {
                javax.wsdl.Import interfaceImport = (javax.wsdl.Import)interfaceImportIt.next();
                if (!interfaceImport.getLocationURI().equals(location)) continue;
                return true;
            }
        }
        return false;
    }

    protected javax.wsdl.Import generateInterfaceImport(Definition def, Import processImport) throws WSDLException {
        javax.wsdl.Import interfaceImport = def.createImport();
        interfaceImport.setNamespaceURI(processImport.getNamespace());
        interfaceImport.setLocationURI(processImport.getLocation());
        interfaceImport.setDefinition((Definition)processImport.getDocument());
        this.writeImportedDefinition(this.outputDirectory, interfaceImport);
        return interfaceImport;
    }

    protected void writeImportedDefinition(String baseDirectory, javax.wsdl.Import imp) throws WSDLException {
        String locationURI = imp.getLocationURI();
        if (URI.create(locationURI).isAbsolute()) {
            return;
        }
        WSDLWriter writer = WsdlUtil.getFactory().newWSDLWriter();
        Definition interfaceDefinition = imp.getDefinition();
        File interfaceFile = new File(baseDirectory, locationURI);
        if (!this.writtenInterfaceFiles.contains(interfaceFile)) {
            this.writtenInterfaceFiles.add(interfaceFile);
            WsdlUtil.writeFile(writer, interfaceDefinition, interfaceFile);
            log.info((Object)("wrote interface definition: locationURI=" + locationURI + ", basePath=" + baseDirectory));
        }
        baseDirectory = interfaceFile.getParent();
        Iterator importListIt = interfaceDefinition.getImports().values().iterator();
        while (importListIt.hasNext()) {
            List importList = (List)importListIt.next();
            Iterator importIt = importList.iterator();
            while (importIt.hasNext()) {
                imp = (javax.wsdl.Import)importIt.next();
                this.writeImportedDefinition(baseDirectory, imp);
            }
        }
    }

    protected String generateBindingLocalName(PortType portType) {
        return portType.getQName().getLocalPart() + "Binding";
    }

    protected Binding generateBinding(Definition def, PortType portType) throws WSDLException {
        Binding binding = def.createBinding();
        binding.setPortType(portType);
        binding.setUndefined(false);
        ExtensionRegistry extRegistry = def.getExtensionRegistry();
        SOAPBinding soapBinding = (SOAPBinding)extRegistry.createExtension(Binding.class, SOAPConstants.Q_ELEM_SOAP_BINDING);
        soapBinding.setStyle("rpc");
        soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
        Iterator operationIt = portType.getOperations().iterator();
        while (operationIt.hasNext()) {
            Operation operation = (Operation)operationIt.next();
            BindingOperation bindingOperation = this.generateBindingOperation(def, operation);
            binding.addBindingOperation(bindingOperation);
        }
        return binding;
    }

    protected BindingOperation generateBindingOperation(Definition def, Operation operation) throws WSDLException {
        BindingOperation bindOperation = def.createBindingOperation();
        bindOperation.setOperation(operation);
        bindOperation.setName(operation.getName());
        SOAPOperation soapOper = (SOAPOperation)def.getExtensionRegistry().createExtension(BindingOperation.class, SOAPConstants.Q_ELEM_SOAP_OPERATION);
        soapOper.setSoapActionURI(this.generateSoapAction(def, operation));
        bindOperation.addExtensibilityElement((ExtensibilityElement)soapOper);
        BindingInput bindInput = this.generateBindingInput(def, operation);
        bindOperation.setBindingInput(bindInput);
        if (operation.getOutput() != null) {
            BindingOutput bindOutput = this.generateBindingOutput(def, operation);
            bindOperation.setBindingOutput(bindOutput);
            Iterator faultIt = operation.getFaults().values().iterator();
            while (faultIt.hasNext()) {
                Fault fault = (Fault)faultIt.next();
                BindingFault bindFault = this.generateBindingFault(def, fault);
                bindOperation.addBindingFault(bindFault);
            }
        }
        return bindOperation;
    }

    protected String generateSoapAction(Definition def, Operation operation) {
        String soapAction;
        try {
            String targetNamespace = def.getTargetNamespace();
            URI targetNamespaceURI = new URI(targetNamespace);
            String operationName = operation.getName();
            URI operationURI = new URI(operationName);
            soapAction = targetNamespaceURI.isOpaque() ? targetNamespace + ':' + operationName : targetNamespaceURI.resolve(operationURI).toString();
        }
        catch (URISyntaxException e) {
            soapAction = "";
        }
        return soapAction;
    }

    protected BindingInput generateBindingInput(Definition def, Operation operation) throws WSDLException {
        BindingInput bindInput = def.createBindingInput();
        SOAPBody soapBody = (SOAPBody)def.getExtensionRegistry().createExtension(BindingInput.class, SOAPConstants.Q_ELEM_SOAP_BODY);
        soapBody.setUse("literal");
        soapBody.setNamespaceURI(this.generateSoapBodyNamespace(def, operation));
        bindInput.addExtensibilityElement((ExtensibilityElement)soapBody);
        return bindInput;
    }

    protected BindingOutput generateBindingOutput(Definition def, Operation operation) throws WSDLException {
        BindingOutput bindOutput = def.createBindingOutput();
        SOAPBody soapBody = (SOAPBody)def.getExtensionRegistry().createExtension(BindingOutput.class, SOAPConstants.Q_ELEM_SOAP_BODY);
        soapBody.setUse("literal");
        soapBody.setNamespaceURI(this.generateSoapBodyNamespace(def, operation));
        bindOutput.addExtensibilityElement((ExtensibilityElement)soapBody);
        return bindOutput;
    }

    protected BindingFault generateBindingFault(Definition def, Fault fault) throws WSDLException {
        String faultName = fault.getName();
        BindingFault bindFault = def.createBindingFault();
        bindFault.setName(faultName);
        SOAPFault soapFault = (SOAPFault)def.getExtensionRegistry().createExtension(BindingFault.class, SOAPConstants.Q_ELEM_SOAP_FAULT);
        soapFault.setName(faultName);
        soapFault.setUse("literal");
        bindFault.addExtensibilityElement((ExtensibilityElement)soapFault);
        return bindFault;
    }

    protected String generateSoapBodyNamespace(Definition def, Operation operation) {
        return def.getTargetNamespace();
    }

    protected String generatePortName(Service service, PartnerLinkDefinition partnerLink) {
        String portName = partnerLink.getMyRole().getName() + "Port";
        Map ports = service.getPorts();
        if (ports.containsKey(portName)) {
            portName = ServiceGenerator.generateName(portName, ports.keySet());
        }
        return portName;
    }

    protected Port generatePort(Definition def, Binding binding) throws WSDLException {
        Port port = def.createPort();
        port.setBinding(binding);
        String bindingNamespace = binding.getQName().getNamespaceURI();
        Map namespaces = def.getNamespaces();
        if (!namespaces.containsValue(bindingNamespace)) {
            String prefix = ServiceGenerator.generateName("bindingNS", namespaces.keySet());
            def.addNamespace(prefix, bindingNamespace);
        }
        SOAPAddress soapAddress = (SOAPAddress)def.getExtensionRegistry().createExtension(Port.class, SOAPConstants.Q_ELEM_SOAP_ADDRESS);
        soapAddress.setLocationURI(ADDRESS_LOCATION_URI);
        port.addExtensibilityElement((ExtensibilityElement)soapAddress);
        return port;
    }

    protected Definition createDefinition(String targetNamespace) {
        Definition def = WsdlUtil.getFactory().newDefinition();
        def.setTargetNamespace(targetNamespace);
        def.addNamespace("tns", targetNamespace);
        def.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        def.addNamespace(null, "http://schemas.xmlsoap.org/wsdl/");
        return def;
    }

    private static String generateName(String baseText, Set existingNames) {
        StringBuffer nameBuffer = new StringBuffer(baseText);
        int baseLength = baseText.length();
        for (int i = 2; i < Integer.MAX_VALUE; ++i) {
            String altName = nameBuffer.append(i).toString();
            if (!existingNames.contains(altName)) {
                return altName;
            }
            nameBuffer.setLength(baseLength);
        }
        throw new RuntimeException("could not generate name: base=" + baseText);
    }

    class PortBuilder
    extends BpelVisitorSupport {
        private Definition serviceDefinition;
        private Service service;
        private ImportsDefinition imports;
        private Map bindingDefinitions = new HashMap();

        PortBuilder() {
        }

        public void visit(BpelProcessDefinition process) {
            this.serviceDefinition = ServiceGenerator.this.generateServiceDefinition(process);
            this.service = this.serviceDefinition.createService();
            QName serviceName = new QName(this.serviceDefinition.getTargetNamespace(), ServiceGenerator.this.generateServiceLocalName(process));
            this.service.setQName(serviceName);
            this.serviceDefinition.addService(this.service);
            this.imports = process.getImports();
            this.visit(process.getGlobalScope());
        }

        public void visit(Scope scope) {
            Iterator partnerLinkIt = scope.getPartnerLinks().values().iterator();
            while (partnerLinkIt.hasNext()) {
                PartnerLinkDefinition partnerLink = (PartnerLinkDefinition)partnerLinkIt.next();
                try {
                    this.visit(partnerLink);
                }
                catch (WSDLException e) {
                    Problem problem = new Problem(2, "could not generate port: partnerLink=" + partnerLink.getName(), (Throwable)e);
                    ServiceGenerator.this.getProblemHandler().add(problem);
                }
            }
            scope.getActivity().accept(this);
        }

        public Definition getServiceDefinition() {
            return this.serviceDefinition;
        }

        public Map getBindingDefinitions() {
            return this.bindingDefinitions;
        }

        protected void visit(PartnerLinkDefinition partnerLink) throws WSDLException {
            QName bindingName;
            PartnerLinkType.Role myRole = partnerLink.getMyRole();
            if (myRole == null) {
                return;
            }
            PortType portType = myRole.getPortType();
            Definition bindingDefinition = ServiceGenerator.this.generateBindingDefinition(portType, this.imports, this.bindingDefinitions);
            Binding binding = bindingDefinition.getBinding(bindingName = new QName(bindingDefinition.getTargetNamespace(), ServiceGenerator.this.generateBindingLocalName(portType)));
            if (binding == null) {
                binding = ServiceGenerator.this.generateBinding(bindingDefinition, portType);
                binding.setQName(bindingName);
                bindingDefinition.addBinding(binding);
            }
            Port port = ServiceGenerator.this.generatePort(this.serviceDefinition, binding);
            String portName = ServiceGenerator.this.generatePortName(this.service, partnerLink);
            port.setName(portName);
            this.service.addPort(port);
        }
    }
}

