/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml;

import com.ibm.wsdl.util.xml.DOMUtils;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.graph.basic.Assign;
import org.jbpm.bpel.graph.basic.assign.FromElement;
import org.jbpm.bpel.graph.basic.assign.FromExpression;
import org.jbpm.bpel.graph.basic.assign.FromPartnerLink;
import org.jbpm.bpel.graph.basic.assign.FromProperty;
import org.jbpm.bpel.graph.basic.assign.FromText;
import org.jbpm.bpel.graph.basic.assign.FromVariable;
import org.jbpm.bpel.graph.basic.assign.ToExpression;
import org.jbpm.bpel.graph.basic.assign.ToPartnerLink;
import org.jbpm.bpel.graph.basic.assign.ToProperty;
import org.jbpm.bpel.graph.basic.assign.ToVariable;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.CompositeActivity;
import org.jbpm.bpel.integration.def.PartnerLinkDefinition;
import org.jbpm.bpel.sublang.def.Query;
import org.jbpm.bpel.variable.def.MessageType;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.variable.def.VariableType;
import org.jbpm.bpel.wsdl.Property;
import org.jbpm.bpel.xml.ActivityReader;
import org.jbpm.bpel.xml.ParseProblem;
import org.jbpm.bpel.xml.util.DatatypeUtil;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Element;

public class AssignReader
extends ActivityReader {
    public Activity read(Element element, CompositeActivity parent) {
        Assign assign = new Assign();
        this.readStandardProperties(element, assign, parent);
        this.readAssign(element, assign, parent);
        return assign;
    }

    public void readAssign(Element assignElem, Assign assign, CompositeActivity parent) {
        Iterator copyElemIt = XmlUtil.getElements(assignElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "copy");
        while (copyElemIt.hasNext()) {
            Element copyElem = (Element)copyElemIt.next();
            Element fromElem = XmlUtil.getElement(copyElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "from");
            Assign.From from = this.readFrom(fromElem, parent);
            Element toElem = XmlUtil.getElement(copyElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "to");
            Assign.To to = this.readTo(toElem, parent);
            Assign.Copy copy = new Assign.Copy();
            copy.setFrom(from);
            copy.setTo(to);
            assign.addCopy(copy);
        }
        parent.addNode(assign);
    }

    public Assign.From readFrom(Element fromElem, CompositeActivity parent) {
        Assign.From from = fromElem.hasAttribute("variable") ? (fromElem.hasAttribute("property") ? this.readFromProperty(fromElem, parent) : this.readFromVariable(fromElem, parent)) : (fromElem.hasAttribute("partnerLink") ? this.readFromPartnerLink(fromElem, parent) : (XmlUtil.getElement(fromElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "literal") != null ? this.readFromLiteral(fromElem) : this.readFromExpression(fromElem, parent)));
        return from;
    }

    public Assign.To readTo(Element toElem, CompositeActivity parent) {
        Assign.To to = null;
        to = toElem.hasAttribute("variable") ? (toElem.hasAttribute("property") ? this.readToProperty(toElem, parent) : this.readToVariable(toElem, parent)) : (toElem.hasAttribute("partnerLink") ? this.readToPartnerLink(toElem, parent) : this.readToExpression(toElem, parent));
        return to;
    }

    protected Assign.From readFromVariable(Element fromElem, CompositeActivity parent) {
        VariableDefinition variable = this.readVariable(fromElem, parent);
        FromVariable from = new FromVariable();
        from.setVariable(variable);
        from.setPart(this.readPart(fromElem, variable));
        from.setQuery(this.readQuery(fromElem, parent));
        return from;
    }

    protected Assign.From readFromProperty(Element fromElem, CompositeActivity parent) {
        FromProperty from = new FromProperty();
        from.setVariable(this.readVariable(fromElem, parent));
        from.setProperty(this.readProperty(parent, fromElem));
        return from;
    }

    protected Assign.From readFromPartnerLink(Element fromElem, CompositeActivity parent) {
        String referenceValue = fromElem.getAttribute("endpointReference");
        FromPartnerLink.Reference reference = FromPartnerLink.Reference.valueOf(referenceValue);
        FromPartnerLink from = new FromPartnerLink();
        from.setPartnerLink(this.readPartnerLink(fromElem, parent));
        from.setEndpointReference(reference);
        return from;
    }

    protected Assign.From readFromLiteral(Element fromElem) {
        Element literalElem = XmlUtil.getElement(fromElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "literal");
        Element firstChildElement = XmlUtil.getElement(literalElem);
        if (firstChildElement == null) {
            String childText = DatatypeUtil.toString(literalElem);
            FromText from = new FromText();
            from.setLiteral(childText);
            return from;
        }
        if (DOMUtils.getNextSiblingElement((Element)firstChildElement) == null) {
            FromElement from = new FromElement();
            from.setLiteral(firstChildElement);
            return from;
        }
        this.bpelReader.getProblemHandler().add(new ParseProblem("more than one child element present", fromElem));
        return null;
    }

    protected Assign.From readFromExpression(Element fromElem, CompositeActivity parent) {
        FromExpression from = new FromExpression();
        from.setExpression(this.bpelReader.readExpression(fromElem, parent));
        return from;
    }

    protected Assign.To readToVariable(Element toElem, CompositeActivity parent) {
        VariableDefinition variable = this.readVariable(toElem, parent);
        ToVariable to = new ToVariable();
        to.setVariable(variable);
        to.setPart(this.readPart(toElem, variable));
        to.setQuery(this.readQuery(toElem, parent));
        return to;
    }

    protected Assign.To readToProperty(Element toElem, CompositeActivity parent) {
        ToProperty to = new ToProperty();
        to.setVariable(this.readVariable(toElem, parent));
        to.setProperty(this.readProperty(parent, toElem));
        return to;
    }

    protected Assign.To readToPartnerLink(Element toElem, CompositeActivity parent) {
        ToPartnerLink to = new ToPartnerLink();
        to.setPartnerLink(this.readPartnerLink(toElem, parent));
        return to;
    }

    protected Assign.To readToExpression(Element toElem, CompositeActivity parent) {
        ToExpression to = new ToExpression();
        to.setExpression(this.bpelReader.readExpression(toElem, parent));
        return to;
    }

    protected VariableDefinition readVariable(Element contextElem, CompositeActivity parent) {
        String variableName = XmlUtil.getAttribute(contextElem, "variable");
        VariableDefinition variable = parent.findVariable(variableName);
        if (variable == null) {
            this.bpelReader.getProblemHandler().add(new ParseProblem("variable not found", contextElem));
        }
        return variable;
    }

    protected String readPart(Element contextElem, VariableDefinition variable) {
        String partName = XmlUtil.getAttribute(contextElem, "part");
        if (partName != null && variable != null) {
            VariableType type = variable.getType();
            if (type.isMessage()) {
                MessageType messageType = (MessageType)type;
                if (!messageType.getMessage().getParts().containsKey(partName)) {
                    this.bpelReader.getProblemHandler().add(new ParseProblem("part not found", contextElem));
                }
            } else {
                this.bpelReader.getProblemHandler().add(new ParseProblem("non-message variable has no parts", contextElem));
            }
        }
        return partName;
    }

    protected Query readQuery(Element contextElem, CompositeActivity parent) {
        String queryString = XmlUtil.getAttribute(contextElem, "query");
        if (queryString == null) {
            return null;
        }
        Query query = new Query();
        query.setText(queryString);
        query.setNamespaces(parent.getBpelProcessDefinition().addNamespaces(XmlUtil.getNamespaces(contextElem)));
        try {
            query.parse();
        }
        catch (BpelException e) {
            this.bpelReader.getProblemHandler().add(new ParseProblem(2, "could not parse script", (Throwable)((Object)e), contextElem));
        }
        return query;
    }

    protected Property readProperty(CompositeActivity parent, Element contextElem) {
        String propertyName = XmlUtil.getAttribute(contextElem, "property");
        QName propertyQName = XmlUtil.parseQName(propertyName, contextElem);
        Property property = parent.getBpelProcessDefinition().getImports().getProperty(propertyQName);
        if (property == null) {
            this.bpelReader.getProblemHandler().add(new ParseProblem("property not found", contextElem));
        }
        return property;
    }

    protected PartnerLinkDefinition readPartnerLink(Element contextElem, CompositeActivity parent) {
        String partnerLinkName = XmlUtil.getAttribute(contextElem, "partnerLink");
        PartnerLinkDefinition partnerLink = parent.findPartnerLink(partnerLinkName);
        if (partnerLink == null) {
            this.bpelReader.getProblemHandler().add(new ParseProblem("partner link not found", contextElem));
        }
        return partnerLink;
    }
}

