/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml;

import java.util.Iterator;
import org.jbpm.bpel.alarm.AlarmAction;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.CompositeActivity;
import org.jbpm.bpel.graph.struct.Pick;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.xml.ActivityReader;
import org.jbpm.bpel.xml.ParseProblem;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Element;

public class PickReader
extends ActivityReader {
    public Activity read(Element element, CompositeActivity parent) {
        Pick pick = new Pick();
        this.readStandardProperties(element, pick, parent);
        parent.addNode(pick);
        this.readPick(element, pick);
        return pick;
    }

    public void readPick(Element pickElem, Pick pick) {
        boolean createInstance = this.bpelReader.readTBoolean(pickElem.getAttributeNode("createInstance"), Boolean.FALSE);
        boolean initial = pick.isInitial();
        if (initial) {
            pick.setCreateInstance(createInstance);
        } else if (createInstance) {
            this.bpelReader.getProblemHandler().add(new ParseProblem("pick must be initial in order to create instances", pickElem));
        }
        Iterator onMessageElemIt = XmlUtil.getElements(pickElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "onMessage");
        while (onMessageElemIt.hasNext()) {
            Element onMessageElem = (Element)onMessageElemIt.next();
            ReceiveAction receiveAction = this.bpelReader.readReceiveAction(onMessageElem, pick);
            Element activityElem = this.bpelReader.getActivityElement(onMessageElem);
            Activity activity = this.bpelReader.readActivity(activityElem, pick);
            pick.setOnMessage(activity, receiveAction);
        }
        Iterator alarmElemIt = XmlUtil.getElements(pickElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "onAlarm");
        if (!initial) {
            while (alarmElemIt.hasNext()) {
                Element onAlarmElem = (Element)alarmElemIt.next();
                AlarmAction alarmAction = this.bpelReader.readAlarmAction(onAlarmElem, pick);
                Element activityElem = this.bpelReader.getActivityElement(onAlarmElem);
                Activity activity = this.bpelReader.readActivity(activityElem, pick);
                pick.setOnAlarm(activity, alarmAction);
            }
        } else if (alarmElemIt.hasNext()) {
            this.bpelReader.getProblemHandler().add(new ParseProblem("pick must not be initial in order to handle alarms", pickElem));
        }
    }
}

