/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml;

import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.jbpm.bpel.graph.basic.Reply;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.CompositeActivity;
import org.jbpm.bpel.integration.def.PartnerLinkDefinition;
import org.jbpm.bpel.integration.def.ReplyAction;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.wsdl.PartnerLinkType;
import org.jbpm.bpel.xml.ActivityReader;
import org.jbpm.bpel.xml.ParseProblem;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Element;

public class ReplyReader
extends ActivityReader {
    public Activity read(Element element, CompositeActivity parent) {
        Reply reply = new Reply();
        this.readStandardProperties(element, reply, parent);
        this.readReply(element, reply, parent);
        return reply;
    }

    public void readReply(Element replyElem, Reply reply, CompositeActivity parent) {
        reply.setAction(this.readReplyAction(replyElem, parent));
        parent.addNode(reply);
    }

    public ReplyAction readReplyAction(Element replyElem, CompositeActivity parent) {
        Message outgoingMessage;
        ReplyAction replyAction = new ReplyAction();
        String partnerLinkName = replyElem.getAttribute("partnerLink");
        PartnerLinkDefinition partnerLink = parent.findPartnerLink(partnerLinkName);
        if (partnerLink == null) {
            this.bpelReader.getProblemHandler().add(new ParseProblem("partner link not found", replyElem));
            return replyAction;
        }
        replyAction.setPartnerLink(partnerLink);
        PartnerLinkType.Role myRole = partnerLink.getMyRole();
        if (myRole == null) {
            this.bpelReader.getProblemHandler().add(new ParseProblem("partner link does not indicate my role", replyElem));
            return replyAction;
        }
        PortType portType = this.bpelReader.getMessageActivityPortType(replyElem, partnerLink.getMyRole());
        Operation operation = this.bpelReader.getMessageActivityOperation(replyElem, portType);
        if (operation.getStyle() != OperationType.REQUEST_RESPONSE) {
            this.bpelReader.getProblemHandler().add(new ParseProblem("not a request/response operation", replyElem));
            return replyAction;
        }
        replyAction.setOperation(operation);
        String faultPrefixedName = XmlUtil.getAttribute(replyElem, "faultName");
        if (faultPrefixedName != null) {
            QName faultName = XmlUtil.parseQName(faultPrefixedName, replyElem);
            replyAction.setFaultName(faultName);
            Fault fault = operation.getFault(faultName.getLocalPart());
            if (fault == null) {
                this.bpelReader.getProblemHandler().add(new ParseProblem("fault not found", replyElem));
                return replyAction;
            }
            outgoingMessage = fault.getMessage();
        } else {
            outgoingMessage = operation.getOutput().getMessage();
        }
        VariableDefinition variable = this.bpelReader.getMessageActivityVariable(replyElem, "variable", parent, outgoingMessage);
        replyAction.setVariable(variable);
        replyAction.setMessageExchange(XmlUtil.getAttribute(replyElem, "messageExchange"));
        Element correlationsElement = XmlUtil.getElement(replyElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "correlations");
        if (correlationsElement != null) {
            replyAction.setCorrelations(this.bpelReader.readCorrelations(correlationsElement, parent, variable));
        }
        return replyAction;
    }
}

