/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.Use;
import org.jboss.ws.core.server.ServiceEndpointManager;
import org.jboss.ws.core.server.ServiceEndpointManagerFactory;
import org.jboss.ws.core.server.UnifiedDeploymentInfo;
import org.jboss.ws.core.utils.ObjectNameFactory;
import org.jboss.ws.extensions.addressing.AddressingPropertiesImpl;
import org.jboss.ws.extensions.addressing.metadata.AddressingOpMetaExt;
import org.jboss.ws.extensions.eventing.EventingUtils;
import org.jboss.ws.extensions.eventing.deployment.EventingEndpoint;
import org.jboss.ws.extensions.eventing.metadata.EventingEpMetaExt;
import org.jboss.ws.metadata.j2ee.UnifiedApplicationMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedBeanMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedEjbPortComponentMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedMessageDrivenMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedWebMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedWebSecurityMetaData;
import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;

public abstract class MetaDataBuilder {
    private static final Logger log = Logger.getLogger(MetaDataBuilder.class);

    protected void initEndpointBinding(WSDLEndpoint wsdlEndpoint, ClientEndpointMetaData epMetaData) {
        WSDLInterface wsdlInterface;
        WSDLDefinitions wsdlDefinitions = wsdlEndpoint.getWsdlService().getWsdlDefinitions();
        WSDLBinding wsdlBinding = wsdlDefinitions.getBindingByInterfaceName((wsdlInterface = wsdlEndpoint.getInterface()).getName());
        String bindingType = wsdlBinding.getType();
        if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingType)) {
            epMetaData.setBindingId("http://schemas.xmlsoap.org/wsdl/soap/http");
        } else if ("http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingType)) {
            epMetaData.setBindingId("http://www.w3.org/2003/05/soap/bindings/HTTP/");
        }
    }

    protected void initEndpointEncodingStyle(EndpointMetaData epMetaData) {
        WSDLDefinitions wsdlDefinitions = epMetaData.getServiceMetaData().getWsdlDefinitions();
        for (WSDLService wsdlService : wsdlDefinitions.getServices()) {
            for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints()) {
                if (!epMetaData.getPortName().equals(wsdlEndpoint.getName())) continue;
                QName bindQName = wsdlEndpoint.getBinding();
                WSDLBinding wsdlBinding = wsdlDefinitions.getBinding(bindQName);
                if (wsdlBinding == null) {
                    throw new WSException("Cannot obtain binding: " + bindQName);
                }
                for (WSDLBindingOperation wsdlBindingOperation : wsdlBinding.getOperations()) {
                    String encStyle = wsdlBindingOperation.getEncodingStyle();
                    epMetaData.setEncodingStyle(Use.valueOf(encStyle));
                }
            }
        }
    }

    protected void initEndpointAddress(UnifiedDeploymentInfo udi, ServerEndpointMetaData sepMetaData) {
        String contextRoot = sepMetaData.getContextRoot();
        String urlPattern = sepMetaData.getURLPattern();
        String linkName = sepMetaData.getLinkName();
        if (udi.metaData instanceof UnifiedWebMetaData) {
            Map<String, String> servletMappings;
            UnifiedWebMetaData webMetaData = (UnifiedWebMetaData)udi.metaData;
            String jbwebContextRoot = webMetaData.getContextRoot();
            if (jbwebContextRoot != null) {
                contextRoot = jbwebContextRoot;
            }
            if ((urlPattern = (servletMappings = webMetaData.getServletMappings()).get(linkName)) == null) {
                throw new WSException("Cannot obtain url pattern for servlet name: " + linkName);
            }
        }
        if (udi.metaData instanceof UnifiedApplicationMetaData) {
            String pcUrlPattern;
            UnifiedApplicationMetaData applMetaData = (UnifiedApplicationMetaData)udi.metaData;
            UnifiedBeanMetaData beanMetaData = applMetaData.getBeanByEjbName(linkName);
            if (beanMetaData == null) {
                throw new WSException("Cannot obtain meta data for ejb link: " + linkName);
            }
            String wsContextRoot = applMetaData.getWebServiceContextRoot();
            if (wsContextRoot != null) {
                contextRoot = wsContextRoot;
            }
            String ejbClass = beanMetaData.getEjbClass();
            String ejbClassName = WSDLUtils.getJustClassName(ejbClass);
            UnifiedEjbPortComponentMetaData ejbpcMetaData = beanMetaData.getPortComponent();
            if (ejbpcMetaData != null && ejbpcMetaData.getPortComponentURI() != null && (pcUrlPattern = ejbpcMetaData.getPortComponentURI()) != null) {
                urlPattern = pcUrlPattern;
                StringTokenizer st = new StringTokenizer(urlPattern, "/");
                if (contextRoot == null && st.countTokens() > 1) {
                    contextRoot = st.nextToken();
                    urlPattern = st.nextToken();
                    while (st.hasMoreTokens()) {
                        urlPattern = urlPattern + "/" + st.nextToken();
                    }
                }
            }
            if (contextRoot == null) {
                contextRoot = ejbClassName + "Service";
            }
            if (urlPattern == null) {
                urlPattern = ejbClassName;
            }
        }
        if (contextRoot == null) {
            String shortName;
            contextRoot = "/";
            if (udi.parent != null) {
                shortName = udi.parent.simpleName;
                shortName = shortName.substring(0, shortName.indexOf(46));
                contextRoot = contextRoot + shortName + "-";
            }
            shortName = udi.simpleName;
            shortName = shortName.substring(0, shortName.indexOf(46));
            contextRoot = contextRoot + shortName;
        }
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        if (!urlPattern.startsWith("/")) {
            urlPattern = "/" + urlPattern;
        }
        sepMetaData.setContextRoot(contextRoot);
        sepMetaData.setURLPattern(urlPattern);
        String servicePath = contextRoot + urlPattern;
        sepMetaData.setEndpointAddress(MetaDataBuilder.getServiceEndpointAddress(null, servicePath));
    }

    public static ObjectName createServiceEndpointID(UnifiedDeploymentInfo udi, ServerEndpointMetaData sepMetaData) {
        String linkName = sepMetaData.getLinkName();
        String context = sepMetaData.getContextRoot();
        if (context.startsWith("/")) {
            context = context.substring(1);
        }
        StringBuilder idstr = new StringBuilder("jboss.ws:");
        idstr.append("context=" + context);
        idstr.append(",endpoint=" + linkName);
        if (udi.metaData instanceof UnifiedApplicationMetaData) {
            String ejbName = sepMetaData.getLinkName();
            if (ejbName == null) {
                throw new WSException("Cannot obtain ejb-link from port component");
            }
            UnifiedApplicationMetaData applMetaData = (UnifiedApplicationMetaData)udi.metaData;
            UnifiedBeanMetaData beanMetaData = applMetaData.getBeanByEjbName(ejbName);
            if (beanMetaData == null) {
                throw new WSException("Cannot obtain ejb meta data for: " + ejbName);
            }
            if (beanMetaData instanceof UnifiedMessageDrivenMetaData) {
                UnifiedMessageDrivenMetaData mdMetaData = (UnifiedMessageDrivenMetaData)beanMetaData;
                String jndiName = mdMetaData.getDestinationJndiName();
                idstr.append(",jms=" + jndiName);
            }
        }
        return ObjectNameFactory.create(idstr.toString());
    }

    public static String getServiceEndpointAddress(String uriScheme, String servicePath) {
        if (servicePath == null || servicePath.length() == 0) {
            throw new WSException("Service path cannot be null");
        }
        if (servicePath.endsWith("/*")) {
            servicePath = servicePath.substring(0, servicePath.length() - 2);
        }
        if (uriScheme == null) {
            uriScheme = "http";
        }
        ServiceEndpointManagerFactory factory = ServiceEndpointManagerFactory.getInstance();
        ServiceEndpointManager epManager = factory.getServiceEndpointManager();
        String host = epManager.getWebServiceHost();
        int port = epManager.getWebServicePort();
        if ("https".equals(uriScheme)) {
            port = epManager.getWebServiceSecurePort();
        }
        String urlStr = uriScheme + "://" + host + ":" + port + servicePath;
        try {
            return new URL(urlStr).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new WSException("Malformed URL: " + urlStr);
        }
    }

    protected void initTransportGuaranteeJSE(UnifiedDeploymentInfo udi, ServerEndpointMetaData sepMetaData, String servletLink) throws IOException {
        String transportGuarantee = null;
        if (udi.metaData instanceof UnifiedWebMetaData) {
            UnifiedWebMetaData webMetaData = (UnifiedWebMetaData)udi.metaData;
            Map<String, String> servletMappings = webMetaData.getServletMappings();
            String urlPattern = servletMappings.get(servletLink);
            if (urlPattern == null) {
                throw new WSException("Cannot find <url-pattern> for servlet-name: " + servletLink);
            }
            List<UnifiedWebSecurityMetaData> securityList = webMetaData.getSecurityMetaData();
            for (UnifiedWebSecurityMetaData currentSecurity : securityList) {
                if (currentSecurity.getTransportGuarantee() == null || currentSecurity.getTransportGuarantee().length() <= 0) continue;
                for (UnifiedWebSecurityMetaData.UnifiedWebResourceCollection currentCollection : currentSecurity.getWebResources()) {
                    for (String currentUrlPattern : currentCollection.getUrlPatterns()) {
                        if (!urlPattern.equals(currentUrlPattern)) continue;
                        transportGuarantee = currentSecurity.getTransportGuarantee();
                    }
                }
            }
        }
        sepMetaData.setTransportGuarantee(transportGuarantee);
    }

    public static void replaceAddressLocation(ServerEndpointMetaData sepMetaData) {
        WSDLDefinitions wsdlDefinitions = sepMetaData.getServiceMetaData().getWsdlDefinitions();
        QName portName = sepMetaData.getPortName();
        boolean endpointFound = false;
        for (WSDLService wsdlService : wsdlDefinitions.getServices()) {
            for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints()) {
                QName wsdlPortName = wsdlEndpoint.getName();
                if (!wsdlPortName.equals(portName)) continue;
                endpointFound = true;
                String orgAddress = wsdlEndpoint.getAddress();
                String uriScheme = MetaDataBuilder.getUriScheme(orgAddress);
                String transportGuarantee = sepMetaData.getTransportGuarantee();
                if ("CONFIDENTIAL".equals(transportGuarantee)) {
                    uriScheme = "https";
                }
                String servicePath = sepMetaData.getContextRoot() + sepMetaData.getURLPattern();
                String serviceEndpointURL = MetaDataBuilder.getServiceEndpointAddress(uriScheme, servicePath);
                ServiceEndpointManagerFactory factory = ServiceEndpointManagerFactory.getInstance();
                ServiceEndpointManager epManager = factory.getServiceEndpointManager();
                boolean alwaysModify = epManager.isAlwaysModifySOAPAddress();
                if (alwaysModify || uriScheme == null || orgAddress.indexOf("REPLACE_WITH_ACTUAL_URL") >= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Replace service endpoint address '" + orgAddress + "' with '" + serviceEndpointURL + "'"));
                    }
                    wsdlEndpoint.setAddress(serviceEndpointURL);
                    sepMetaData.setEndpointAddress(serviceEndpointURL);
                    if (wsdlDefinitions.getWsdlOneOneDefinition() == null) continue;
                    MetaDataBuilder.replaceWSDL11SOAPAddress(wsdlDefinitions, portName, serviceEndpointURL);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Don't replace service endpoint address '" + orgAddress + "'"));
                }
                try {
                    sepMetaData.setEndpointAddress(new URL(orgAddress).toExternalForm());
                }
                catch (MalformedURLException e) {
                    throw new WSException("Malformed URL: " + orgAddress);
                }
            }
        }
        if (!endpointFound) {
            throw new WSException("Cannot find port in wsdl: " + portName);
        }
    }

    private static void replaceWSDL11SOAPAddress(WSDLDefinitions wsdlDefinitions, QName portQName, String serviceEndpointURL) {
        Definition wsdlOneOneDefinition = wsdlDefinitions.getWsdlOneOneDefinition();
        String tnsURI = wsdlOneOneDefinition.getTargetNamespace();
        Port wsdlOneOnePort = MetaDataBuilder.modifySOAPAddress(tnsURI, portQName, serviceEndpointURL, wsdlOneOneDefinition.getServices());
        if (wsdlOneOnePort == null && !wsdlOneOneDefinition.getImports().isEmpty()) {
            for (List l : wsdlOneOneDefinition.getImports().values()) {
                for (Import anImport : l) {
                    wsdlOneOnePort = MetaDataBuilder.modifySOAPAddress(anImport.getNamespaceURI(), portQName, serviceEndpointURL, anImport.getDefinition().getServices());
                }
            }
        }
        if (wsdlOneOnePort == null) {
            throw new IllegalArgumentException("Cannot find port with name '" + portQName + "' in wsdl document");
        }
    }

    private static Port modifySOAPAddress(String tnsURI, QName portQName, String serviceEndpointURL, Map services) {
        Port wsdlOneOnePort = null;
        for (Service wsdlOneOneService : services.values()) {
            Map wsdlOneOnePorts = wsdlOneOneService.getPorts();
            for (String portLocalName : wsdlOneOnePorts.keySet()) {
                if (!portQName.equals(new QName(tnsURI, portLocalName))) continue;
                wsdlOneOnePort = (Port)wsdlOneOnePorts.get(portLocalName);
                List extElements = wsdlOneOnePort.getExtensibilityElements();
                for (Object extElement : extElements) {
                    SOAPAddress address;
                    if (extElement instanceof SOAPAddress) {
                        address = (SOAPAddress)extElement;
                        address.setLocationURI(serviceEndpointURL);
                    }
                    if (!(extElement instanceof SOAP12Address)) continue;
                    address = (SOAP12Address)extElement;
                    address.setLocationURI(serviceEndpointURL);
                }
            }
        }
        return wsdlOneOnePort;
    }

    private static String getUriScheme(String addrStr) {
        try {
            URI addrURI = new URI(addrStr);
            String scheme = addrURI.getScheme();
            return scheme;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected void processEndpointMetaDataExtensions(EndpointMetaData epMetaData, WSDLDefinitions wsdlDefinitions) {
        for (WSDLInterface wsdlInterface : wsdlDefinitions.getInterfaces()) {
            WSDLProperty eventSourceProp = wsdlInterface.getProperty("http://www.jboss.org/jbossws/wse/isEventSource");
            if (eventSourceProp == null || !(epMetaData instanceof ServerEndpointMetaData)) continue;
            ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)epMetaData;
            String eventSourceNS = wsdlInterface.getName().getNamespaceURI() + "/" + wsdlInterface.getName().getLocalPart();
            JBossXSModel schemaModel = WSDLUtils.getSchemaModel(wsdlDefinitions.getWsdlTypes());
            String[] notificationSchema = EventingUtils.extractNotificationSchema(schemaModel);
            String notificationRootElementNS = null;
            WSDLInterfaceOperation wsdlInterfaceOperation = wsdlInterface.getOperations()[0];
            if (wsdlInterfaceOperation.getOutputs().length <= 0) {
                throw new WSException("Unable to resolve eventing root element NS. No operation output found at " + wsdlInterfaceOperation.getName());
            }
            WSDLInterfaceOperationOutput wsdlInterfaceOperationOutput = wsdlInterfaceOperation.getOutputs()[0];
            notificationRootElementNS = wsdlInterfaceOperationOutput.getElement().getNamespaceURI();
            EventingEpMetaExt ext = new EventingEpMetaExt("http://schemas.xmlsoap.org/ws/2004/08/eventing");
            ext.setEventSourceNS(eventSourceNS);
            ext.setNotificationSchema(notificationSchema);
            ext.setNotificationRootElementNS(notificationRootElementNS);
            sepMetaData.addExtension(ext);
            sepMetaData.setManagedEndpointBean(EventingEndpoint.class.getName());
        }
    }

    protected void processOpMetaExtensions(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation) {
        String tns = wsdlOperation.getName().getNamespaceURI();
        String portTypeName = wsdlOperation.getName().getLocalPart();
        AddressingPropertiesImpl ADDR = new AddressingPropertiesImpl();
        AddressingOpMetaExt addrExt = new AddressingOpMetaExt(ADDR.getNamespaceURI());
        WSDLProperty wsaInAction = wsdlOperation.getProperty("http://www.jboss.org/jbossws/wsa/actionIn");
        if (wsaInAction != null) {
            addrExt.setInboundAction(wsaInAction.getValue());
        } else {
            WSDLProperty messageName = wsdlOperation.getProperty("http://www.jboss.org/jbossws/messagename/in");
            addrExt.setInboundAction(tns + "/" + portTypeName + "/" + messageName);
        }
        WSDLProperty wsaOutAction = wsdlOperation.getProperty("http://www.jboss.org/jbossws/wsa/actionOut");
        if (wsaOutAction != null) {
            addrExt.setOutboundAction(wsaOutAction.getValue());
        } else {
            WSDLProperty messageName = wsdlOperation.getProperty("http://www.jboss.org/jbossws/messagename/out");
            addrExt.setOutboundAction(tns + "/" + portTypeName + "/" + messageName);
        }
        opMetaData.addExtension(addrExt);
    }
}

