/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.helpers;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.core.jaxrpc.Style;
import org.jboss.ws.core.utils.DOMUtils;
import org.jboss.ws.core.utils.DOMWriter;
import org.jboss.ws.core.utils.IOUtils;
import org.jboss.ws.core.utils.JavaUtils;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.JavaToWSDL;
import org.jboss.ws.tools.JavaWriter;
import org.jboss.ws.tools.NamespacePackageMapping;
import org.jboss.ws.tools.WSDLToJava;
import org.jboss.ws.tools.WebservicesXMLCreatorImpl;
import org.jboss.ws.tools.XSDTypeToJava;
import org.jboss.ws.tools.client.ServiceCreator;
import org.jboss.ws.tools.mapping.MappingFileGenerator;
import org.jboss.ws.tools.wsdl.WSDLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolsHelper {
    private static Logger log = Logger.getLogger(ToolsHelper.class);

    public void handleJavaToWSDLGeneration(Configuration config, String outDir) throws IOException {
        Configuration.JavaToWSDLConfig j2wc = config.getJavaToWSDLConfig(false);
        JavaToWSDL jwsdl = new JavaToWSDL("http://schemas.xmlsoap.org/wsdl/");
        jwsdl.setServiceName(j2wc.serviceName);
        jwsdl.setTargetNamespace(j2wc.targetNamespace);
        jwsdl.setTypeNamespace(j2wc.typeNamespace);
        jwsdl.setOperationMap(j2wc.operations);
        if ("document".equals(j2wc.wsdlStyle)) {
            jwsdl.setStyle(Style.DOCUMENT);
        } else if ("rpc".equals(j2wc.wsdlStyle)) {
            jwsdl.setStyle(Style.RPC);
        } else {
            throw new WSException("Unrecognized Style:" + j2wc.wsdlStyle);
        }
        if ("wrapped".equals(j2wc.parameterStyle)) {
            jwsdl.setParameterStyle(SOAPBinding.ParameterStyle.WRAPPED);
        } else if ("bare".equals(j2wc.parameterStyle)) {
            jwsdl.setParameterStyle(SOAPBinding.ParameterStyle.BARE);
        } else {
            throw new WSException("Unrecognized Parameter Style:" + j2wc.parameterStyle);
        }
        Class endpointClass = this.loadClass(j2wc.endpointName);
        if (endpointClass == null) {
            throw new WSException("Endpoint " + j2wc.endpointName + " cannot be loaded");
        }
        Configuration.GlobalConfig gcfg = config.getGlobalConfig(false);
        if (gcfg != null && gcfg.packageNamespaceMap != null) {
            jwsdl.setPackageNamespaceMap(gcfg.packageNamespaceMap);
        }
        WSDLDefinitions wsdl = jwsdl.generate(endpointClass);
        this.createDir(outDir + "/wsdl");
        String wsdlPath = outDir + "/wsdl/" + j2wc.serviceName + ".wsdl";
        Writer fw = IOUtils.getCharsetFileWriter(new File(wsdlPath), "UTF-8");
        new WSDLWriter(wsdl).write(fw, "UTF-8");
        fw.close();
        if (j2wc.mappingFileNeeded) {
            UnifiedMetaData unifiedMetaData = jwsdl.getUnifiedMetaData();
            JavaWsdlMapping mapping = jwsdl.getJavaWsdlMapping();
            this.createWrapperTypes(j2wc, outDir, unifiedMetaData, mapping, endpointClass);
            Writer writer = IOUtils.getCharsetFileWriter(new File(outDir + "/" + j2wc.mappingFileName), "UTF-8");
            writer.write("<?xml version='1.0' encoding='UTF-8'?>");
            writer.write(DOMWriter.printNode(DOMUtils.parse(mapping.serialize()), true));
            writer.close();
        }
        if (j2wc.wsxmlFileNeeded) {
            WebservicesXMLCreatorImpl wscr = new WebservicesXMLCreatorImpl();
            wscr.setTargetNamespace(j2wc.targetNamespace);
            wscr.setSeiName(j2wc.endpointName);
            wscr.setServiceName(j2wc.serviceName);
            WSDLService wsdlService = wsdl.getService(j2wc.serviceName);
            String portName = wsdlService.getEndpoints()[0].getName().getLocalPart();
            wscr.setPortName(portName);
            if (j2wc.servletLink != null) {
                wscr.setMappingFile("WEB-INF/" + j2wc.mappingFileName);
                wscr.setWsdlFile("WEB-INF/wsdl/" + j2wc.serviceName + ".wsdl");
                wscr.setServletLink(j2wc.servletLink);
            } else {
                wscr.setMappingFile("META-INF/" + j2wc.mappingFileName);
                wscr.setWsdlFile("META-INF/wsdl/" + j2wc.serviceName + ".wsdl");
                wscr.setEjbLink(j2wc.ejbLink);
            }
            wscr.setAppend(j2wc.wsxmlFileAppend);
            wscr.generateWSXMLDescriptor(new File(outDir + "/webservices.xml"));
        }
    }

    private void createWrapperTypes(Configuration.JavaToWSDLConfig j2wc, String outDir, UnifiedMetaData wsMetaData, JavaWsdlMapping mapping, Class endpointClass) throws IOException {
        ServiceMetaData service;
        Map<QName, JavaXmlTypeMapping> index = this.indexMappingTypes(mapping);
        EndpointMetaData epMetaData = null;
        Iterator<ServiceMetaData> i$ = wsMetaData.getServices().iterator();
        while (i$.hasNext() && (epMetaData = (service = i$.next()).getEndpointByServiceEndpointInterface(j2wc.endpointName)) == null) {
        }
        if (epMetaData == null) {
            throw new WSException("Could not find endpoint in metadata: " + j2wc.endpointName);
        }
        String packageName = endpointClass.getPackage().getName();
        ClassLoader classLoader = wsMetaData.getClassLoader();
        for (OperationMetaData opMetaData : epMetaData.getOperations()) {
            if (!opMetaData.isDocumentWrapped()) continue;
            for (ParameterMetaData parameter : opMetaData.getParameters()) {
                String name = endpointClass.getSimpleName() + "_" + opMetaData.getQName().getLocalPart() + "_RequestStruct";
                this.createWrapperType(parameter, name, packageName, index, classLoader, outDir);
            }
            ParameterMetaData returnParameter = opMetaData.getReturnParameter();
            if (returnParameter == null) continue;
            String name = endpointClass.getSimpleName() + "_" + opMetaData.getQName().getLocalPart() + "_ResponseStruct";
            this.createWrapperType(returnParameter, name, packageName, index, classLoader, outDir);
        }
    }

    private void createWrapperType(ParameterMetaData parameter, String name, String packageName, Map<QName, JavaXmlTypeMapping> mappingIndex, ClassLoader classLoader, String outDir) throws IOException {
        List<WrappedParameter> wrappedParameters = parameter.getWrappedParameters();
        if (wrappedParameters == null) {
            return;
        }
        ArrayList<XSDTypeToJava.VAR> vars = new ArrayList<XSDTypeToJava.VAR>();
        for (WrappedParameter wrapped : wrappedParameters) {
            String typeName = JavaUtils.convertJVMNameToSourceName(wrapped.getType(), classLoader);
            vars.add(new XSDTypeToJava.VAR(wrapped.getVariable(), typeName, false));
        }
        JavaWriter writer = new JavaWriter();
        writer.createJavaFile(new File(outDir), name + ".java", packageName, vars, null, null, false, null);
        JavaXmlTypeMapping type = mappingIndex.get(parameter.getXmlType());
        if (type == null) {
            throw new WSException("JAX-RPC mapping metadata is missing a wrapper type: " + parameter.getXmlType());
        }
        type.setJavaType(packageName + "." + name);
    }

    private Map<QName, JavaXmlTypeMapping> indexMappingTypes(JavaWsdlMapping mapping) {
        HashMap<QName, JavaXmlTypeMapping> index = new HashMap<QName, JavaXmlTypeMapping>();
        for (JavaXmlTypeMapping type : mapping.getJavaXmlTypeMappings()) {
            QName qname = type.getRootTypeQName();
            if (qname == null) continue;
            index.put(qname, type);
        }
        return index;
    }

    public void handleWSDLToJavaGeneration(Configuration config, String outDir) {
        Configuration.WSDLToJavaConfig w2jc = config.getWSDLToJavaConfig(false);
        Configuration.GlobalConfig glc = config.getGlobalConfig(false);
        WSDLToJava wsdlToJava = new WSDLToJava();
        wsdlToJava.setTypeMapping(new LiteralTypeMapping());
        WSDLDefinitions wsdl = null;
        try {
            File wsdlFile;
            URL wsdlURL = null;
            try {
                wsdlURL = new URL(w2jc.wsdlLocation);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (wsdlURL == null && (wsdlFile = new File(w2jc.wsdlLocation)).exists()) {
                wsdlURL = wsdlFile.toURL();
            }
            if (wsdlURL == null) {
                ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
                wsdlURL = ctxLoader.getResource(w2jc.wsdlLocation);
            }
            if (wsdlURL == null) {
                throw new IllegalArgumentException("Cannot load wsdl: " + w2jc.wsdlLocation);
            }
            wsdl = wsdlToJava.convertWSDL2Java(wsdlURL);
            if (glc != null) {
                wsdlToJava.setNamespacePackageMap(glc.packageNamespaceMap);
            }
            wsdlToJava.setParameterStyle(w2jc.parameterStyle);
            wsdlToJava.generateSEI(wsdl, new File(outDir));
            this.generateServiceFile(this.getPackageName(wsdl, glc), wsdl, outDir);
            if (w2jc.mappingFileNeeded) {
                MappingFileGenerator mgf = new MappingFileGenerator(wsdl, new LiteralTypeMapping());
                mgf.setPackageName(this.getPackageName(wsdl, glc));
                mgf.setServiceName(wsdl.getServices()[0].getName().getLocalPart());
                mgf.setParameterStyle(w2jc.parameterStyle);
                JavaWsdlMapping jwm = mgf.generate();
                Writer writer = IOUtils.getCharsetFileWriter(new File(outDir + "/" + w2jc.mappingFileName), "UTF-8");
                writer.write("<?xml version='1.0' encoding='UTF-8'?>");
                writer.write(DOMWriter.printNode(DOMUtils.parse(jwm.serialize()), true));
                writer.close();
            }
            if (w2jc.wsxmlFileNeeded) {
                String seiName = "mypackage.MyServiceEndpointInterface";
                String serviceName = "MyServiceName";
                if (wsdl.getServices().length == 1) {
                    serviceName = wsdl.getServices()[0].getName().getLocalPart();
                }
                if (wsdl.getInterfaces().length == 1) {
                    String seiPackage = this.getPackageName(wsdl, glc);
                    seiName = seiPackage + "." + wsdlToJava.getServiceEndpointInterfaceName(wsdl.getInterfaces()[0]);
                }
                WebservicesXMLCreatorImpl wscr = new WebservicesXMLCreatorImpl();
                wscr.setTargetNamespace(wsdl.getTargetNamespace());
                wscr.setSeiName(seiName);
                wscr.setServiceName(serviceName);
                WSDLService wsdlService = wsdl.getService(serviceName);
                String portName = wsdlService.getEndpoints()[0].getName().getLocalPart();
                wscr.setPortName(portName);
                String wsdlShortName = wsdlURL.getPath();
                wsdlShortName = wsdlShortName.substring(wsdlShortName.lastIndexOf("/"));
                if (w2jc.servletLink != null) {
                    wscr.setMappingFile("WEB-INF/" + w2jc.mappingFileName);
                    wscr.setWsdlFile("WEB-INF/wsdl" + wsdlShortName);
                    wscr.setServletLink(w2jc.servletLink);
                } else {
                    wscr.setMappingFile("META-INF/" + w2jc.mappingFileName);
                    wscr.setWsdlFile("META-INF/wsdl" + wsdlShortName);
                    wscr.setEjbLink(w2jc.ejbLink);
                }
                wscr.generateWSXMLDescriptor(new File(outDir + "/webservices.xml"));
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException(ex);
        }
    }

    private Class loadClass(String cls) {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(cls);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Cannot load endpoint:" + e.getLocalizedMessage()));
        }
        return clazz;
    }

    private void generateServiceFile(String packageName, WSDLDefinitions wsdl, String location) throws IOException {
        ServiceCreator sc = new ServiceCreator();
        sc.setPackageName(packageName);
        sc.setDirLocation(new File(location));
        sc.setWsdl(wsdl);
        sc.createServiceDescriptor();
    }

    private String getPackageName(WSDLDefinitions wsdl, Configuration.GlobalConfig glc) {
        String targetNamespace = wsdl.getTargetNamespace();
        if (glc != null && glc.packageNamespaceMap != null) {
            Map<String, String> map = glc.packageNamespaceMap;
            for (String pkg : map.keySet()) {
                String ns = map.get(pkg);
                if (!ns.equals(targetNamespace)) continue;
                return pkg;
            }
        }
        return NamespacePackageMapping.getJavaPackageName(wsdl.getTargetNamespace());
    }

    private void createDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }
}

