/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.jaxws.command;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.ws.tools.jaxws.api.WSContractConsumer;

public class wsconsume {
    private List<File> bindingFiles = new ArrayList<File>();
    private boolean generateSource = false;
    private File catalog = null;
    private String targetPackage = null;
    private String wsdlLocation = null;
    private boolean quiet = false;
    private boolean showTraces = false;
    private File outputDir = new File("output");
    private File sourceDir = null;
    public static String PROGRAM_NAME = System.getProperty("program.name", wsconsume.class.getName());

    public static void main(String[] args) {
        wsconsume importer = new wsconsume();
        URL wsdl = importer.parseArguments(args);
        System.exit(importer.importServices(wsdl));
    }

    private URL parseArguments(String[] args) {
        int c;
        String shortOpts = "hb:kc:p:w:o:s:qt";
        LongOpt[] longOpts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("binding", 1, null, 98), new LongOpt("keep", 0, null, 107), new LongOpt("catalog", 1, null, 99), new LongOpt("package", 1, null, 112), new LongOpt("wsdlLocation", 1, null, 119), new LongOpt("output", 1, null, 111), new LongOpt("source", 1, null, 115), new LongOpt("quiet", 0, null, 113), new LongOpt("show-traces", 0, null, 116)};
        Getopt getopt = new Getopt(PROGRAM_NAME, args, shortOpts, longOpts);
        while ((c = getopt.getopt()) != -1) {
            switch (c) {
                case 98: {
                    this.bindingFiles.add(new File(getopt.getOptarg()));
                    break;
                }
                case 107: {
                    this.generateSource = true;
                    break;
                }
                case 99: {
                    this.catalog = new File(getopt.getOptarg());
                    break;
                }
                case 112: {
                    this.targetPackage = getopt.getOptarg();
                    break;
                }
                case 119: {
                    this.wsdlLocation = getopt.getOptarg();
                    break;
                }
                case 111: {
                    this.outputDir = new File(getopt.getOptarg());
                    break;
                }
                case 115: {
                    this.sourceDir = new File(getopt.getOptarg());
                    break;
                }
                case 113: {
                    this.quiet = true;
                    break;
                }
                case 116: {
                    this.showTraces = true;
                    break;
                }
                case 104: {
                    wsconsume.printHelp();
                    System.exit(0);
                }
                case 63: {
                    System.exit(1);
                }
            }
        }
        int wsdlPos = getopt.getOptind();
        if (wsdlPos >= args.length) {
            System.err.println("Error: WSDL URL was not specified!");
            wsconsume.printHelp();
            System.exit(1);
        }
        URL url = null;
        try {
            try {
                url = new URL(args[wsdlPos]);
            }
            catch (MalformedURLException e) {
                File file = new File(args[wsdlPos]);
                url = file.toURL();
            }
        }
        catch (MalformedURLException e) {
            System.err.println("Error: Invalid URI: " + args[wsdlPos]);
            System.exit(1);
        }
        return url;
    }

    private int importServices(URL wsdl) {
        WSContractConsumer importer = WSContractConsumer.newInstance();
        importer.setGenerateSource(this.generateSource);
        importer.setOutputDirectory(this.outputDir);
        if (this.sourceDir != null) {
            importer.setSourceDirectory(this.sourceDir);
        }
        if (!this.quiet) {
            importer.setMessageStream(System.out);
        }
        if (this.catalog != null) {
            importer.setCatalog(this.catalog);
        }
        if (this.targetPackage != null) {
            importer.setTargetPackage(this.targetPackage);
        }
        if (this.wsdlLocation != null) {
            importer.setWsdlLocation(this.wsdlLocation);
        }
        if (this.bindingFiles != null && this.bindingFiles.size() > 0) {
            importer.setBindingFiles(this.bindingFiles);
        }
        try {
            importer.consume(wsdl);
            return 0;
        }
        catch (Throwable t) {
            System.err.println("Error: Could not import. (use --show-traces to see full traces)");
            if (!this.showTraces) {
                String message = t.getMessage();
                if (message == null) {
                    message = t.getClass().getSimpleName();
                }
                System.err.println("Error: " + message);
            } else {
                t.printStackTrace(System.err);
            }
            return 1;
        }
    }

    private static void printHelp() {
        PrintStream out = System.out;
        out.println("wsconsume is a command line tool that generates portable JAX-WS artifacts from a WSDL file.\n");
        out.println("usage: " + PROGRAM_NAME + " [options] <wsdl-url>\n");
        out.println("options: ");
        out.println("    -h, --help                  Show this help message");
        out.println("    -b, --binding=<file>        One or more JAX-WS or JAXB binding files ");
        out.println("    -k, --keep                  Keep/Generate Java source");
        out.println("    -c  --catalog=<file>        Oasis XML Catalog file for entity resolution");
        out.println("    -p  --package=<name>        The target package for generated source");
        out.println("    -w  --wsdlLocation=<loc>    Value to use for @WebService.wsdlLocation");
        out.println("    -o, --output=<directory>    The directory to put generated artifacts");
        out.println("    -s, --source=<directory>    The directory to put Java source");
        out.println("    -q, --quiet                 Be somewhat more quiet");
        out.println("    -t, --show-traces           Show full exception stack traces");
        out.flush();
    }
}

