/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.fileupload.DefaultFileItem;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MultipartStream;

public class FileUpload {
    public static final String CONTENT_TYPE = "Content-type";
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    private static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final int MAX_HEADER_SIZE = 1024;
    private int sizeMax;
    private int sizeThreshold;
    private String repositoryPath;
    private String fileItemClassName = "org.apache.commons.fileupload.DefaultFileItem";
    private Method newInstanceMethod;
    static /* synthetic */ Class class$java$lang$String;

    public int getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(int sizeMax) {
        this.sizeMax = sizeMax;
    }

    public int getSizeThreshold() {
        return this.sizeThreshold;
    }

    public void setSizeThreshold(int sizeThreshold) {
        this.sizeThreshold = sizeThreshold;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public String getFileItemClassName() {
        return this.fileItemClassName;
    }

    public void setFileItemClassName(String fileItemClassName) {
        this.fileItemClassName = fileItemClassName;
        this.newInstanceMethod = null;
    }

    public List parseRequest(HttpServletRequest req) throws FileUploadException {
        return this.parseRequest(req, this.getSizeThreshold(), this.getSizeMax(), this.getRepositoryPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List parseRequest(HttpServletRequest req, int sizeThreshold, int sizeMax, String path) throws FileUploadException {
        ArrayList<FileItem> items = new ArrayList<FileItem>();
        String contentType = req.getHeader(CONTENT_TYPE);
        if (!contentType.startsWith(MULTIPART)) {
            throw new FileUploadException("the request doesn't contain a multipart/form-data or multipart/mixed stream");
        }
        int requestSize = req.getContentLength();
        if (requestSize == -1) {
            throw new FileUploadException("the request was rejected because it's size is unknown");
        }
        if (sizeMax >= 0 && requestSize > sizeMax) {
            throw new FileUploadException("the request was rejected because it's size exceeds allowed range");
        }
        try {
            byte[] boundary = contentType.substring(contentType.indexOf("boundary=") + 9).getBytes();
            ServletInputStream input = req.getInputStream();
            MultipartStream multi = new MultipartStream((InputStream)input, boundary);
            boolean nextPart = multi.skipPreamble();
            while (nextPart) {
                Map headers = this.parseHeaders(multi.readHeaders());
                String fieldName = this.getFieldName(headers);
                if (fieldName != null) {
                    FileItem item;
                    String subContentType = this.getHeader(headers, CONTENT_TYPE);
                    if (subContentType != null && subContentType.startsWith(MULTIPART_MIXED)) {
                        byte[] subBoundary = subContentType.substring(subContentType.indexOf("boundary=") + 9).getBytes();
                        multi.setBoundary(subBoundary);
                        boolean nextSubPart = multi.skipPreamble();
                        while (nextSubPart) {
                            headers = this.parseHeaders(multi.readHeaders());
                            if (this.getFileName(headers) != null) {
                                Object var20_22;
                                FileItem item2 = this.createItem(sizeThreshold, path, headers, requestSize);
                                OutputStream os = ((DefaultFileItem)item2).getOutputStream();
                                try {
                                    multi.readBodyData(os);
                                    var20_22 = null;
                                }
                                catch (Throwable throwable) {
                                    var20_22 = null;
                                    os.close();
                                    throw throwable;
                                }
                                os.close();
                                item2.setFieldName(this.getFieldName(headers));
                                items.add(item2);
                            } else {
                                multi.discardBodyData();
                            }
                            nextSubPart = multi.readBoundary();
                        }
                        multi.setBoundary(boundary);
                    } else if (this.getFileName(headers) != null) {
                        Object var22_23;
                        item = this.createItem(sizeThreshold, path, headers, requestSize);
                        OutputStream os = ((DefaultFileItem)item).getOutputStream();
                        try {
                            multi.readBodyData(os);
                            var22_23 = null;
                        }
                        catch (Throwable throwable) {
                            var22_23 = null;
                            os.close();
                            throw throwable;
                        }
                        os.close();
                        item.setFieldName(this.getFieldName(headers));
                        items.add(item);
                    } else {
                        Object var24_24;
                        item = this.createItem(sizeThreshold, path, headers, requestSize);
                        OutputStream os = ((DefaultFileItem)item).getOutputStream();
                        try {
                            multi.readBodyData(os);
                            var24_24 = null;
                        }
                        catch (Throwable throwable) {
                            var24_24 = null;
                            os.close();
                            throw throwable;
                        }
                        os.close();
                        item.setFieldName(this.getFieldName(headers));
                        item.setIsFormField(true);
                        items.add(item);
                    }
                } else {
                    multi.discardBodyData();
                }
                nextPart = multi.readBoundary();
            }
        }
        catch (IOException e) {
            throw new FileUploadException("Processing of multipart/form-data request failed. " + e.getMessage());
        }
        return items;
    }

    protected String getFileName(Map headers) {
        String fileName = null;
        String cd = this.getHeader(headers, CONTENT_DISPOSITION);
        if (cd.startsWith(FORM_DATA) || cd.startsWith(ATTACHMENT)) {
            int start = cd.indexOf("filename=\"");
            int end = cd.indexOf(34, start + 10);
            if (start != -1 && end != -1) {
                fileName = cd.substring(start + 10, end).trim();
            }
        }
        return fileName;
    }

    protected String getFieldName(Map headers) {
        String fieldName = null;
        String cd = this.getHeader(headers, CONTENT_DISPOSITION);
        if (cd != null && cd.startsWith(FORM_DATA)) {
            int start = cd.indexOf("name=\"");
            int end = cd.indexOf(34, start + 6);
            if (start != -1 && end != -1) {
                fieldName = cd.substring(start + 6, end);
            }
        }
        return fieldName;
    }

    protected FileItem createItem(int sizeThreshold, String path, Map headers, int requestSize) throws FileUploadException {
        Method newInstanceMethod = this.getNewInstanceMethod();
        Object[] args = new Object[]{path, this.getFileName(headers), this.getHeader(headers, CONTENT_TYPE), new Integer(requestSize), new Integer(sizeThreshold)};
        FileItem fileItem = null;
        try {
            fileItem = (FileItem)newInstanceMethod.invoke(null, args);
        }
        catch (Exception e) {
            throw new FileUploadException(e.toString());
        }
        return fileItem;
    }

    protected Method getNewInstanceMethod() throws FileUploadException {
        if (this.newInstanceMethod != null) {
            return this.newInstanceMethod;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> fileItemClass = null;
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            fileItemClass = classLoader.loadClass(this.fileItemClassName);
        }
        catch (Exception e) {
            throw new FileUploadException(e.toString());
        }
        if (fileItemClass == null) {
            throw new FileUploadException("Failed to load FileItem class: " + this.fileItemClassName);
        }
        Class[] parameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = FileUpload.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = FileUpload.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = FileUpload.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Integer.TYPE};
        Method newInstanceMethod = MethodUtils.getAccessibleMethod(fileItemClass, (String)"newInstance", (Class[])parameterTypes);
        if (newInstanceMethod == null) {
            throw new FileUploadException("Failed find newInstance() method in FileItem class: " + this.fileItemClassName);
        }
        this.newInstanceMethod = newInstanceMethod;
        return newInstanceMethod;
    }

    protected Map parseHeaders(String headerPart) {
        HashMap<String, String> headers = new HashMap<String, String>();
        char[] buffer = new char[1024];
        boolean done = false;
        int j = 0;
        try {
            while (!done) {
                int i = 0;
                while (i < 2 || buffer[i - 2] != '\r' || buffer[i - 1] != '\n') {
                    buffer[i++] = headerPart.charAt(j++);
                }
                String header = new String(buffer, 0, i - 2);
                if (header.equals("")) {
                    done = true;
                    continue;
                }
                if (header.indexOf(58) == -1) continue;
                String headerName = header.substring(0, header.indexOf(58)).trim().toLowerCase();
                String headerValue = header.substring(header.indexOf(58) + 1).trim();
                if (this.getHeader(headers, headerName) != null) {
                    headers.put(headerName, this.getHeader(headers, headerName) + ',' + headerValue);
                    continue;
                }
                headers.put(headerName, headerValue);
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        return headers;
    }

    protected final String getHeader(Map headers, String name) {
        return (String)headers.get(name.toLowerCase());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CONTENT_TYPE = CONTENT_TYPE;
        CONTENT_DISPOSITION = CONTENT_DISPOSITION;
        FORM_DATA = FORM_DATA;
        ATTACHMENT = ATTACHMENT;
        MULTIPART = MULTIPART;
        MULTIPART_FORM_DATA = MULTIPART_FORM_DATA;
        MULTIPART_MIXED = MULTIPART_MIXED;
        MAX_HEADER_SIZE = 1024;
    }
}

