/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.message;

import java.util.Enumeration;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class MessageTypeTest
extends PTPTestCase {
    static /* synthetic */ Class class$org$objectweb$jtests$jms$conform$message$MessageTypeTest;

    public void testStreamMessage_2() {
        try {
            StreamMessage message = this.senderSession.createStreamMessage();
            message.writeString("pi");
            message.writeDouble(3.14159);
            this.sender.send((Message)message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            MessageTypeTest.assertTrue((String)"The message should be an instance of StreamMessage.\n", (boolean)(m instanceof StreamMessage));
            StreamMessage msg = (StreamMessage)m;
            MessageTypeTest.assertEquals((String)"pi", (String)msg.readString());
            MessageTypeTest.assertEquals((double)3.14159, (double)msg.readDouble(), (double)0.0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testStreamMessage_1() {
        try {
            StreamMessage message = this.senderSession.createStreamMessage();
            this.sender.send((Message)message);
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            MessageTypeTest.assertTrue((String)"The message should be an instance of StreamMessage.\n", (boolean)(msg instanceof StreamMessage));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testMapMessageConversion() {
        try {
            MapMessage message = this.senderSession.createMapMessage();
            message.setDouble("pi", 3.14159);
            this.sender.send((Message)message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            MessageTypeTest.assertTrue((String)"The message should be an instance of MapMessage.\n", (boolean)(m instanceof MapMessage));
            MapMessage msg = (MapMessage)m;
            MessageTypeTest.assertTrue((boolean)(msg.getObject("pi") instanceof Double));
            MessageTypeTest.assertEquals((double)3.14159, (double)((Double)msg.getObject("pi")), (double)0.0);
            MessageTypeTest.assertEquals((double)3.14159, (double)msg.getDouble("pi"), (double)0.0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testNullInSetMethodsForMapMessage() {
        try {
            MapMessage message = this.senderSession.createMapMessage();
            message.setBoolean(null, true);
            MessageTypeTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (JMSException e) {
            MessageTypeTest.fail((String)("Should throw an IllegalArgumentException, not a" + (Object)((Object)e)));
        }
    }

    public void testEmptyStringInSetMethodsForMapMessage() {
        try {
            MapMessage message = this.senderSession.createMapMessage();
            message.setBoolean("", true);
            MessageTypeTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (JMSException e) {
            MessageTypeTest.fail((String)("Should throw an IllegalArgumentException, not a" + (Object)((Object)e)));
        }
    }

    public void testgetMapNames() {
        try {
            MapMessage message = this.senderSession.createMapMessage();
            Enumeration e = message.getMapNames();
            MessageTypeTest.assertTrue((String)"No map yet defined.\n", (!e.hasMoreElements() ? 1 : 0) != 0);
            message.setDouble("pi", 3.14159);
            e = message.getMapNames();
            MessageTypeTest.assertEquals((String)"pi", (String)((String)e.nextElement()));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testMapMessage_2() {
        try {
            MapMessage message = this.senderSession.createMapMessage();
            message.setString("name", "pi");
            message.setDouble("value", 3.14159);
            this.sender.send((Message)message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            MessageTypeTest.assertTrue((String)"The message should be an instance of MapMessage.\n", (boolean)(m instanceof MapMessage));
            MapMessage msg = (MapMessage)m;
            MessageTypeTest.assertEquals((String)"pi", (String)msg.getString("name"));
            MessageTypeTest.assertEquals((double)3.14159, (double)msg.getDouble("value"), (double)0.0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testMapMessage_1() {
        try {
            MapMessage message = this.senderSession.createMapMessage();
            this.sender.send((Message)message);
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            MessageTypeTest.assertTrue((String)"The message should be an instance of MapMessage.\n", (boolean)(msg instanceof MapMessage));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testObjectMessage_2() {
        try {
            Vector<Object> vector = new Vector<Object>();
            vector.add("pi");
            vector.add(new Double(3.14159));
            ObjectMessage message = this.senderSession.createObjectMessage();
            message.setObject(vector);
            this.sender.send((Message)message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            MessageTypeTest.assertTrue((String)"The message should be an instance of ObjectMessage.\n", (boolean)(m instanceof ObjectMessage));
            ObjectMessage msg = (ObjectMessage)m;
            MessageTypeTest.assertEquals(vector, (Object)msg.getObject());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testObjectMessage_1() {
        try {
            ObjectMessage message = this.senderSession.createObjectMessage();
            this.sender.send((Message)message);
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            MessageTypeTest.assertTrue((String)"The message should be an instance of ObjectMessage.\n", (boolean)(msg instanceof ObjectMessage));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBytesMessage_2() {
        try {
            byte[] bytes = new String("pi").getBytes();
            BytesMessage message = this.senderSession.createBytesMessage();
            message.writeBytes(bytes);
            message.writeDouble(3.14159);
            this.sender.send((Message)message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            MessageTypeTest.assertTrue((String)"The message should be an instance of BytesMessage.\n", (boolean)(m instanceof BytesMessage));
            BytesMessage msg = (BytesMessage)m;
            byte[] receivedBytes = new byte[bytes.length];
            msg.readBytes(receivedBytes);
            MessageTypeTest.assertEquals((String)new String(bytes), (String)new String(receivedBytes));
            MessageTypeTest.assertEquals((double)3.14159, (double)msg.readDouble(), (double)0.0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBytesMessage_1() {
        try {
            BytesMessage message = this.senderSession.createBytesMessage();
            this.sender.send((Message)message);
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            MessageTypeTest.assertTrue((String)"The message should be an instance of BytesMessage.\n", (boolean)(msg instanceof BytesMessage));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testTextMessage_2() {
        try {
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testTextMessage_2");
            this.sender.send((Message)message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            MessageTypeTest.assertTrue((String)"The message should be an instance of TextMessage.\n", (boolean)(m instanceof TextMessage));
            TextMessage msg = (TextMessage)m;
            MessageTypeTest.assertEquals((String)"testTextMessage_2", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testTextMessage_1() {
        try {
            TextMessage message = this.senderSession.createTextMessage();
            this.sender.send((Message)message);
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            MessageTypeTest.assertTrue((String)"The message should be an instance of TextMessage.\n", (boolean)(msg instanceof TextMessage));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$objectweb$jtests$jms$conform$message$MessageTypeTest == null ? (class$org$objectweb$jtests$jms$conform$message$MessageTypeTest = MessageTypeTest.class$("org.objectweb.jtests.jms.conform.message.MessageTypeTest")) : class$org$objectweb$jtests$jms$conform$message$MessageTypeTest);
    }

    public MessageTypeTest(String name) {
        super(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

