/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.encoding.soap.server;

import com.sun.xml.bind.api.BridgeContext;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.handler.MessageContext;
import org.jboss.com.sun.xml.ws.encoding.JAXWSAttachmentMarshaller;
import org.jboss.com.sun.xml.ws.encoding.jaxb.JAXBBridgeInfo;
import org.jboss.com.sun.xml.ws.encoding.soap.SOAPConstants;
import org.jboss.com.sun.xml.ws.encoding.soap.SOAPEncoder;
import org.jboss.com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import org.jboss.com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import org.jboss.com.sun.xml.ws.handler.MessageContextUtil;
import org.jboss.com.sun.xml.ws.pept.ept.MessageInfo;
import org.jboss.com.sun.xml.ws.server.RuntimeContext;
import org.jboss.com.sun.xml.ws.server.ServerRtException;
import org.jboss.com.sun.xml.ws.streaming.DOMStreamReader;
import org.jboss.com.sun.xml.ws.streaming.XMLStreamWriterFactory;
import org.jboss.com.sun.xml.ws.util.ByteArrayBuffer;
import org.jboss.com.sun.xml.ws.util.MessageInfoUtil;
import org.jboss.com.sun.xml.ws.util.SOAPUtil;
import org.w3c.dom.Node;

public class SOAPXMLEncoder
extends SOAPEncoder {
    protected static final String FAULTCODE_NAME = "faultcode";
    protected static final String FAULTSTRING_NAME = "faultstring";
    protected static final String FAULTACTOR_NAME = "faultactor";
    protected static final String DETAIL_NAME = "detail";

    public SOAPMessage toSOAPMessage(InternalMessage response, MessageInfo messageInfo) {
        XMLStreamWriter writer = null;
        JAXWSAttachmentMarshaller marshaller = null;
        boolean xopEnabled = false;
        try {
            this.setAttachmentsMap(messageInfo, response);
            ByteArrayBuffer bab = new ByteArrayBuffer();
            if (messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation") == "optimistic") {
                writer = XMLStreamWriterFactory.createFIStreamWriter(bab);
                marshaller = this.getAttachmentMarshaller(messageInfo);
                if (marshaller != null) {
                    xopEnabled = marshaller.isXOPPackage();
                    marshaller.setXOPPackage(false);
                }
            } else {
                messageInfo.setMetaData("com.sun.xml.bind.api.Bridge.outputStream", bab);
                writer = XMLStreamWriterFactory.createXMLStreamWriter(bab);
            }
            writer.writeStartDocument();
            this.startEnvelope(writer);
            this.writeEnvelopeNamespaces(writer, messageInfo);
            this.writeHeaders(writer, response, messageInfo);
            this.writeBody(writer, response, messageInfo);
            this.endEnvelope(writer);
            writer.writeEndDocument();
            writer.close();
            MimeHeaders mh = new MimeHeaders();
            mh.addHeader("Content-Type", this.getContentType(messageInfo, marshaller));
            SOAPMessage msg = SOAPUtil.createMessage(mh, bab.newInputStream(), this.getBindingId());
            this.processAttachments(response, msg);
            if (marshaller != null) {
                marshaller.setXOPPackage(xopEnabled);
            }
            SOAPMessage sOAPMessage = msg;
            return sOAPMessage;
        }
        catch (Exception e) {
            throw new ServerRtException("soapencoder.err", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException e) {
                    throw new ServerRtException(e);
                }
            }
        }
    }

    protected JAXWSAttachmentMarshaller getAttachmentMarshaller(MessageInfo messageInfo) {
        BridgeContext bc;
        Object rtc = messageInfo.getMetaData("org.jboss.com.sun.xml.ws.runtime.context");
        if (rtc != null && (bc = ((RuntimeContext)rtc).getBridgeContext()) != null) {
            return (JAXWSAttachmentMarshaller)bc.getAttachmentMarshaller();
        }
        return null;
    }

    protected String getContentType(MessageInfo messageInfo, JAXWSAttachmentMarshaller marshaller) {
        String contentNegotiation = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        if (marshaller == null) {
            marshaller = this.getAttachmentMarshaller(messageInfo);
        }
        if (marshaller != null && marshaller.isXopped()) {
            return "application/xop+xml;type=\"text/xml\"";
        }
        return contentNegotiation == "optimistic" ? "application/fastinfoset" : "text/xml";
    }

    protected void writeFault(SOAPFaultInfo instance, MessageInfo messageInfo, XMLStreamWriter writer) {
        try {
            Object detail;
            MessageContext ctxt = MessageInfoUtil.getMessageContext(messageInfo);
            if (MessageContextUtil.getHttpStatusCode(ctxt) == null) {
                MessageContextUtil.setHttpStatusCode(ctxt, 500);
            }
            writer.writeStartElement("soapenv", SOAPConstants.QNAME_SOAP_FAULT.getLocalPart(), SOAPConstants.QNAME_SOAP_FAULT.getNamespaceURI());
            writer.writeNamespace("soapenv", SOAPConstants.QNAME_SOAP_FAULT.getNamespaceURI());
            writer.writeStartElement(FAULTCODE_NAME);
            String prefix = "soapenv";
            QName faultCode = instance.getCode();
            String nsURI = faultCode.getNamespaceURI();
            if (!nsURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                if (nsURI.equals("")) {
                    prefix = "";
                } else {
                    prefix = faultCode.getPrefix();
                    if (prefix.equals("")) {
                        prefix = "ans";
                    }
                    writer.setPrefix(prefix, nsURI);
                    writer.writeNamespace(prefix, nsURI);
                }
            }
            if (prefix.equals("")) {
                writer.writeCharacters(instance.getCode().getLocalPart());
            } else {
                writer.writeCharacters(prefix + ":" + instance.getCode().getLocalPart());
            }
            writer.writeEndElement();
            writer.writeStartElement(FAULTSTRING_NAME);
            writer.writeCharacters(instance.getString());
            writer.writeEndElement();
            if (instance.getActor() != null) {
                writer.writeStartElement(FAULTACTOR_NAME);
                writer.writeCharacters(instance.getActor());
                writer.writeEndElement();
            }
            if ((detail = instance.getDetail()) != null) {
                if (detail instanceof Detail) {
                    this.encodeDetail((Detail)detail, writer);
                } else if (detail instanceof JAXBBridgeInfo) {
                    writer.writeStartElement(DETAIL_NAME);
                    this.writeJAXBBridgeInfo((JAXBBridgeInfo)detail, messageInfo, writer);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new ServerRtException(e);
        }
    }

    protected void encodeDetail(Detail detail, XMLStreamWriter writer) {
        SOAPXMLEncoder.serializeReader(new DOMStreamReader((Node)detail), writer);
    }

    protected String getBindingId() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }
}

