/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.AttributesImpl;
import org.jboss.xb.binding.ContentWriter;
import org.jboss.xb.binding.ObjectModelBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Content {
    private static Logger log = Logger.getLogger((Class)Content.class);
    private List content = new ArrayList();
    private final boolean trace = log.isTraceEnabled();
    private int index;

    public String getChildContent(String namespaceURI, String qName) {
        StartElement current = (StartElement)this.content.get(this.index);
        boolean lookingForStart = true;
        StartElement start = null;
        boolean childFound = false;
        StringBuffer value = new StringBuffer();
        int i = this.index + 1;
        Object next = this.content.get(i++);
        while (!current.isMyEnd(next)) {
            if (lookingForStart) {
                if (next instanceof StartElement) {
                    start = (StartElement)next;
                    lookingForStart = false;
                    if (qName.equals(start.qName) && (namespaceURI == null ? start.namespaceURI == null : namespaceURI.equals(start.namespaceURI))) {
                        childFound = true;
                    }
                }
            } else if (next instanceof EndElement) {
                if (start.isMyEnd(next)) {
                    if (childFound) break;
                    lookingForStart = true;
                }
            } else if (childFound && next instanceof Characters) {
                Characters chars = (Characters)next;
                value.append(chars.ch, chars.start, chars.length);
            }
            next = this.content.get(i++);
        }
        return value.toString().trim();
    }

    public void handleContent(ContentHandler handler) throws SAXException {
        handler.startDocument();
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (item instanceof StartElement) {
                StartElement start = (StartElement)item;
                handler.startElement(start.namespaceURI, start.localName, start.qName, start.attrs);
                continue;
            }
            if (item instanceof EndElement) {
                EndElement end = (EndElement)item;
                handler.endElement(end.namespaceURI, end.localName, end.qName);
                continue;
            }
            if (item instanceof Characters) {
                Characters ch = (Characters)item;
                handler.characters(ch.ch, ch.start, ch.length);
                continue;
            }
            if (item instanceof StartPrefixMapping || item instanceof EndPrefixMapping) continue;
            throw new IllegalStateException("Unexpected element type: " + item);
        }
        handler.endDocument();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            ContentWriter contentWriter = new ContentWriter(writer, true);
            this.handleContent(contentWriter);
        }
        catch (SAXException e) {
            writer.write(e.getMessage());
        }
        return writer.getBuffer().toString();
    }

    public void startDocument() {
        this.content.clear();
    }

    public void endDocument() {
    }

    public void startPrefixMapping(String prefix, String uri) {
        StartPrefixMapping node = new StartPrefixMapping(prefix, uri);
        this.content.add(node);
    }

    public void endPrefixMapping(String prefix) {
        EndPrefixMapping node = new EndPrefixMapping(prefix);
        this.content.add(node);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        StartElement startElement = new StartElement(namespaceURI, localName, qName, atts);
        this.content.add(startElement);
        if (this.trace) {
            log.trace((Object)("startElement> uri=" + namespaceURI + ", local=" + localName + ", qn=" + qName + ", attrs=" + atts));
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        EndElement endElement = new EndElement(namespaceURI, localName, qName);
        this.content.add(endElement);
        if (this.trace) {
            log.trace((Object)("endElement> uri=" + namespaceURI + ", local=" + localName + ", qn=" + qName));
        }
    }

    public void characters(char[] ch, int start, int length) {
        Characters characters = new Characters(ch, start, length);
        if (characters.toString().trim().length() > 0) {
            this.content.add(characters);
            if (this.trace) {
                log.trace((Object)("characters> " + characters));
            }
        }
    }

    public void append(Content content) {
        Iterator i = content.content.iterator();
        while (i.hasNext()) {
            this.content.add(i.next());
        }
    }

    public static class EndPrefixMapping
    implements Node {
        public final String prefix;

        public EndPrefixMapping(String prefix) {
            this.prefix = prefix;
        }

        public void read(ObjectModelBuilder builder) {
            builder.endPrefixMapping(this.prefix);
        }
    }

    public static class StartPrefixMapping
    implements Node {
        public final String prefix;
        public final String uri;

        public StartPrefixMapping(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        public void read(ObjectModelBuilder builder) {
            builder.startPrefixMapping(this.prefix, this.uri);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StartPrefixMapping)) {
                return false;
            }
            StartPrefixMapping startPrefixMapping = (StartPrefixMapping)o;
            if (this.prefix != null ? !this.prefix.equals(startPrefixMapping.prefix) : startPrefixMapping.prefix != null) {
                return false;
            }
            return !(this.uri != null ? !this.uri.equals(startPrefixMapping.uri) : startPrefixMapping.uri != null);
        }

        public int hashCode() {
            int result = this.prefix != null ? this.prefix.hashCode() : 0;
            result = 29 * result + (this.uri != null ? this.uri.hashCode() : 0);
            return result;
        }
    }

    public static class StartElement
    implements Node {
        private final String namespaceURI;
        private final String localName;
        private final String qName;
        private final Attributes attrs;

        public StartElement(String namespaceURI, String localName, String qName, Attributes attrs) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.qName = qName;
            this.attrs = new AttributesImpl(attrs);
        }

        public boolean isMyEnd(Object element) {
            boolean itis = false;
            if (element instanceof EndElement) {
                EndElement end = (EndElement)element;
                itis = (this.namespaceURI == null ? end.namespaceURI == null : this.namespaceURI.equals(end.namespaceURI)) && this.qName.equals(end.qName);
            }
            return itis;
        }

        public String toString() {
            return '[' + this.namespaceURI + ',' + this.localName + ',' + this.qName + ']';
        }
    }

    public static class EndElement
    implements Node {
        private final String namespaceURI;
        private final String localName;
        private final String qName;

        public EndElement(String namespaceURI, String localName, String qName) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.qName = qName;
        }

        public String toString() {
            return '[' + this.namespaceURI + ',' + this.localName + ',' + this.qName + ']';
        }
    }

    public static class Characters
    implements Node {
        private final char[] ch;
        private final int start;
        private final int length;

        public Characters(char[] ch, int start, int length) {
            this.ch = new char[length];
            System.arraycopy(ch, start, this.ch, 0, length);
            this.start = 0;
            this.length = length;
        }

        public String toString() {
            return String.valueOf(this.ch, this.start, this.length);
        }
    }

    private static interface Node {
    }
}

