DnD.SimpleDraggable  = Class.create();

Object.extend(DnD.SimpleDraggable.prototype, DnD.Draggable.prototype);
Object.extend(DnD.SimpleDraggable.prototype, {
	initialize: function(id, options) {
		this.id = $(id);
		this.options = options;

		this.dragIndicatorId = this.options.dragIndicator;

        this.eventMouseDown = this.initDrag.bindAsEventListener(this);

		//Event.observe(this.id, "mousedown", this.eventMouseDown);
	},

	getDnDDragParams: function() {
		if (this.options.dndParams) {
			return this.options.dndParams.parseJSON();
		}
		
		return null;
	},

    getIndicator: function() {    	
    	var dragIndicator = $(this.dragIndicatorId);
        if (!dragIndicator) {
            dragIndicator = this.getOrCreateDefaultIndicator();
        }

        return dragIndicator;
    },

    ondragstart : function(event, drag) {
		drag.params = this.options.parameters;
		drag.params[this.id] = this.id;

		/*var attr = this.id.attributes["rich_f:draggableoptions"];
		if (attr) {
			Object.extend(drag.params, attr.value.parseJSON().parameters);
		}*/

		this.setIndicator(event);

		//this.dragEnter(event);
	},

	getContentType: function() {
		return this.options.dragType;
	},

	initDrag: function(event) {
		if(Event.isLeftClick(event)) {
		  var src = Event.element(event);
		  if(src.tagName && (
			src.tagName=='INPUT' ||
			src.tagName=='SELECT' ||
			src.tagName=='OPTION' ||
			src.tagName=='BUTTON' ||
			src.tagName=='TEXTAREA')) return;

			this.startDrag(event);
		}
	}
});