Tree.Item = Class.create();
Tree.Item.prototype = {
	initialize: function(id, tree, parent, index, switchType) {
		this.index = index;
		this.parent = parent;
		this.id = id;
		this.switchType = switchType;
		this.tree = $(tree);
		this.elements = {};
		($(id)).object = this;
		this.getElements();

		if (this.switchType=="client" && this.childs.length > 0) {
			if (this.elements.handle) {
				this.eventCollapsionClick = this.toggleCollapsion.bindAsEventListener(this);
				Event.observe(this.elements.handle, "click", this.eventCollapsionClick);
			}
		}
		this.eventSelectionClick = this.toggleSelection.bindAsEventListener(this);
		this.eventMouseOut = this.processMouseOut.bindAsEventListener(this);
		this.eventMouseOver = this.processMouseOver.bindAsEventListener(this);

		this.listenDragBound = this.listenDrag.bindAsEventListener(this);
		this.stopListenDragBound = this.stopListenDrag.bindAsEventListener(this);
		
		if (this.onContextMenu) {
			this.eventRightClick = this.onContextMenu.bindAsEventListener();
		}
	
		this.observeEvents();
	},
	
	observeEvents: function() {
		Event.observe(this.elements.icon, "mousedown", this.eventSelectionClick);
		Event.observe(this.elements.text, "mousedown", this.eventSelectionClick);
		Event.observe(this.elements.icon, "mouseout", this.eventMouseOut);
		Event.observe(this.elements.text, "mouseout", this.eventMouseOut);
		Event.observe(this.elements.icon, "mouseover", this.eventMouseOver);
		Event.observe(this.elements.text, "mouseover", this.eventMouseOver);
		if (this.eventRightClick) {
			this.elements.icon.oncontextmenu = this.eventRightClick;
			this.elements.text.oncontextmenu = this.eventRightClick;
		}
	},
	
	getElements: function() {
		($(this.id)).object = this;
		this.childs = [];
		var childsRowId = this.id + Tree.ID_DEVIDER + Tree.ID_CHILDS_ROW;
		this.elements.row = $(childsRowId);
		var handleId = this.id + Tree.ID_DEVIDER + Tree.ID_HANDLE;
		this.elements.handle = $(handleId);
		this.elements.handleImgExpanded = $(handleId + Tree.ID_DEVIDER + Tree.ID_HANDLE_IMG_EXPANDED);
		this.elements.handleImgCollapsed = $(handleId + Tree.ID_DEVIDER + Tree.ID_HANDLE_IMG_COLLAPSED);
		this.elements.icon = $(this.id + Tree.ID_DEVIDER + Tree.ID_ICON);
		this.elements.text = $(this.id + Tree.ID_DEVIDER + Tree.ID_TEXT);
		
		var contextMenu = this.elements.icon.attributes['rich:oncontextmenu'];
		if (contextMenu && contextMenu.value.length > 0) {
			this.onContextMenu = new Function(contextMenu.value + "; return true;");
		}
		
		var childsTd = $(childsRowId + Tree.ID_DEVIDER + Tree.ID_CHILDS_TD);
		if (childsTd) {
			for (var i = 0; i < childsTd.childNodes.length; i++) {
				var child = childsTd.childNodes[i];
				if (child.nodeType == 1 && child.tagName.toLowerCase() == "table") {
					this.addChild(new Tree.Item(child.id, this.tree, this, this.childs.length, this.switchType));
				}
			}
		}
	},

	addChild: function(child) {
		this.childs.push(child);
		this.tree.addItem(child);
	},

	toggleCollapsion: function() {

		if (this.hasChilds()) Element.toggle(this.elements.row);
		if (this.isCollapsed()) {
			this.elements.handleImgExpanded.style.display="none";
			this.elements.handleImgCollapsed.style.display="";
			if(Element.hasClassName(this.elements.icon, Tree.CLASS_ITEM_EXPANDED)) {
				Element.removeClassName(this.elements.icon, Tree.CLASS_ITEM_EXPANDED);
				Element.addClassName(this.elements.icon, Tree.CLASS_ITEM_COLLAPSED);
			}
			var props = new Object();
			props[Richfaces.TreeCollapseEvent] = true;
			props["collapsedNode"] = this.id;			
			Richfaces.createEvent("click", this.tree.element, null, props).fire();
		} else {
			this.elements.handleImgExpanded.style.display="";
			this.elements.handleImgCollapsed.style.display="none";
			if(Element.hasClassName(this.elements.icon, Tree.CLASS_ITEM_COLLAPSED)) {
				Element.removeClassName(this.elements.icon, Tree.CLASS_ITEM_COLLAPSED);
				Element.addClassName(this.elements.icon, Tree.CLASS_ITEM_EXPANDED);
			}
			var props = new Object();
			props[Richfaces.TreeExpandEvent] = true;
			props["expandedNode"] = this.id;			
			Richfaces.createEvent("click", this.tree.element, null, props).fire();
		}

	},

	collapse: function() {
		if (!this.isCollapsed() && this.switchType!="client") {
			this.elements.handle.onclick(); 
		}
		if (this.hasChilds() && !this.isCollapsed()) {
			Element.hide(this.elements.row);
			this.elements.handleImgExpanded.style.display="none";
			this.elements.handleImgCollapsed.style.display="";
			if(Element.hasClassName(this.elements.icon, Tree.CLASS_ITEM_EXPANDED)) {
				Element.removeClassName(this.elements.icon, Tree.CLASS_ITEM_EXPANDED);
				Element.addClassName(this.elements.icon, Tree.CLASS_ITEM_COLLAPSED);
			}
		}
		var props = new Object();
		props[Richfaces.TreeCollapseEvent] = true;
		props["collapsedNode"] = this.id;			
		Richfaces.createEvent("click", this.tree.element, null, props).fire();
	},

	expand: function() {
		if (this.isCollapsed() && this.switchType!="client") {
			this.elements.handle.onclick(); 
		}
		if (this.hasChilds() && this.isCollapsed()) {
			Element.show(this.elements.row);
			this.elements.handleImgExpanded.style.display="";
			this.elements.handleImgCollapsed.style.display="none";
			if(Element.hasClassName(this.elements.icon, Tree.CLASS_ITEM_COLLAPSED)) {
				Element.removeClassName(this.elements.icon, Tree.CLASS_ITEM_COLLAPSED);
				Element.addClassName(this.elements.icon, Tree.CLASS_ITEM_EXPANDED);
			}
		}
		var props = new Object();
		props[Richfaces.TreeExpandEvent] = true;
		props["expandedNode"] = this.id;			
		Richfaces.createEvent("click", this.tree.element, null, props).fire();
	},

	isCollapsed: function() {
		if (this.elements.row != null) {
			return this.elements.row.style.display == "none";
		} else {
			return true;
		}
	},

	processMouseOut: function(e) {
		if (this.isMouseIn) {
			this.isMouseIn = false;
			var classNames = this.elements.text.attributes['rich:highlightedclass'].nodeValue.split(' ')
			for (var i = 0; i < classNames.length; i++) {
				Element.removeClassName(this.elements.text, classNames[i]);
			}
			if (window.drag){
				this.dragLeave(e);
			}		
		}
	},

	processMouseOver: function(e) {
		if(!this.isMouseIn) {
			this.isMouseIn = true;
			var classNames = this.elements.text.attributes['rich:highlightedclass'].nodeValue.split(' ')
			for (var i = 0; i < classNames.length; i++) {
				Element.addClassName(this.elements.text, classNames[i]);
			}
			if (window.drag) {
				this.dragEnter(e);
			}	
		}
	},

	toggleSelection: function(e) {
		this.tree.deselectAll();

		var classNames = this.elements.text.attributes['rich:selectedclass'].nodeValue.split(' ')
		for (var i = 0; i < classNames.length; i++) {
			Element.addClassName(this.elements.text, classNames[i]);
		}
		this.tree.input.value = this.id;
		this.tree.selectionManager.activeItem = this;

		if (e) {
			this.fireSelectEvent();
		}	
			
		if (this.tree.options.onSelection) this.tree.options.onSelection(this.id);
		this.tree.showNode(this.elements.text.parentNode);

		if (e && e.type == "mousedown" /* can be keydown */) {
			if(Event.isLeftClick(e)) {    
			  var src = Event.element(e);
			  if(src.tagName && (
				src.tagName=='INPUT' ||
				src.tagName=='SELECT' ||
				src.tagName=='OPTION' ||
				src.tagName=='BUTTON' ||
				src.tagName=='TEXTAREA')) return;
	
				Event.observe(this.elements.icon, "mousemove", this.listenDragBound);
				Event.observe(this.elements.text, "mousemove", this.listenDragBound);
	
				Event.observe(this.elements.icon, "mouseup", this.stopListenDragBound);
				Event.observe(this.elements.text, "mouseup", this.stopListenDragBound);
			}
		}
	},

	fireSelectEvent: function() {
		var props = new Object();
		props[Richfaces.TreeSelectEvent] = true;
		props["selectedNode"] = this.id;			
		Richfaces.createEvent("click", this.tree.element, null, props).fire();
	},
	
	isSelected: function() {
		return Element.hasClassName(this.elements.text, Tree.CLASS_ITEM_SELECTED);
	},

	deselect: function() {
		var classNames = this.elements.text.attributes['rich:selectedclass'].nodeValue.split(' ')
		for (var i = 0; i < classNames.length; i++) {
			Element.removeClassName(this.elements.text, classNames[i]);
		}
	},

	next: function() {
		if (this.index < (this.parent.childs.length - 1)) {
			return this.parent.childs[this.index + 1];
		} else {
			return this;
		}
	},

	previous: function() {
		if (this.index > 0) {
			return this.parent.childs[this.index - 1];
		} else {
			return this;
		}
	},

	hasChilds: function() {
		return this.childs.length > 0;
	},
	
	listenDrag: function(e) {
		if (!this.dragStarted) {
			this.initDrag(e);

			this.dragStarted = true;
		}
	},
	
	stopListenDrag: function(e) {
		this.dragStarted = false;

		Event.stopObserving(this.elements.icon, "mousemove", this.listenDragBound);
		Event.stopObserving(this.elements.text, "mousemove", this.listenDragBound);

		Event.stopObserving(this.elements.icon, "mouseup", this.stopListenDragBound);
		Event.stopObserving(this.elements.text, "mouseup", this.stopListenDragBound);
	},

	initDrag: function(event) {
		this.startDrag(event);
	}
}
